/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.format;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackFormat;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackJsonData;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.format.OfflineYoutubeTrackFormatExtractor;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import dev.felnull.imp.include.org.apache.http.entity.ContentType;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StreamingDataFormatsExtractor
implements OfflineYoutubeTrackFormatExtractor {
    private static final Logger log = LoggerFactory.getLogger(StreamingDataFormatsExtractor.class);

    @Override
    public List<YoutubeTrackFormat> extract(YoutubeTrackJsonData data) {
        JsonBrowser streamingData = data.playerResponse.get("streamingData");
        if (streamingData.isNull()) {
            return Collections.emptyList();
        }
        JsonBrowser playabilityStatus = data.playerResponse.get("playabilityStatus");
        boolean isLive = data.playerResponse.get("videoDetails").get("isLive").asBoolean(false);
        if ("OK".equals(playabilityStatus.get("status").text()) && playabilityStatus.get("reason").safeText().contains("This live event has ended")) {
            isLive = true;
        }
        List<YoutubeTrackFormat> formats = this.loadTrackFormatsFromStreamingData(streamingData.get("formats"), isLive);
        formats.addAll(this.loadTrackFormatsFromStreamingData(streamingData.get("adaptiveFormats"), isLive));
        return formats;
    }

    private List<YoutubeTrackFormat> loadTrackFormatsFromStreamingData(JsonBrowser formats, boolean isLive) {
        ArrayList<YoutubeTrackFormat> tracks = new ArrayList<YoutubeTrackFormat>();
        boolean anyFailures = false;
        if (!formats.isNull() && formats.isList()) {
            for (JsonBrowser formatJson : formats.values()) {
                String url = formatJson.get("url").text();
                String cipher = formatJson.get("cipher").text();
                if (cipher == null) {
                    cipher = formatJson.get("signatureCipher").text();
                }
                Map cipherInfo = cipher != null ? DataFormatTools.decodeUrlEncodedItems(cipher, true) : Collections.emptyMap();
                Map<String, String> urlMap = DataFormatTools.isNullOrEmpty(url) ? DataFormatTools.decodeUrlEncodedItems((String)cipherInfo.get("url"), false) : DataFormatTools.decodeUrlEncodedItems(url, false);
                try {
                    long contentLength = formatJson.get("contentLength").asLong(Long.MAX_VALUE);
                    if (contentLength == Long.MAX_VALUE && !isLive) {
                        log.debug("Track not a live stream, but no contentLength in format {}, skipping", (Object)formatJson.format());
                        continue;
                    }
                    tracks.add(new YoutubeTrackFormat(ContentType.parse(formatJson.get("mimeType").text()), formatJson.get("bitrate").asLong(-1L), contentLength, formatJson.get("audioChannels").asLong(2L), cipherInfo.getOrDefault("url", url), urlMap.get("n"), (String)cipherInfo.get("s"), cipherInfo.getOrDefault("sp", "signature"), formatJson.get("audioTrack").get("audioIsDefault").asBoolean(true)));
                }
                catch (RuntimeException e) {
                    anyFailures = true;
                    log.debug("Failed to parse format {}, skipping", (Object)formatJson, (Object)e);
                }
            }
        }
        if (tracks.isEmpty() && anyFailures) {
            log.warn("In streamingData adaptive formats {}, all formats either failed to load or were skipped due to missing fields", (Object)formats.format());
        }
        return tracks;
    }
}

