/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.format;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackFormat;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackJsonData;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.format.OfflineYoutubeTrackFormatExtractor;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import dev.felnull.imp.include.org.apache.http.entity.ContentType;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LegacyStreamMapFormatsExtractor
implements OfflineYoutubeTrackFormatExtractor {
    private static final Logger log = LoggerFactory.getLogger(LegacyStreamMapFormatsExtractor.class);

    @Override
    public List<YoutubeTrackFormat> extract(YoutubeTrackJsonData data) {
        String formatStreamMap = data.polymerArguments.get("url_encoded_fmt_stream_map").text();
        if (formatStreamMap == null) {
            return Collections.emptyList();
        }
        return this.loadTrackFormatsFromFormatStreamMap(formatStreamMap);
    }

    private List<YoutubeTrackFormat> loadTrackFormatsFromFormatStreamMap(String adaptiveFormats) {
        ArrayList<YoutubeTrackFormat> tracks = new ArrayList<YoutubeTrackFormat>();
        boolean anyFailures = false;
        for (String formatString : adaptiveFormats.split(",")) {
            try {
                Map<String, String> format = DataFormatTools.decodeUrlEncodedItems(formatString, false);
                String url = format.get("url");
                if (url == null) continue;
                String contentLength = DataFormatTools.extractBetween(url, "clen=", "&");
                if (contentLength == null) {
                    log.debug("Could not find content length from URL {}, skipping format", (Object)url);
                    continue;
                }
                tracks.add(new YoutubeTrackFormat(ContentType.parse(format.get("type")), this.qualityToBitrateValue(format.get("quality")), Long.parseLong(contentLength), 2L, url, "", format.get("s"), format.getOrDefault("sp", "signature"), true));
            }
            catch (RuntimeException e) {
                anyFailures = true;
                log.debug("Failed to parse format {}, skipping.", (Object)formatString, (Object)e);
            }
        }
        if (tracks.isEmpty() && anyFailures) {
            log.warn("In adaptive format map {}, all formats either failed to load or were skipped due to missing fields", (Object)adaptiveFormats);
        }
        return tracks;
    }

    private long qualityToBitrateValue(String quality) {
        if ("small".equals(quality)) {
            return -10L;
        }
        if ("medium".equals(quality)) {
            return -5L;
        }
        if ("hd720".equals(quality)) {
            return -4L;
        }
        return -1L;
    }
}

