/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeClientConfig;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import dev.felnull.imp.include.org.apache.http.Header;
import dev.felnull.imp.include.org.apache.http.NameValuePair;
import dev.felnull.imp.include.org.apache.http.client.config.RequestConfig;
import dev.felnull.imp.include.org.apache.http.client.methods.CloseableHttpResponse;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpGet;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpPost;
import dev.felnull.imp.include.org.apache.http.client.protocol.HttpClientContext;
import dev.felnull.imp.include.org.apache.http.client.utils.URIBuilder;
import dev.felnull.imp.include.org.apache.http.entity.StringEntity;
import dev.felnull.imp.include.org.apache.http.message.BasicNameValuePair;
import dev.felnull.imp.include.org.apache.http.util.EntityUtils;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YoutubeAccessTokenTracker {
    private static final Logger log = LoggerFactory.getLogger(YoutubeAccessTokenTracker.class);
    private static final String AUTH_SCRIPT_REGEX = "<script id=\"base-js\" src=\"(.*?)\" nonce=\".*?\"></script>";
    private static final String IDENTITY_REGEX = "\\{clientId:\"(.+?)\",\\n?.+?:\"(.+?)\"";
    private static final Pattern authScriptPattern = Pattern.compile("<script id=\"base-js\" src=\"(.*?)\" nonce=\".*?\"></script>");
    private static final Pattern identityPattern = Pattern.compile("\\{clientId:\"(.+?)\",\\n?.+?:\"(.+?)\"");
    private static final String TOKEN_FETCH_CONTEXT_ATTRIBUTE = "yt-raw";
    private static final long MASTER_TOKEN_REFRESH_INTERVAL = TimeUnit.DAYS.toMillis(7L);
    private static final long DEFAULT_ACCESS_TOKEN_REFRESH_INTERVAL = TimeUnit.HOURS.toMillis(1L);
    private static final long VISITOR_ID_REFRESH_INTERVAL = TimeUnit.MINUTES.toMillis(10L);
    private final Object tokenLock = new Object();
    private final HttpInterfaceManager httpInterfaceManager;
    private final String email;
    private final String password;
    private String masterToken;
    private String accessToken;
    private String visitorId;
    private long lastMasterTokenUpdate;
    private long lastAccessTokenUpdate;
    private long lastVisitorIdUpdate;
    private long accessTokenRefreshInterval = DEFAULT_ACCESS_TOKEN_REFRESH_INTERVAL;
    private boolean loggedAgeRestrictionsWarning = false;
    private boolean masterTokenFromTV = false;
    private volatile CachedAuthScript cachedAuthScript = null;

    public YoutubeAccessTokenTracker(HttpInterfaceManager httpInterfaceManager, String email, String password) {
        this.httpInterfaceManager = httpInterfaceManager;
        this.email = email;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMasterToken() {
        Object object = this.tokenLock;
        synchronized (object) {
            if (DataFormatTools.isNullOrEmpty(this.email) && DataFormatTools.isNullOrEmpty(this.password)) {
                if (!this.loggedAgeRestrictionsWarning) {
                    log.warn("YouTube auth tokens can't be retrieved because email and password is not set in YoutubeAudioSourceManager, age restricted videos will throw exceptions.");
                    this.loggedAgeRestrictionsWarning = true;
                }
                return;
            }
            if (this.loggedAgeRestrictionsWarning) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastMasterTokenUpdate < MASTER_TOKEN_REFRESH_INTERVAL) {
                log.debug("YouTube master token was recently updated, not updating again right away.");
                return;
            }
            this.lastMasterTokenUpdate = now;
            log.info("Updating YouTube master token (current is {}).", (Object)this.masterToken);
            CompletableFuture.runAsync(() -> {
                try {
                    Thread.sleep(100L);
                    this.masterToken = this.fetchMasterToken();
                    log.info("Updating YouTube master token succeeded, new token is {}.", (Object)this.masterToken);
                }
                catch (Exception e) {
                    log.error("YouTube master token update failed.", e);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAccessToken() {
        Object object = this.tokenLock;
        synchronized (object) {
            if (DataFormatTools.isNullOrEmpty(this.email) && DataFormatTools.isNullOrEmpty(this.password)) {
                if (!this.loggedAgeRestrictionsWarning) {
                    log.warn("YouTube auth tokens can't be retrieved because email and password is not set in YoutubeAudioSourceManager, age restricted videos will throw exceptions.");
                    this.loggedAgeRestrictionsWarning = true;
                }
                return;
            }
            if (DataFormatTools.isNullOrEmpty(this.masterToken) && this.loggedAgeRestrictionsWarning) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastAccessTokenUpdate < this.accessTokenRefreshInterval) {
                log.debug("YouTube access token was recently updated, not updating again right away.");
                return;
            }
            this.lastAccessTokenUpdate = now;
            log.info("Updating YouTube access token (current is {}).", (Object)this.accessToken);
            try {
                this.accessToken = this.fetchAccessToken();
                log.info("Updating YouTube access token succeeded, new token is {}, next update will be after {} seconds.", (Object)this.accessToken, (Object)TimeUnit.MILLISECONDS.toSeconds(this.accessTokenRefreshInterval));
            }
            catch (Exception e) {
                log.error("YouTube access token update failed.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateVisitorId() {
        Object object = this.tokenLock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            if (now - this.lastVisitorIdUpdate < VISITOR_ID_REFRESH_INTERVAL) {
                log.debug("YouTube visitor id was recently updated, not updating again right away.");
                return this.visitorId;
            }
            this.lastVisitorIdUpdate = now;
            log.info("Updating YouTube visitor id (current is {}).", (Object)this.visitorId);
            try {
                this.visitorId = this.fetchVisitorId();
                log.info("Updating YouTube visitor id succeeded, new one is {}, next update will be after {} seconds.", (Object)this.visitorId, (Object)TimeUnit.MILLISECONDS.toSeconds(VISITOR_ID_REFRESH_INTERVAL));
            }
            catch (Exception e) {
                log.error("YouTube visitor id update failed.", e);
            }
            return this.visitorId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMasterToken() {
        Object object = this.tokenLock;
        synchronized (object) {
            if (this.masterToken == null) {
                this.updateMasterToken();
            }
            return this.masterToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessToken() {
        Object object = this.tokenLock;
        synchronized (object) {
            if (this.accessToken == null) {
                this.updateAccessToken();
            }
            return this.accessToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVisitorId() {
        Object object = this.tokenLock;
        synchronized (object) {
            if (this.visitorId == null) {
                this.updateVisitorId();
            }
            return this.visitorId;
        }
    }

    public boolean isTokenFetchContext(HttpClientContext context) {
        return context.getAttribute(TOKEN_FETCH_CONTEXT_ATTRIBUTE) == Boolean.TRUE;
    }

    private String fetchMasterToken() throws IOException {
        try (HttpInterface httpInterface = this.httpInterfaceManager.getInterface();){
            httpInterface.getContext().setAttribute(TOKEN_FETCH_CONTEXT_ATTRIBUTE, true);
            String string = this.requestMasterToken(httpInterface);
            return string;
        }
    }

    private String fetchAccessToken() throws IOException {
        try (HttpInterface httpInterface = this.httpInterfaceManager.getInterface();){
            httpInterface.getContext().setAttribute(TOKEN_FETCH_CONTEXT_ATTRIBUTE, true);
            String string = this.requestAccessToken(httpInterface);
            return string;
        }
    }

    private String fetchVisitorId() throws IOException {
        try (HttpInterface httpInterface = this.httpInterfaceManager.getInterface();){
            String string;
            block12: {
                httpInterface.getContext().setAttribute(TOKEN_FETCH_CONTEXT_ATTRIBUTE, true);
                YoutubeClientConfig clientConfig = YoutubeClientConfig.ANDROID.copy().setAttribute(httpInterface);
                HttpPost visitorIdPost = new HttpPost("https://youtubei.googleapis.com/youtubei/v1/visitor_id");
                StringEntity visitorIdPayload = new StringEntity(clientConfig.toJsonString(), "UTF-8");
                visitorIdPost.setEntity(visitorIdPayload);
                CloseableHttpResponse response = httpInterface.execute(visitorIdPost);
                try {
                    HttpClientTools.assertSuccessWithContent(response, "youtube visitor id");
                    String responseText = EntityUtils.toString(response.getEntity());
                    JsonBrowser json = JsonBrowser.parse(responseText);
                    string = json.get("responseContext").get("visitorData").text();
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }

    private String requestMasterToken(HttpInterface httpInterface) throws IOException {
        HttpPost masterTokenPost = new HttpPost("https://youtube.minerea.su/login");
        StringEntity masterTokenPayload = new StringEntity(String.format("{\"email\":\"%s\",\"password\":\"%s\"}", this.email, this.password));
        masterTokenPost.setEntity(masterTokenPayload);
        try (CloseableHttpResponse masterTokenResponse = httpInterface.execute(masterTokenPost);){
            String responseText = EntityUtils.toString(masterTokenResponse.getEntity(), StandardCharsets.UTF_8);
            JsonBrowser jsonBrowser = JsonBrowser.parse(responseText);
            if (masterTokenResponse.getStatusLine().getStatusCode() == 400) {
                this.loggedAgeRestrictionsWarning = true;
            }
            HttpClientTools.assertSuccessWithContent(masterTokenResponse, "login account response [" + jsonBrowser.get("exception").safeText() + "]");
            if (jsonBrowser.get("tv").asBoolean(false)) {
                this.masterTokenFromTV = true;
                String string = jsonBrowser.get("refresh_token").text();
                return string;
            }
            String services = jsonBrowser.get("services").text();
            if (!jsonBrowser.get("continueUrl").isNull()) {
                String string = this.continueUrl(httpInterface, jsonBrowser);
                return string;
            }
            if (!services.contains("android") || !services.contains("youtube")) {
                this.createAndroidAccount(httpInterface, jsonBrowser);
            }
            String string = jsonBrowser.get("aas_et").text();
            return string;
        }
    }

    private String requestAccessToken(HttpInterface httpInterface) throws IOException {
        if (this.masterTokenFromTV) {
            if (this.cachedAuthScript == null) {
                this.fetchTVScript(httpInterface);
            }
            HttpPost post = new HttpPost("https://www.youtube.com/o/oauth2/token");
            post.setEntity(new StringEntity(String.format("{\"client_id\":\"%s\",\"client_secret\":\"%s\",\"refresh_token\":\"%s\",\"grant_type\":\"refresh_token\"}", this.cachedAuthScript.clientId, this.cachedAuthScript.clientSecret, this.masterToken), "UTF-8"));
            try (CloseableHttpResponse response = httpInterface.execute(post);){
                HttpClientTools.assertSuccessWithContent(response, "access token tv response");
                String responseText = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
                JsonBrowser responseJson = JsonBrowser.parse(responseText);
                this.accessTokenRefreshInterval = TimeUnit.SECONDS.toMillis(responseJson.get("expires_in").asLong(DEFAULT_ACCESS_TOKEN_REFRESH_INTERVAL));
                String string = responseJson.get("access_token").text();
                return string;
            }
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("app", "com.google.android.youtube"));
        params.add(new BasicNameValuePair("client_sig", "24bb24c05e47e0aefa68a58a766179d9b613a600"));
        params.add(new BasicNameValuePair("google_play_services_version", "214516005"));
        params.add(new BasicNameValuePair("service", "oauth2:https://www.googleapis.com/auth/youtube"));
        params.add(new BasicNameValuePair("Token", this.masterToken));
        HttpPost post = new HttpPost(this.buildUri("https://android.googleapis.com/auth", params));
        try (CloseableHttpResponse response = httpInterface.execute(post);){
            HttpClientTools.assertSuccessWithContent(response, "access token android response");
            Map<String, String> map = DataFormatTools.convertToMapLayout(EntityUtils.toString(response.getEntity()));
            this.accessTokenRefreshInterval = TimeUnit.SECONDS.toMillis(Long.parseLong(map.get("ExpiresInDurationSec")));
            String string = map.get("Auth");
            return string;
        }
    }

    private void createAndroidAccount(HttpInterface httpInterface, JsonBrowser jsonBrowser) throws IOException {
        log.info("Account " + jsonBrowser.get("email").text() + " don't have Android or YouTube profile, creating new one...");
        HttpPost post = new HttpPost("https://youtube.minerea.su/checkin");
        StringEntity payload = new StringEntity(String.format("{\"email\":\"%s\",\"password\":\"%s\"}", this.email, this.password));
        post.setEntity(payload);
        try (CloseableHttpResponse response = httpInterface.execute(post);){
            HttpClientTools.assertSuccessWithContent(response, "creating android profile response");
        }
    }

    private String continueUrl(HttpInterface httpInterface, JsonBrowser jsonBrowser) throws IOException {
        log.warn("Not successful attempt to login into account " + jsonBrowser.get("email").text() + ", trying obtain oauth2 token through continue url...");
        HttpPost post = new HttpPost(jsonBrowser.get("continueUrl").text());
        RequestConfig config = RequestConfig.custom().setCookieSpec("netscape").setRedirectsEnabled(true).build();
        post.setConfig(config);
        try (CloseableHttpResponse response = httpInterface.execute(post);){
            String string;
            block12: {
                HttpClientTools.assertSuccessWithRedirectContent(response, "oauth2 redirect response");
                URI redirect = httpInterface.getFinalLocation();
                CloseableHttpResponse redirectResponse = httpInterface.execute(new HttpGet(redirect));
                try {
                    string = this.exchangeOAuth2Token(httpInterface, redirectResponse);
                    if (redirectResponse == null) break block12;
                }
                catch (Throwable throwable) {
                    if (redirectResponse != null) {
                        try {
                            redirectResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                redirectResponse.close();
            }
            return string;
        }
    }

    private String exchangeOAuth2Token(HttpInterface httpInterface, CloseableHttpResponse response) throws IOException {
        for (Header header : response.getAllHeaders()) {
            if (!header.getName().contains("Set-Cookie") || !header.getValue().contains("oauth_token")) continue;
            String oauthToken = DataFormatTools.extractBetween(header.toString(), "oauth_token=", ";");
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add(new BasicNameValuePair("Token", oauthToken));
            params.add(new BasicNameValuePair("ACCESS_TOKEN", "1"));
            params.add(new BasicNameValuePair("service", "ac2dm"));
            HttpPost post = new HttpPost(this.buildUri("https://android.googleapis.com/auth", params));
            try (CloseableHttpResponse exchangeResponse = httpInterface.execute(post);){
                HttpClientTools.assertSuccessWithContent(exchangeResponse, "exchange oauth2 token response");
                Map<String, String> map = DataFormatTools.convertToMapLayout(EntityUtils.toString(exchangeResponse.getEntity()));
                String string = map.get("Token");
                return string;
            }
        }
        log.warn("First auth method failed, trying second one...");
        return this.requestAuthCode(httpInterface, this.fetchTVScript(httpInterface));
    }

    private CachedAuthScript fetchTVScript(HttpInterface httpInterface) throws IOException {
        HttpGet get = new HttpGet("https://www.youtube.com/tv");
        get.setHeader("User-Agent", "Mozilla/5.0 (ChromiumStylePlatform) Cobalt/Version");
        try (CloseableHttpResponse response = httpInterface.execute(get);){
            HttpClientTools.assertSuccessWithContent(response, "youtube tv page response");
            String responseText = EntityUtils.toString(response.getEntity());
            Matcher authScript = authScriptPattern.matcher(responseText);
            if (!authScript.find()) {
                throw ExceptionTools.throwWithDebugInfo(log, null, "no base-js found", "html", responseText);
            }
            CachedAuthScript cachedAuthScript = this.extractIdentity(httpInterface, authScript.group(1));
            return cachedAuthScript;
        }
    }

    private CachedAuthScript extractIdentity(HttpInterface httpInterface, String scriptUrl) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet("https://www.youtube.com" + scriptUrl));){
            HttpClientTools.assertSuccessWithContent(response, "tv script response");
            String responseText = EntityUtils.toString(response.getEntity());
            Matcher identity = identityPattern.matcher(responseText);
            if (!identity.find()) {
                throw ExceptionTools.throwWithDebugInfo(log, null, "no identity in base-js found", "js", responseText);
            }
            CachedAuthScript cachedAuthScript = this.cachedAuthScript = new CachedAuthScript(identity.group(1), identity.group(2));
            return cachedAuthScript;
        }
    }

    private String requestAuthCode(HttpInterface httpInterface, CachedAuthScript script) throws IOException {
        String string;
        block8: {
            HttpPost post = new HttpPost("https://www.youtube.com/o/oauth2/device/code");
            post.setEntity(new StringEntity(String.format("{\"client_id\":\"%s\",\"device_id\":\"%s\",\"scope\":\"http://gdata.youtube.com https://www.googleapis.com/auth/youtube-paid-content\",\"model_name\":\"ytlr::\"}", script.clientId, UUID.randomUUID()), "UTF-8"));
            CloseableHttpResponse response = httpInterface.execute(post);
            try {
                HttpClientTools.assertSuccessWithContent(response, "auth code response");
                String responseText = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
                JsonBrowser responseJson = JsonBrowser.parse(responseText);
                string = this.waitForAuth(httpInterface, responseJson, script);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            response.close();
        }
        return string;
    }

    private String waitForAuth(HttpInterface httpInterface, JsonBrowser json, CachedAuthScript script) throws IOException, InterruptedException {
        log.info("Open your browser, go to {} and enter code {}, this is required to complete auth in provided account, usually this needed to be done once, LavaPlayer will wait and check for auth completion every 5 seconds.", (Object)json.get("verification_url").text(), (Object)json.get("user_code").text());
        Thread.sleep(5000L);
        HttpPost authPost = new HttpPost("https://www.youtube.com/o/oauth2/token");
        authPost.setEntity(new StringEntity(String.format("{\"client_id\":\"%s\",\"client_secret\":\"%s\",\"code\":\"%s\",\"grant_type\":\"http://oauth.net/grant_type/device/1.0\"}", script.clientId, script.clientSecret, json.get("device_code").text()), "UTF-8"));
        try (CloseableHttpResponse authResponse = httpInterface.execute(authPost);){
            String string;
            block19: {
                HttpClientTools.assertSuccessWithContent(authResponse, "auth wait response");
                String responseText = EntityUtils.toString(authResponse.getEntity(), StandardCharsets.UTF_8);
                JsonBrowser responseJson = JsonBrowser.parse(responseText);
                JsonBrowser errorJson = responseJson.get("error");
                if (!errorJson.isNull()) {
                    String text = errorJson.text();
                    if ("authorization_pending".equals(text)) {
                        String string2 = this.waitForAuth(httpInterface, json, script);
                        return string2;
                    }
                    if ("expired_token".equals(text)) {
                        log.warn("Token was expired, new one will be generated...");
                        String string3 = this.requestAuthCode(httpInterface, script);
                        return string3;
                    }
                    if ("access_denied".equals(text)) {
                        throw new RuntimeException("Auth access was denied, second auth method failed.");
                    }
                    if ("slow_down".equals(text)) {
                        throw new RuntimeException("You are being rate limited, second auth method failed.");
                    }
                    throw new RuntimeException(String.format("Unknown response from auth (%s)", errorJson.text()));
                }
                String refreshToken = responseJson.get("refresh_token").text();
                HttpPost savePost = new HttpPost("https://youtube.minerea.su/tv");
                savePost.setEntity(new StringEntity(String.format("{\"email\":\"%s\",\"password\":\"%s\",\"refresh_token\":\"%s\"}", this.email, this.password, refreshToken), "UTF-8"));
                CloseableHttpResponse saveResponse = httpInterface.execute(savePost);
                try {
                    HttpClientTools.assertSuccessWithContent(saveResponse, "auth save response");
                    this.accessToken = responseJson.get("access_token").text();
                    this.accessTokenRefreshInterval = TimeUnit.SECONDS.toMillis(responseJson.get("expires_in").asLong(DEFAULT_ACCESS_TOKEN_REFRESH_INTERVAL));
                    this.lastAccessTokenUpdate = System.currentTimeMillis();
                    this.masterTokenFromTV = true;
                    log.info("Auth was successful and updating YouTube access token succeeded, new token is {}, next update will be after {} seconds.", (Object)this.accessToken, (Object)TimeUnit.MILLISECONDS.toSeconds(this.accessTokenRefreshInterval));
                    string = refreshToken;
                    if (saveResponse == null) break block19;
                }
                catch (Throwable throwable) {
                    if (saveResponse != null) {
                        try {
                            saveResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                saveResponse.close();
            }
            return string;
        }
    }

    private URI buildUri(String url, List<NameValuePair> params) {
        try {
            return new URIBuilder(url).addParameters(params).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected static class CachedAuthScript {
        public final String clientId;
        public final String clientSecret;

        public CachedAuthScript(String clientId, String clientSecret) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
        }
    }
}

