/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.soundcloud;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudFormatHandler;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudM3uInfo;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudMp3SegmentDecoder;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudOpusSegmentDecoder;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudTrackFormat;
import java.util.List;

public class DefaultSoundCloudFormatHandler
implements SoundCloudFormatHandler {
    private static final FormatType[] TYPES = FormatType.values();

    @Override
    public SoundCloudTrackFormat chooseBestFormat(List<SoundCloudTrackFormat> formats) {
        for (FormatType type : TYPES) {
            for (SoundCloudTrackFormat format : formats) {
                if (!type.matches(format)) continue;
                return format;
            }
        }
        throw new RuntimeException("Did not detect any supported formats");
    }

    @Override
    public String buildFormatIdentifier(SoundCloudTrackFormat format) {
        for (FormatType type : TYPES) {
            if (!type.matches(format)) continue;
            return type.prefix + format.getLookupUrl();
        }
        return "X:" + format.getLookupUrl();
    }

    @Override
    public SoundCloudM3uInfo getM3uInfo(String identifier) {
        if (identifier.startsWith(FormatType.TYPE_M3U_OPUS.prefix)) {
            return new SoundCloudM3uInfo(identifier.substring(2), SoundCloudOpusSegmentDecoder::new);
        }
        if (identifier.startsWith(FormatType.TYPE_M3U_MP3.prefix)) {
            return new SoundCloudM3uInfo(identifier.substring(2), SoundCloudMp3SegmentDecoder::new);
        }
        return null;
    }

    @Override
    public String getMp3LookupUrl(String identifier) {
        if (identifier.startsWith("M:")) {
            return identifier.substring(2);
        }
        return null;
    }

    private static SoundCloudTrackFormat findFormat(List<SoundCloudTrackFormat> formats, FormatType type) {
        for (SoundCloudTrackFormat format : formats) {
            if (!type.matches(format)) continue;
            return format;
        }
        return null;
    }

    private static enum FormatType {
        TYPE_M3U_OPUS("hls", "audio/ogg", "O:"),
        TYPE_M3U_MP3("hls", "audio/mpeg", "U:"),
        TYPE_SIMPLE_MP3("progressive", "audio/mpeg", "M:");

        public final String protocol;
        public final String mimeType;
        public final String prefix;

        private FormatType(String protocol, String mimeType, String prefix) {
            this.protocol = protocol;
            this.mimeType = mimeType;
            this.prefix = prefix;
        }

        public boolean matches(SoundCloudTrackFormat format) {
            return this.protocol.equals(format.getProtocol()) && format.getMimeType().contains(this.mimeType);
        }
    }
}

