/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.http;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.MediaContainerDescriptor;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.http.HttpAudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.net.URI;

public class HttpAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(HttpAudioTrack.class);
    private final MediaContainerDescriptor containerTrackFactory;
    private final HttpAudioSourceManager sourceManager;

    public HttpAudioTrack(AudioTrackInfo trackInfo, MediaContainerDescriptor containerTrackFactory, HttpAudioSourceManager sourceManager) {
        super(trackInfo);
        this.containerTrackFactory = containerTrackFactory;
        this.sourceManager = sourceManager;
    }

    public MediaContainerDescriptor getContainerTrackFactory() {
        return this.containerTrackFactory;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            log.debug("Starting http track from URL: {}", (Object)this.trackInfo.identifier);
            try (PersistentHttpStream inputStream = new PersistentHttpStream(httpInterface, new URI(this.trackInfo.identifier), Long.MAX_VALUE);){
                this.processDelegate((InternalAudioTrack)this.containerTrackFactory.createTrack(this.trackInfo, inputStream), localExecutor);
            }
        }
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new HttpAudioTrack(this.trackInfo, this.containerTrackFactory, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

