/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.MessageInput;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.MessageOutput;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioItem;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.DecodedTrackHolder;
import dev.felnull.imp.include.org.apache.http.client.config.RequestConfig;
import dev.felnull.imp.include.org.apache.http.impl.client.HttpClientBuilder;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public interface AudioPlayerManager {
    public void shutdown();

    public void enableGcMonitoring();

    public void registerSourceManager(AudioSourceManager var1);

    default public void registerSourceManagers(AudioSourceManager ... sourceManagers) {
        for (AudioSourceManager sourceManager : sourceManagers) {
            this.registerSourceManager(sourceManager);
        }
    }

    public <T extends AudioSourceManager> T source(Class<T> var1);

    public List<AudioSourceManager> getSourceManagers();

    default public Future<Void> loadItem(String identifier, AudioLoadResultHandler resultHandler) {
        return this.loadItem(new AudioReference(identifier, null), resultHandler);
    }

    public Future<Void> loadItem(AudioReference var1, AudioLoadResultHandler var2);

    default public void loadItemSync(String identifier, AudioLoadResultHandler resultHandler) {
        this.loadItemSync(new AudioReference(identifier, null), resultHandler);
    }

    public void loadItemSync(AudioReference var1, AudioLoadResultHandler var2);

    @Nullable
    default public AudioItem loadItemSync(String reference) {
        return this.loadItemSync(new AudioReference(reference, null));
    }

    @Nullable
    public AudioItem loadItemSync(AudioReference var1);

    default public Future<Void> loadItemOrdered(Object orderingKey, String identifier, AudioLoadResultHandler resultHandler) {
        return this.loadItemOrdered(orderingKey, new AudioReference(identifier, null), resultHandler);
    }

    public Future<Void> loadItemOrdered(Object var1, AudioReference var2, AudioLoadResultHandler var3);

    public void encodeTrack(MessageOutput var1, AudioTrack var2) throws IOException;

    public DecodedTrackHolder decodeTrack(MessageInput var1) throws IOException;

    public AudioConfiguration getConfiguration();

    public boolean isUsingSeekGhosting();

    public void setUseSeekGhosting(boolean var1);

    public int getFrameBufferDuration();

    public void setFrameBufferDuration(int var1);

    public void setTrackStuckThreshold(long var1);

    public void setPlayerCleanupThreshold(long var1);

    public void setItemLoaderThreadPoolSize(int var1);

    public AudioPlayer createPlayer();

    public void setHttpRequestConfigurator(Function<RequestConfig, RequestConfig> var1);

    public void setHttpBuilderConfigurator(Consumer<HttpClientBuilder> var1);
}

