/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.filter.equalizer;

public class EqualizerConfiguration {
    protected final float[] bandMultipliers;

    public EqualizerConfiguration(float[] bandMultipliers) {
        this.bandMultipliers = bandMultipliers;
    }

    public void setGain(int band, float value) {
        if (this.isValidBand(band)) {
            this.bandMultipliers[band] = Math.max(Math.min(value, 1.0f), -0.25f);
        }
    }

    public float getGain(int band) {
        if (this.isValidBand(band)) {
            return this.bandMultipliers[band];
        }
        return 0.0f;
    }

    private boolean isValidBand(int band) {
        return band >= 0 && band < this.bandMultipliers.length;
    }
}

