/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.filter;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.filter.AudioPostProcessor;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkEncoder;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.MutableAudioFrame;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class BufferingPostProcessor
implements AudioPostProcessor {
    private final AudioProcessingContext context;
    private final AudioChunkEncoder encoder;
    private final MutableAudioFrame offeredFrame;
    private final ByteBuffer outputBuffer;

    public BufferingPostProcessor(AudioProcessingContext context, AudioChunkEncoder encoder) {
        this.encoder = encoder;
        this.context = context;
        this.offeredFrame = new MutableAudioFrame();
        this.outputBuffer = ByteBuffer.allocateDirect(context.outputFormat.maximumChunkSize());
        this.offeredFrame.setFormat(context.outputFormat);
    }

    @Override
    public void process(long timecode, ShortBuffer buffer) throws InterruptedException {
        this.outputBuffer.clear();
        this.encoder.encode(buffer, this.outputBuffer);
        this.offeredFrame.setTimecode(timecode);
        this.offeredFrame.setVolume(this.context.playerOptions.volumeLevel.get());
        this.offeredFrame.setBuffer(this.outputBuffer);
        this.context.frameBuffer.consume(this.offeredFrame);
    }

    @Override
    public void close() {
        this.encoder.close();
    }
}

