/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.flac;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.BitBufferReader;
import java.nio.ByteBuffer;

public class FlacStreamInfo {
    public static final int LENGTH = 34;
    public final int minimumBlockSize;
    public final int maximumBlockSize;
    public final int minimumFrameSize;
    public final int maximumFrameSize;
    public final int sampleRate;
    public final int channelCount;
    public final int bitsPerSample;
    public final long sampleCount;
    public final byte[] md5Signature;
    public final boolean hasMetadataBlocks;

    public FlacStreamInfo(byte[] blockData, boolean hasMetadataBlocks) {
        BitBufferReader bitReader = new BitBufferReader(ByteBuffer.wrap(blockData));
        this.minimumBlockSize = bitReader.asInteger(16);
        this.maximumBlockSize = bitReader.asInteger(16);
        this.minimumFrameSize = bitReader.asInteger(24);
        this.maximumFrameSize = bitReader.asInteger(24);
        this.sampleRate = bitReader.asInteger(20);
        this.channelCount = bitReader.asInteger(3) + 1;
        this.bitsPerSample = bitReader.asInteger(5) + 1;
        this.sampleCount = bitReader.asLong(36);
        this.md5Signature = new byte[16];
        System.arraycopy(blockData, 18, this.md5Signature, 0, 16);
        this.hasMetadataBlocks = hasMetadataBlocks;
    }
}

