/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.felnull.imp.api.client.IamMusicPlayerClientAPI;
import dev.felnull.imp.api.client.MusicEngineAccess;
import dev.felnull.imp.api.client.MusicPlayerAccess;
import dev.felnull.imp.api.client.MusicSpeakerAccess;
import dev.felnull.imp.include.dev.felnull.fnjl.math.FNVec3f;
import dev.felnull.imp.include.dev.felnull.fnjl.util.FNForUtil;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.openal.AL11;

public class DebugSpeakerRangeRenderer {
    public static void render(PoseStack poseStack, MultiBufferSource multiBufferSource, double camX, double camY, double camZ) {
        MusicEngineAccess me = IamMusicPlayerClientAPI.getInstance().getMusicEngine();
        for (MusicPlayerAccess player : me.getMusicPlayers().values()) {
            for (MusicSpeakerAccess speaker : player.getSpeakers().values()) {
                DebugSpeakerRangeRenderer.renderSpeaker(poseStack, multiBufferSource, camX, camY, camZ, player, speaker);
            }
        }
    }

    private static void renderSpeaker(PoseStack poseStack, MultiBufferSource multiBufferSource, double camX, double camY, double camZ, MusicPlayerAccess playerAccess, MusicSpeakerAccess speaker) {
        VertexConsumer lineVC = multiBufferSource.m_6299_(RenderType.m_110504_());
        Vec3 pos = speaker.getInfo().getPosition();
        float x = (float)(pos.m_7096_() - camX);
        float y = (float)(pos.m_7098_() - camY);
        float z = (float)(pos.m_7094_() - camZ);
        Vec3 listener = DebugSpeakerRangeRenderer.getListenerPos();
        double distance = listener.m_82554_(speaker.getInfo().getPosition());
        boolean inRange = distance <= (double)speaker.getInfo().getRange();
        DebugSpeakerRangeRenderer.renderLineBox(poseStack, lineVC, x, y, z, -0.05f, -0.05f, -0.05f, 0.05f, 0.05f, 0.05f, -1);
        float range = speaker.getInfo().getRange();
        DebugSpeakerRangeRenderer.renderLine(poseStack, lineVC, x, y, z, -range, 0.0f, 0.0f, range, 0.0f, 0.0f, -16776961);
        DebugSpeakerRangeRenderer.renderLine(poseStack, lineVC, x, y, z, 0.0f, -range, 0.0f, 0.0f, range, 0.0f, -16776961);
        DebugSpeakerRangeRenderer.renderLine(poseStack, lineVC, x, y, z, 0.0f, 0.0f, -range, 0.0f, 0.0f, range, -16776961);
        DebugSpeakerRangeRenderer.renderLineSphere(poseStack, lineVC, x, y, z, range, Mth.m_14045_((int)((int)range), (int)3, (int)50), !playerAccess.isLoaded() ? -256 : (inRange ? -16711936 : -65536));
    }

    private static void renderLineSphere(PoseStack poseStack, VertexConsumer vertexConsumer, float x, float y, float z, float range, int corner, int color) {
        DebugSpeakerRangeRenderer.renderLineQuarterSphereX(poseStack, vertexConsumer, x, y, z, range, range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereX(poseStack, vertexConsumer, x, y, z, range, -range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereX(poseStack, vertexConsumer, x, y, z, -range, range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereX(poseStack, vertexConsumer, x, y, z, -range, -range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereY(poseStack, vertexConsumer, x, y, z, range, range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereY(poseStack, vertexConsumer, x, y, z, range, -range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereY(poseStack, vertexConsumer, x, y, z, -range, range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereY(poseStack, vertexConsumer, x, y, z, -range, -range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereZ(poseStack, vertexConsumer, x, y, z, range, range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereZ(poseStack, vertexConsumer, x, y, z, range, -range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereZ(poseStack, vertexConsumer, x, y, z, -range, range, corner, color);
        DebugSpeakerRangeRenderer.renderLineQuarterSphereZ(poseStack, vertexConsumer, x, y, z, -range, -range, corner, color);
    }

    private static void renderLineQuarterSphereX(PoseStack poseStack, VertexConsumer vertexConsumer, float x, float y, float z, float rangeX, float rangeY, int corner, int color) {
        float oneDegree = 90.0f / (float)(corner + 1);
        float px = rangeX;
        float py = 0.0f;
        for (int i = 0; i < corner + 1; ++i) {
            float dr = (float)Math.toRadians(oneDegree * (float)i);
            float rx = (float)((double)rangeX * Math.cos(dr));
            float ry = (float)((double)rangeY * Math.sin(dr));
            DebugSpeakerRangeRenderer.renderLine(poseStack, vertexConsumer, x, y, z, px, py, 0.0f, rx, ry, 0.0f, color);
            px = rx;
            py = ry;
        }
        DebugSpeakerRangeRenderer.renderLine(poseStack, vertexConsumer, x, y, z, px, py, 0.0f, 0.0f, rangeY, 0.0f, color);
    }

    private static void renderLineQuarterSphereY(PoseStack poseStack, VertexConsumer vertexConsumer, float x, float y, float z, float rangeX, float rangeZ, int corner, int color) {
        float oneDegree = 90.0f / (float)(corner + 1);
        float px = rangeX;
        float pz = 0.0f;
        for (int i = 0; i < corner + 1; ++i) {
            float dr = (float)Math.toRadians(oneDegree * (float)i);
            float rx = (float)((double)rangeX * Math.cos(dr));
            float rz = (float)((double)rangeZ * Math.sin(dr));
            DebugSpeakerRangeRenderer.renderLine(poseStack, vertexConsumer, x, y, z, px, 0.0f, pz, rx, 0.0f, rz, color);
            px = rx;
            pz = rz;
        }
        DebugSpeakerRangeRenderer.renderLine(poseStack, vertexConsumer, x, y, z, px, 0.0f, pz, 0.0f, 0.0f, rangeZ, color);
    }

    private static void renderLineQuarterSphereZ(PoseStack poseStack, VertexConsumer vertexConsumer, float x, float y, float z, float rangeZ, float rangeY, int corner, int color) {
        float oneDegree = 90.0f / (float)(corner + 1);
        float pz = rangeZ;
        float py = 0.0f;
        for (int i = 0; i < corner + 1; ++i) {
            float dr = (float)Math.toRadians(oneDegree * (float)i);
            float rz = (float)((double)rangeZ * Math.cos(dr));
            float ry = (float)((double)rangeY * Math.sin(dr));
            DebugSpeakerRangeRenderer.renderLine(poseStack, vertexConsumer, x, y, z, 0.0f, py, pz, 0.0f, ry, rz, color);
            pz = rz;
            py = ry;
        }
        DebugSpeakerRangeRenderer.renderLine(poseStack, vertexConsumer, x, y, z, 0.0f, py, pz, 0.0f, rangeY, 0.0f, color);
    }

    private static void renderLineBox(PoseStack poseStack, VertexConsumer vertexConsumer, float x, float y, float z, float stX, float stY, float stZ, float enX, float enY, float enZ, int color) {
        FNForUtil.forBoxEdge(stX, stY, stZ, enX, enY, enZ, ret -> {
            FNVec3f st = (FNVec3f)ret.getLeft();
            FNVec3f en = (FNVec3f)ret.getRight();
            DebugSpeakerRangeRenderer.renderLine(poseStack, vertexConsumer, x, y, z, st.getX(), st.getY(), st.getZ(), en.getX(), en.getY(), en.getZ(), color);
        });
    }

    private static void renderLine(PoseStack poseStack, VertexConsumer vertexConsumer, float x, float y, float z, float stX, float stY, float stZ, float enX, float enY, float enZ, int color) {
        float nx = enX - stX;
        float ny = enY - stY;
        float nz = enZ - stZ;
        float t = Mth.m_14116_((float)(nx * nx + ny * ny + nz * nz));
        nx /= t;
        ny /= t;
        nz /= t;
        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        float a = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
        PoseStack.Pose pose = poseStack.m_85850_();
        vertexConsumer.m_252986_(pose.m_252922_(), stX + x, stY + y, stZ + z).m_85950_(r, g, b, a).m_252939_(pose.m_252943_(), nx, ny, nz).m_5752_();
        vertexConsumer.m_252986_(pose.m_252922_(), enX + x, enY + y, enZ + z).m_85950_(r, g, b, a).m_252939_(pose.m_252943_(), nx, ny, nz).m_5752_();
    }

    private static Vec3 getListenerPos() {
        float[] x = new float[1];
        float[] y = new float[1];
        float[] z = new float[1];
        AL11.alGetListener3f((int)4100, (float[])x, (float[])y, (float[])z);
        return new Vec3((double)x[0], (double)y[0], (double)z[0]);
    }
}

