/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.player;

import dev.felnull.imp.api.client.MusicPlayerAccess;
import dev.felnull.imp.client.music.AudioInfo;
import dev.felnull.imp.client.music.MusicEngine;
import dev.felnull.imp.client.music.player.MusicLoadChunk;
import dev.felnull.imp.client.music.speaker.MusicSpeaker;
import java.util.List;
import java.util.UUID;

public interface MusicPlayer<T, E>
extends MusicPlayerAccess {
    public void play(long var1);

    public List<MusicSpeaker> getSpeakerList();

    public void destroy() throws Exception;

    default public void destroyNonThrow() {
        try {
            this.destroy();
        }
        catch (Exception ex) {
            MusicEngine.getInstance().getLogger().error("Failed to destroy music player", (Throwable)ex);
        }
    }

    public void pause();

    public void resume();

    public void tick();

    public void addSpeaker(UUID var1, MusicSpeaker var2);

    public MusicSpeaker getSpeaker(UUID var1);

    public void removeSpeaker(UUID var1);

    public boolean existSpeaker(UUID var1);

    public T loadStart(long var1);

    public E loadAsync(T var1) throws Exception;

    public void loadApply(E var1);

    public AudioInfo getAudioInfo();

    public float getCurrentAudioWave(int var1);

    public int getSpeakerCount();

    public boolean waitDestroy();

    public long getMaxWaitTime();

    public List<MusicLoadChunk> getLoadChunks();

    public int getTaskCount();
}

