/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music;

import dev.felnull.imp.client.music.LoadCompleteListener;
import dev.felnull.imp.client.music.MusicEngine;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.music.tracker.MusicTracker;
import dev.felnull.imp.networking.IMPPackets;
import java.util.UUID;

public class MusicRingerEngineConnector {
    public static void load(UUID musicPlayerId, MusicTracker musicTracker, MusicSource source, long position, LoadCompleteListener listener) {
        MusicRingerEngineConnector.getEngine().load(musicPlayerId, source, position, listener);
        MusicRingerEngineConnector.getEngine().addSpeaker(musicPlayerId, musicPlayerId, musicTracker);
    }

    public static void play(UUID musicPlayerId, long delay) {
        MusicRingerEngineConnector.getEngine().play(musicPlayerId, delay);
    }

    public static void stop(UUID musicPlayerId) {
        MusicRingerEngineConnector.getEngine().stop(musicPlayerId);
    }

    public static IMPPackets.MusicRingResponseStateType update(UUID musicPlayerId, MusicTracker musicTracker) {
        if (MusicRingerEngineConnector.getEngine().isPlaying(musicPlayerId)) {
            MusicRingerEngineConnector.getEngine().updateMusicTracker(musicPlayerId, musicPlayerId, musicTracker);
            return IMPPackets.MusicRingResponseStateType.PLAYING;
        }
        if (MusicRingerEngineConnector.getEngine().isLoading(musicPlayerId) || MusicRingerEngineConnector.getEngine().isExist(musicPlayerId)) {
            return IMPPackets.MusicRingResponseStateType.LOADING;
        }
        return IMPPackets.MusicRingResponseStateType.NONE;
    }

    private static MusicEngine getEngine() {
        return MusicEngine.getInstance();
    }
}

