/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.components;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.components.IMPButton;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.music.resource.IIMPComparable;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class SortButton
extends IMPButton
implements IIMPSmartRender {
    protected final boolean longed;

    private SortButton(int x, int y, int w, int tx, Component component, Button.OnPress onPress, boolean longed, Screen screen) {
        super(x, y, w, 9, component, onPress);
        this.longed = longed;
    }

    public void m_5691_() {
        this.cycle();
        this.m_257544_(Tooltip.m_257550_((Component)this.getToolTipComponent()));
        super.m_5691_();
    }

    public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
        this.drawSmartButtonBox(guiGraphics, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, this.m_198029_());
    }

    public abstract void cycle();

    public abstract Component getToolTipComponent();

    public static class OrderTypeButton
    extends SortButton {
        private OrderType type = OrderType.DESCENDING;

        public OrderTypeButton(int x, int y, Button.OnPress onPress, boolean longed, Screen screen) {
            super(x, y, longed ? 88 : 9, longed ? 158 : 52, (Component)Component.m_237115_((String)"imp.button.order"), onPress, longed, screen);
            if (!longed) {
                this.m_257544_(Tooltip.m_257550_((Component)this.getToolTipComponent()));
            }
        }

        @Override
        public void cycle() {
            this.type = OrderType.values()[(this.type.ordinal() + 1) % OrderType.values().length];
        }

        @Override
        public Component getToolTipComponent() {
            return this.type.getComponentName();
        }

        public OrderType getOrderType() {
            return this.type;
        }

        @Override
        public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
            super.m_87963_(guiGraphics, i, j, f);
            OERenderUtils.drawTexture((ResourceLocation)MusicManagerMonitor.WIDGETS_TEXTURE, (PoseStack)guiGraphics.m_280168_(), (float)(this.m_252754_() + 1), (float)(this.m_252907_() + 1), (float)(73 + this.getOrderType().ordinal() * 7), (float)7.0f, (float)7.0f, (float)7.0f);
            if (this.longed) {
                this.drawSmartText(guiGraphics, this.getToolTipComponent(), this.m_252754_() + 9, this.m_252907_() + 1);
            }
        }
    }

    public static class SortTypeButton
    extends SortButton {
        private SortType type = SortType.NAME;

        public SortTypeButton(int x, int y, Button.OnPress onPress, boolean longed, Screen screen) {
            super(x, y, longed ? 97 : 9, longed ? 61 : 52, (Component)Component.m_237115_((String)"imp.button.sort"), onPress, longed, screen);
            if (!longed) {
                this.m_257544_(Tooltip.m_257550_((Component)this.getToolTipComponent()));
            }
        }

        @Override
        public void cycle() {
            this.type = SortType.values()[(this.type.ordinal() + 1) % SortType.values().length];
        }

        @Override
        public Component getToolTipComponent() {
            return this.type.getComponentName();
        }

        public SortType getSortType() {
            return this.type;
        }

        public <T extends IIMPComparable> List<T> sort(List<T> target, OrderTypeButton orderTypeButton) {
            return target.stream().sorted(this.getSortType().getComparator(orderTypeButton.getOrderType())).toList();
        }

        @Override
        public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
            super.m_87963_(guiGraphics, i, j, f);
            OERenderUtils.drawTexture((ResourceLocation)MusicManagerMonitor.WIDGETS_TEXTURE, (PoseStack)guiGraphics.m_280168_(), (float)(this.m_252754_() + 1), (float)(this.m_252907_() + 1), (float)(73 + this.getSortType().ordinal() * 7), (float)0.0f, (float)7.0f, (float)7.0f);
            if (this.longed) {
                this.drawSmartText(guiGraphics, this.getToolTipComponent(), this.m_252754_() + 9, this.m_252907_() + 1);
            }
        }
    }

    public static enum OrderType {
        ASCENDING("ascending", false),
        DESCENDING("descending", true);

        private final String name;
        private final boolean reverse;
        private final Component componentName;

        private OrderType(String name, boolean reverse) {
            this.name = name;
            this.reverse = reverse;
            this.componentName = Component.m_237115_((String)("imp.orderType." + name));
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public String getName() {
            return this.name;
        }

        public Component getComponentName() {
            return this.componentName;
        }
    }

    public static enum SortType {
        NAME("name", (o1, o2) -> o1.getCompareName().compareTo(o2.getCompareName())),
        PLAYER("player", (o1, o2) -> o1.getComparePlayerName().compareTo(o2.getComparePlayerName())),
        CREATE_DATE("create_date", (o1, o2) -> (int)(o1.getCompareDate() - o2.getCompareDate()));

        private final String name;
        private final Comparator<IIMPComparable> comparator;
        private final Comparator<IIMPComparable> rcomparator;
        private final Component componentName;

        private SortType(String name, Comparator<IIMPComparable> comparator) {
            this.name = name;
            this.comparator = comparator;
            this.rcomparator = comparator.reversed();
            this.componentName = Component.m_237115_((String)("imp.sortType." + name));
        }

        public String getName() {
            return this.name;
        }

        public Comparator<IIMPComparable> getComparator(OrderType orderType) {
            return orderType.isReverse() ? this.rcomparator : this.comparator;
        }

        public Component getComponentName() {
            return this.componentName;
        }
    }
}

