/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;

public class ChangeGearGoal
extends Goal {
    public static ResourceLocation ID = new ResourceLocation("brutalbosses:changegear");
    private final Mob mob;
    private ChangeGearParams params;

    public ChangeGearGoal(Mob mob, IAIParams params) {
        this.params = (ChangeGearParams)params;
        this.mob = mob;
    }

    public boolean m_8036_() {
        return this.params.healthPhaseCheck.test(this.mob);
    }

    public void m_8056_() {
        for (Map.Entry<EquipmentSlot, ItemStack> data : this.params.gearSet.entrySet()) {
            this.mob.m_8061_(data.getKey(), data.getValue().m_41777_());
        }
    }

    public void m_8037_() {
    }

    public static class ChangeGearParams
    extends IAIParams.DefaultParams {
        private Map<EquipmentSlot, ItemStack> gearSet;
        public static final String GEAR = "gear";

        public ChangeGearParams(JsonObject jsonData) {
            super(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            this.gearSet = new HashMap<EquipmentSlot, ItemStack>();
            if (jsonElement.has(GEAR)) {
                JsonObject gear = jsonElement.get(GEAR).getAsJsonObject();
                for (Map.Entry data : gear.entrySet()) {
                    EquipmentSlot slot = EquipmentSlot.m_20747_((String)((String)data.getKey()));
                    try {
                        ItemStack stack = ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)((JsonElement)data.getValue()).getAsString()));
                        this.gearSet.put(slot, stack);
                    }
                    catch (CommandSyntaxException e) {
                        BrutalBosses.LOGGER.warn("Could not parse item of: " + ((JsonElement)data.getValue()).getAsString(), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            }
            return this;
        }
    }
}

