/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.compat.Compat;
import com.brutalbosses.config.CommonConfiguration;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.entity.capability.BossCapability;
import com.cupboard.util.BlockSearch;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;

public class BossSpawnHandler {
    private static ConcurrentLinkedQueue<Tuple<BlockPos, BossType>> spawns = new ConcurrentLinkedQueue();

    public static void onChestPlaced(ServerLevelAccessor world, RandomizableContainerBlockEntity chest) {
        List possibleBosses = (List)BossTypeManager.instance.lootTableSpawnEntries.get((Object)chest.f_59605_);
        if (possibleBosses != null && !possibleBosses.isEmpty()) {
            if (BrutalBosses.rand.nextInt(100) > ((CommonConfiguration)BrutalBosses.config.getCommonConfig()).globalBossSpawnChance) {
                return;
            }
            if (BossSpawnHandler.spawnedRecentlyClose(chest.m_58899_())) {
                return;
            }
            BossType bossType = (BossType)possibleBosses.get(BrutalBosses.rand.nextInt(possibleBosses.size()));
            if (bossType == null || bossType.getID().m_135815_().equals("dummyboss")) {
                return;
            }
            BossSpawnHandler.spawnBoss(world, chest.m_58899_(), bossType, chest);
        } else if (((CommonConfiguration)BrutalBosses.config.getCommonConfig()).printChestLoottable) {
            BrutalBosses.LOGGER.info("Chest with Loottable: " + chest.f_59605_ + " not associated with any boss spawn");
        }
    }

    private static boolean spawnedRecentlyClose(BlockPos pos) {
        for (Tuple<BlockPos, BossType> data : spawns) {
            if (!(Math.sqrt(((BlockPos)data.m_14418_()).m_123331_((Vec3i)pos)) < (double)((CommonConfiguration)BrutalBosses.config.getCommonConfig()).minDistance)) continue;
            return true;
        }
        return false;
    }

    public static void spawnBoss(ServerLevelAccessor world, BlockPos pos, BossType bossType, @Nullable RandomizableContainerBlockEntity chest) {
        try {
            BlockPos spawnPos;
            Mob boss;
            spawns.add((Tuple<BlockPos, BossType>)new Tuple((Object)pos, (Object)bossType));
            if (spawns.size() > 20) {
                spawns.poll();
            }
            if ((boss = bossType.createBossEntity((Level)world.m_6018_())) == null) {
                return;
            }
            if (chest != null) {
                ResourceLocation lootTable = chest.f_59605_;
                BrutalBosses.LOGGER.debug("Spawning " + bossType.getID() + " at " + pos + " at " + chest.m_5446_().getString() + " with:" + lootTable);
            }
            if ((spawnPos = BossSpawnHandler.findSpawnPosForBoss(world, (Entity)boss, pos)) == null) {
                boss.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            boss.m_6034_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
            if (chest != null) {
                ((BossCapability)boss.getCapability(BossCapability.BOSS_CAP).orElse(null)).setLootTable(chest.f_59605_);
            }
            ((BossCapability)boss.getCapability(BossCapability.BOSS_CAP).orElse(null)).setSpawnPos(pos);
            Compat.applyAllCompats(world, bossType, pos, (Entity)boss);
            if (!boss.m_213877_()) {
                world.m_7967_((Entity)boss);
            }
        }
        catch (Exception spawnException) {
            BrutalBosses.LOGGER.error("Boss: " + bossType.getID() + " failed to spawn! Error:", (Throwable)spawnException);
        }
    }

    public static BlockPos findSpawnPosForBoss(ServerLevelAccessor world, Entity boss, BlockPos pos) {
        BlockPos spawnPos = BlockSearch.findAround((BlockGetter)world, (BlockPos)pos, (int)15, (int)10, (int)1, (w, p) -> {
            if (w.m_8055_(p.m_7495_()).m_60795_()) {
                return false;
            }
            for (int x = Mth.m_14143_((float)((-boss.m_20205_() + 1.0f) / 2.0f)); x <= Mth.m_14167_((float)((boss.m_20205_() - 1.0f) / 2.0f)); ++x) {
                for (int z = Mth.m_14143_((float)((-boss.m_20205_() + 1.0f) / 2.0f)); z <= Mth.m_14167_((float)((boss.m_20205_() - 1.0f) / 2.0f)); ++z) {
                    for (int y = 0; y <= Mth.m_14167_((float)boss.m_20206_()); ++y) {
                        if (w.m_8055_(p.m_7918_(x, y, z)).m_60795_()) continue;
                        return false;
                    }
                }
            }
            return true;
        });
        return spawnPos;
    }

    public static void spawnRandomBoss(ServerLevel world, BlockPos pos) {
        ArrayList<BossType> list = new ArrayList<BossType>(BossTypeManager.instance.bosses.values());
        BossType bossType = (BossType)list.get(BrutalBosses.rand.nextInt(list.size()));
        BossSpawnHandler.spawnBoss((ServerLevelAccessor)world, pos, bossType, null);
    }
}

