/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.client.pickup;

import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.client.pickup.IPickupEntry;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;

public final class ItemPickup
implements IPickupEntry {
    public static final CompoundTag EMPTY_TAG = new CompoundTag();
    private final ItemStack stack;
    private int count;
    private int total;

    public ItemPickup(ItemStack stack) {
        this.stack = stack;
        this.count = stack.m_41613_();
        this.countTotal(this.count);
    }

    @Override
    public MutableComponent getDisplayName() {
        Style style = LootJournal.CONFIG.itemEntryUseItemFormatting ? this.stack.m_41611_().m_7383_().m_131155_(Boolean.valueOf(this.stack.m_41788_())) : LootJournal.CONFIG.itemEntryStyle;
        MutableComponent name = this.stack.m_41786_().m_6881_().m_130948_(style);
        MutableComponent result = this.count <= 1 ? Component.m_237110_((String)"pickup.loot_journal.item_single", (Object[])new Object[]{name}) : Component.m_237110_((String)"pickup.loot_journal.item_multiple", (Object[])new Object[]{name, this.count});
        return result.m_130948_(style);
    }

    @Override
    public int getTotalAmount() {
        return this.total;
    }

    @Override
    public void renderIcon(GuiGraphics graphics, long time) {
        graphics.m_280203_(this.stack, -8, -8);
    }

    @Override
    public boolean maybeMerge(IPickupEntry pickup) {
        if (!(pickup instanceof ItemPickup)) {
            return false;
        }
        ItemPickup other = (ItemPickup)pickup;
        if (!ItemStack.m_150942_((ItemStack)this.stack, (ItemStack)other.stack)) {
            return false;
        }
        this.count += other.count;
        this.countTotal(other.count);
        return true;
    }

    @Override
    public boolean shouldDisplayTotalAmount() {
        return LootJournal.CONFIG.itemEntryDisplayTotalAmount && this.total > 1;
    }

    private void countTotal(int origin) {
        this.total = origin;
        if (!LootJournal.CONFIG.itemEntryDisplayTotalAmount) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            this.total += this.countSameItems(stack);
        }
    }

    private int countSameItems(ItemStack stack) {
        CompoundTag compoundTag;
        ListTag listTag;
        Object object;
        int searched = 0;
        if (ItemStack.m_150942_((ItemStack)this.stack, (ItemStack)stack)) {
            searched += stack.m_41613_();
        }
        if ((object = Optional.ofNullable(stack.m_41783_()).orElse(EMPTY_TAG).m_128469_("BlockEntityTag").m_128423_("Items")) instanceof ListTag) {
            listTag = (ListTag)object;
            object = listTag.stream().toList().iterator();
            while (object.hasNext()) {
                Tag tagIn = (Tag)object.next();
                if (!(tagIn instanceof CompoundTag)) continue;
                compoundTag = (CompoundTag)tagIn;
                searched += this.countSameItems(ItemStack.m_41712_((CompoundTag)compoundTag));
            }
        }
        if ((object = Optional.ofNullable(stack.m_41783_()).orElse(EMPTY_TAG).m_128423_("Items")) instanceof ListTag) {
            listTag = (ListTag)object;
            for (Tag tagIn : listTag.stream().toList()) {
                if (!(tagIn instanceof CompoundTag)) continue;
                compoundTag = (CompoundTag)tagIn;
                searched += this.countSameItems(ItemStack.m_41712_((CompoundTag)compoundTag));
            }
        }
        return searched;
    }
}

