/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal;

import dev.obscuria.lootjournal.ModConfigDefaults;
import dev.obscuria.lootjournal.client.ItemPolicy;
import dev.obscuria.lootjournal.client.render.Anchor;
import dev.obscuria.lootjournal.client.render.PickupDrawStyle;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.apache.commons.compress.utils.Lists;

public final class ModConfig {
    public PickupDrawStyle style = ModConfigDefaults.STYLE;
    public boolean itemEntryDisplay = true;
    public boolean itemEntryDisplayTotalAmount = true;
    public boolean itemEntryUseItemFormatting = true;
    public Style itemEntryStyle = ModConfig.createStyle(0xFFFFFF, false);
    public boolean aggregatedEntryDisplay = true;
    public Style aggregatedEntryStyle = ModConfig.createStyle(0xFFFFFF, true);
    public boolean experienceEntryDisplay = true;
    public Style experienceEntryStyle = ModConfig.createStyle(0x55FF55, false);
    public Anchor anchor = ModConfigDefaults.ANCHOR;
    public int anchorPixelOffset = 3;
    public int anchorPercentOffset = 10;
    public int scale = 100;
    public int separation = 3;
    public int lifetime = 6;
    public int displayCapacity = 9;
    public int queueCapacity = 9;
    public ItemPolicy defaultItemPolicy = ModConfigDefaults.DEFAULT_ITEM_POLICY;
    public List<Item> itemIdBlacklist = Lists.newArrayList();
    public List<Item> itemIdWhitelist = Lists.newArrayList();
    public List<String> modIdBlacklist = Lists.newArrayList();
    public List<String> modIdWhitelist = Lists.newArrayList();

    public static String intToHex(int color) {
        return String.format("%06X", 0xFFFFFF & color);
    }

    public static int hexToInt(String color) {
        try {
            return Integer.parseInt(color, 16);
        }
        catch (Exception ignored) {
            return 0xFFFFFF;
        }
    }

    public static Style createStyle(String color, boolean italic) {
        return ModConfig.createStyle(ModConfig.hexToInt(color), italic);
    }

    public static Style createStyle(int color, boolean italic) {
        return Style.f_131099_.m_178520_(color).m_131155_(Boolean.valueOf(italic));
    }

    public static List<Item> mapItems(List<? extends String> ids) {
        return ids.stream().map(it -> Optional.ofNullable(ResourceLocation.m_135820_((String)it))).map(it -> it.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_7745_(arg_0))).filter(Optional::isPresent).map(Optional::get).toList();
    }
}

