/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.model;

import com.pepper.faunify.FaunifyConfig;
import com.pepper.faunify.entity.OpossumEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class OpossumModel
extends DefaultedEntityGeoModel<OpossumEntity> {
    public OpossumModel() {
        super(new ResourceLocation("faunify", "opossum"), true);
    }

    public ResourceLocation getAnimationResource(OpossumEntity object) {
        if (((Boolean)FaunifyConfig.OLD_ANIMATION.get()).booleanValue()) {
            return new ResourceLocation("faunify", "animations/opossum.animation.json");
        }
        return new ResourceLocation("faunify", "animations/ratopossum.animation.json");
    }

    public void setCustomAnimations(OpossumEntity entity, long uniqueID, AnimationState<OpossumEntity> animationState) {
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        CoreGeoBone neck = this.getAnimationProcessor().getBone("head_rotation");
        if (head != null) {
            if (entity.m_6162_()) {
                float headScale = 1.6f;
                head.setScaleX(headScale);
                head.setScaleY(headScale);
                head.setScaleZ(headScale);
            } else {
                head.setScaleX(1.0f);
                head.setScaleY(1.0f);
                head.setScaleZ(1.0f);
            }
        }
        if (entity.m_5803_()) {
            return;
        }
        if (neck != null && head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            boolean moving = animationState.isMoving();
            float pitch = entityData.headPitch();
            neck.setRotX(Math.min(20.0f, pitch) * 0.3f * ((float)Math.PI / 180));
            if (pitch > 20.0f && !moving) {
                head.setRotX((pitch - 30.0f) * 0.3f * ((float)Math.PI / 180));
            }
            neck.setRotZ(entityData.netHeadYaw() * 0.3f * ((float)Math.PI / 180) * -0.5f);
        }
    }
}

