/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.plateau;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructureTypes;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.plateau.GourPlateauPiece;
import org.jetbrains.annotations.NotNull;

public class GourPlateauStructure
extends Structure {
    public static final Codec<GourPlateauStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)GourPlateauStructure.m_226567_((RecordCodecBuilder.Instance)builder)).apply((Applicative)builder, GourPlateauStructure::new)).codec();

    public GourPlateauStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    @NotNull
    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        WorldgenRandom random = context.f_226626_();
        int blockX = chunkPos.m_151382_(random.m_188503_(16));
        int blockZ = chunkPos.m_151391_(random.m_188503_(16));
        float twoPi = (float)Math.PI * 2;
        int slices = 20;
        double sliceSize = twoPi / (float)slices;
        int plateauRadius = random.m_216332_(48, 96);
        int sampleY = QuartPos.m_175400_((int)context.f_226622_().m_6337_());
        int minPlateauRadius = 16;
        boolean shouldCancel = true;
        for (int modifiedPlateauRadius = plateauRadius; modifiedPlateauRadius >= minPlateauRadius; modifiedPlateauRadius -= 4) {
            boolean success = true;
            for (int i = 0; i <= slices; ++i) {
                double angle = (double)i * sliceSize;
                int offsetX = (int)Math.round(Math.sin(angle) * (double)modifiedPlateauRadius);
                int offsetZ = (int)Math.round(Math.cos(angle) * (double)modifiedPlateauRadius);
                if (context.f_226630_().test(context.f_226623_().m_203407_(QuartPos.m_175400_((int)(blockX + offsetX)), sampleY, QuartPos.m_175400_((int)(blockZ + offsetZ)), context.f_226624_().m_224579_()))) continue;
                success = false;
                break;
            }
            if (!success) continue;
            plateauRadius = modifiedPlateauRadius - 4;
            shouldCancel = false;
            break;
        }
        if (shouldCancel) {
            return Optional.empty();
        }
        int finalPlateauRadius = plateauRadius;
        return GourPlateauStructure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, piecesBuilder -> {
            RandomState randomState = context.f_226624_();
            ChunkGenerator chunkGenerator = context.f_226622_();
            WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(context.f_226627_()));
            ImprovedNoise noiseSampler = new ImprovedNoise((RandomSource)worldgenRandom);
            LevelHeightAccessor levelHeightAccessor = context.f_226629_();
            BlockPos plateauOrigin = new BlockPos(blockX, chunkGenerator.m_214096_(blockX, blockZ, Heightmap.Types.OCEAN_FLOOR_WG, levelHeightAccessor, randomState) - 10, blockZ);
            double noise = noiseSampler.m_164308_((double)plateauOrigin.m_123341_() * 5.0E-4, 0.0, (double)plateauOrigin.m_123343_() * 5.0E-4) + 1.0;
            double height = (int)((noise *= 0.5) * 100.0);
            GourPlateauStructure.createArenaFloor(context, piecesBuilder, finalPlateauRadius, plateauOrigin, (int)height + chunkGenerator.m_6337_(), levelHeightAccessor);
        });
    }

    private static void createArenaFloor(Structure.GenerationContext context, StructurePiecesBuilder piecesBuilder, int arenaFloorRadius, BlockPos arenaOrigin, int topY, LevelHeightAccessor levelHeightAccessor) {
        for (int chunkX = -(SectionPos.m_123171_((int)arenaFloorRadius) + 1); chunkX <= SectionPos.m_123171_((int)arenaFloorRadius) + 1; ++chunkX) {
            for (int chunkZ = -(SectionPos.m_123171_((int)arenaFloorRadius) + 1); chunkZ <= SectionPos.m_123171_((int)arenaFloorRadius) + 1; ++chunkZ) {
                BlockPos chunkWorldPos = new BlockPos(SectionPos.m_123223_((int)(context.f_226628_().f_45578_ + chunkX)), arenaOrigin.m_123342_(), SectionPos.m_123223_((int)(context.f_226628_().f_45579_ + chunkZ)));
                BoundingBox boundingBox = new BoundingBox(chunkWorldPos.m_123341_(), levelHeightAccessor.m_141937_(), chunkWorldPos.m_123343_(), chunkWorldPos.m_123341_() + 15, levelHeightAccessor.m_151558_(), chunkWorldPos.m_123343_() + 15);
                piecesBuilder.m_142679_((StructurePiece)new GourPlateauPiece(arenaOrigin, arenaFloorRadius, topY, boundingBox));
            }
        }
    }

    @NotNull
    public StructureType<?> m_213658_() {
        return BWGStructureTypes.OVERHANG_PLATEAU.get();
    }
}

