/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.npc;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.biome.Biome;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGBiomes;

public class BWGVillagerTypes {
    public static final Supplier<VillagerType> RED_ROCK = BWGVillagerTypes.register("red_rock");
    public static final Supplier<VillagerType> SALEM = BWGVillagerTypes.register("salem");
    public static final Supplier<VillagerType> SKYRIS = BWGVillagerTypes.register("skyris");

    public static void setVillagerBiomes(BiConsumer<ResourceKey<Biome>, VillagerType> consumer) {
        consumer.accept(BWGBiomes.MOJAVE_DESERT, VillagerType.f_35819_);
        consumer.accept(BWGBiomes.WINDSWEPT_DESERT, VillagerType.f_35819_);
        consumer.accept(BWGBiomes.TROPICAL_RAINFOREST, VillagerType.f_35820_);
        consumer.accept(BWGBiomes.WHITE_MANGROVE_MARSHES, VillagerType.f_35824_);
        consumer.accept(BWGBiomes.BAYOU, VillagerType.f_35824_);
        consumer.accept(BWGBiomes.CYPRESS_SWAMPLANDS, VillagerType.f_35824_);
        consumer.accept(BWGBiomes.BAYOU, VillagerType.f_35824_);
        consumer.accept(BWGBiomes.RED_ROCK_VALLEY, RED_ROCK.get());
        consumer.accept(BWGBiomes.RED_ROCK_PEAKS, RED_ROCK.get());
        consumer.accept(BWGBiomes.SKYRIS_VALE, SKYRIS.get());
        consumer.accept(BWGBiomes.WEEPING_WITCH_FOREST, SALEM.get());
    }

    private static Supplier<VillagerType> register(String key) {
        return PlatformHandler.PLATFORM_HANDLER.register(BuiltInRegistries.f_256934_, key, () -> new VillagerType(key));
    }

    public static void villagerTypes() {
        BiomesWeveGone.LOGGER.info("Registering Oh The Biomes We've Gone villager types");
    }
}

