/*
 * Decompiled with CFR 0.152.
 */
package net.clearlagplus;

import net.clearlagplus.ClearHandler;
import net.clearlagplus.ClearLagConfig;
import net.clearlagplus.ClearLagMessages;
import net.clearlagplus.ClearLagPlus;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ClearLagScheduler {
    private static int ticks = 0;
    public static int clearIntervalTicks = 0;
    private static final int WARNING_ONE_MINUTE = 1200;
    private static final int COUNTDOWN_START = 300;
    private static boolean clearLagCancelled = false;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        int remainingTicks;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ClearLagPlus.server;
        if (server == null) {
            return;
        }
        if (clearIntervalTicks <= 0) {
            return;
        }
        if ((remainingTicks = clearIntervalTicks - ++ticks) == 1200) {
            for (Object player : server.m_6846_().m_11314_()) {
                player.m_213846_(ClearLagMessages.colored((Component)Component.m_237115_((String)"clearlagplus.warning_one_minute"), 0xFFFF55));
            }
        }
        if (remainingTicks <= 300 && remainingTicks > 0 && remainingTicks % 20 == 0) {
            int secondsLeft = remainingTicks / 20;
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                player.m_213846_(ClearLagMessages.countdownMessage(secondsLeft));
            }
        }
        if (ticks >= clearIntervalTicks) {
            if (!clearLagCancelled) {
                for (ServerLevel level : server.m_129785_()) {
                    ClearHandler.clearEntities(level);
                }
            } else {
                for (Object player : server.m_6846_().m_11314_()) {
                    player.m_213846_(ClearLagMessages.colored((Component)Component.m_237115_((String)"clearlagplus.clear_lag_cancelled"), 0xFF5555));
                }
            }
            ticks = 0;
            clearLagCancelled = false;
        }
    }

    public static void setClearIntervalMinutes(int minutes) {
        clearIntervalTicks = minutes * 60 * 20;
        ticks = 0;
    }

    public static String getRemainingTimeFormatted() {
        int totalSeconds = (clearIntervalTicks - ticks) / 20;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return minutes + " minutes " + seconds + " secondes";
    }

    public static void reloadConfig() {
        ClearLagScheduler.setClearIntervalMinutes((Integer)ClearLagConfig.CLEARLAG_INTERVAL_MINUTES.get());
    }

    public static void cancelClearLag() {
        clearLagCancelled = true;
        ticks = 0;
    }

    public static void resetClearLagTimer() {
        ticks = 0;
    }

    public static void initSchedulerFromConfig() {
        ClearLagScheduler.setClearIntervalMinutes(ClearLagConfig.getClearLagIntervalMinutes());
    }
}

