/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butcher;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.butcher.init.ButcherModBlockEntities;
import net.mcreator.butcher.init.ButcherModBlocks;
import net.mcreator.butcher.init.ButcherModEnchantments;
import net.mcreator.butcher.init.ButcherModEntities;
import net.mcreator.butcher.init.ButcherModFeatures;
import net.mcreator.butcher.init.ButcherModFluidTypes;
import net.mcreator.butcher.init.ButcherModFluids;
import net.mcreator.butcher.init.ButcherModItems;
import net.mcreator.butcher.init.ButcherModMenus;
import net.mcreator.butcher.init.ButcherModMobEffects;
import net.mcreator.butcher.init.ButcherModPaintings;
import net.mcreator.butcher.init.ButcherModParticleTypes;
import net.mcreator.butcher.init.ButcherModPotions;
import net.mcreator.butcher.init.ButcherModSounds;
import net.mcreator.butcher.init.ButcherModTabs;
import net.mcreator.butcher.world.features.StructureFeature;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="butcher")
public class ButcherMod {
    public static final Logger LOGGER = LogManager.getLogger(ButcherMod.class);
    public static final String MODID = "butcher";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("butcher", "butcher"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public ButcherMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ButcherModSounds.REGISTRY.register(bus);
        ButcherModBlocks.REGISTRY.register(bus);
        ButcherModBlockEntities.REGISTRY.register(bus);
        ButcherModItems.REGISTRY.register(bus);
        ButcherModEntities.REGISTRY.register(bus);
        ButcherModEnchantments.REGISTRY.register(bus);
        ButcherModTabs.REGISTRY.register(bus);
        ButcherModFeatures.REGISTRY.register(bus);
        StructureFeature.REGISTRY.register(bus);
        ButcherModMobEffects.REGISTRY.register(bus);
        ButcherModPotions.REGISTRY.register(bus);
        ButcherModPaintings.REGISTRY.register(bus);
        ButcherModParticleTypes.REGISTRY.register(bus);
        ButcherModMenus.REGISTRY.register(bus);
        ButcherModFluids.REGISTRY.register(bus);
        ButcherModFluidTypes.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

