/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.advancement.modification.modifiers;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.util.GsonHelper;

public interface AdvancementModifier<M extends AdvancementModifier<M>>
extends ObjectModifier<Advancement.Builder, Void, DeserializationContext, M> {

    public static interface Serializer<M extends AdvancementModifier<M>>
    extends ObjectModifier.Serializer<M, Void, DeserializationContext> {
    }

    public static enum Mode {
        MODIFY("modify"),
        REPLACE("replace");

        private static final Map<String, Mode> VALUES_MAP;
        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        public static Mode deserialize(JsonObject object) throws JsonParseException {
            String string = GsonHelper.m_13906_((JsonObject)object, (String)"mode");
            Mode mode = VALUES_MAP.get(string);
            if (mode == null) {
                throw new JsonParseException("Unknown mode type: " + string);
            }
            return mode;
        }

        public void serialize(JsonObject object) {
            object.addProperty("mode", this.name);
        }

        public String getName() {
            return this.name;
        }

        static {
            VALUES_MAP = Arrays.stream(Mode.values()).collect(Collectors.toMap(Mode::getName, mode -> mode));
        }
    }
}

