/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class WeightedRandomBag<T> {
    private List<Entry> entries = new ArrayList<Entry>();
    private double accumulatedWeight;
    private Random rand = new Random();

    public void addEntry(T object, double weight) {
        this.accumulatedWeight += weight;
        Entry e = new Entry();
        e.object = object;
        e.accumulatedWeight = this.accumulatedWeight;
        this.entries.add(e);
    }

    public void removeEntry(T object) {
        this.entries.remove(object);
    }

    public T getRandom() {
        double r = this.rand.nextDouble() * this.accumulatedWeight;
        for (Entry entry : this.entries) {
            if (!(entry.accumulatedWeight >= r)) continue;
            return entry.object;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    private class Entry {
        double accumulatedWeight;
        T object;

        private Entry() {
        }
    }
}

