/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.server;

import dev.hexnowloading.dungeonnowloading.capability.forge.DNLArmPoseCapability;
import dev.hexnowloading.dungeonnowloading.capability.forge.DNLArmPoseCapabilityProvider;
import dev.hexnowloading.dungeonnowloading.capability.forge.FairkeeperChestPositionsCapability;
import dev.hexnowloading.dungeonnowloading.capability.forge.FairkeeperChestPositionsCapabilityProvider;
import dev.hexnowloading.dungeonnowloading.entity.DNLEntityEvents;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeonnowloading", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DNLForgeEntityEvents {
    public static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        for (EntityType<? extends LivingEntity> type : DNLEntityTypes.getAllAttributes().keySet()) {
            event.put(type, DNLEntityTypes.getAllAttributes().get(type));
        }
    }

    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register(DNLEntityTypes.HOLLOW.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register(DNLEntityTypes.SPAWNER_CARRIER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register(DNLEntityTypes.SCUTTLE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.AND);
    }

    public static void onLivingDamageEvent(LivingDamageEvent event) {
        Entity attackingEntity = event.getSource().m_7639_();
        LivingEntity hurtedEntity = event.getEntity();
        float damage = event.getAmount();
        if (attackingEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attackingEntity;
            event.setAmount(DNLEntityEvents.onLivingDamageEvent(livingEntity, hurtedEntity, damage));
        }
    }

    public static void onLivingHurtEvent(LivingHurtEvent event) {
        Entity attacker = event.getSource().m_7639_();
        LivingEntity target = event.getEntity();
        float damage = event.getAmount();
        if (attacker instanceof LivingEntity) {
            LivingEntity attackerEntity = (LivingEntity)attacker;
            event.setAmount(DNLEntityEvents.onLivingHurtEvent(attackerEntity, target, damage));
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            if (!((Entity)event.getObject()).getCapability(FairkeeperChestPositionsCapabilityProvider.FAIRKEEPER_CHEST_POSITIONS).isPresent()) {
                event.addCapability(new ResourceLocation("dungeonnowloading", "fairkeeper_chest_positions"), (ICapabilityProvider)new FairkeeperChestPositionsCapabilityProvider());
            }
            if (!((Entity)event.getObject()).getCapability(DNLArmPoseCapabilityProvider.DNL_ARM_POSE).isPresent()) {
                event.addCapability(new ResourceLocation("dungeonnowloading", "dnl_arm_pose"), (ICapabilityProvider)new DNLArmPoseCapabilityProvider());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(FairkeeperChestPositionsCapabilityProvider.FAIRKEEPER_CHEST_POSITIONS).ifPresent(oldStore -> event.getOriginal().getCapability(FairkeeperChestPositionsCapabilityProvider.FAIRKEEPER_CHEST_POSITIONS).ifPresent(newStore -> newStore.copyFrom((FairkeeperChestPositionsCapability)oldStore)));
            event.getOriginal().getCapability(DNLArmPoseCapabilityProvider.DNL_ARM_POSE).ifPresent(oldStore -> event.getOriginal().getCapability(DNLArmPoseCapabilityProvider.DNL_ARM_POSE).ifPresent(newStore -> newStore.copyFrom((DNLArmPoseCapability)oldStore)));
        }
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(FairkeeperChestPositionsCapability.class);
        event.register(DNLArmPoseCapability.class);
    }
}

