/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.particle.type;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class AxisParticleType
extends ParticleType<AxisParticleData> {
    public static final Codec<AxisParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("particle_type").forGetter(data -> BuiltInRegistries.f_257034_.m_7981_(data.particleType).toString()), (App)Codec.INT.fieldOf("axis").forGetter(data -> data.axis), (App)Codec.FLOAT.fieldOf("degree").forGetter(data -> Float.valueOf(data.degree))).apply((Applicative)instance, (type, axis, degree) -> new AxisParticleData((ParticleType<AxisParticleData>)((ParticleType)BuiltInRegistries.f_257034_.m_7745_(new ResourceLocation(type))), (int)axis, degree.floatValue())));

    public AxisParticleType(boolean alwaysShow) {
        super(alwaysShow, AxisParticleData.DESERIALIZER);
    }

    public Codec<AxisParticleData> m_7652_() {
        return CODEC;
    }

    public static class AxisParticleData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<AxisParticleData> DESERIALIZER = new ParticleOptions.Deserializer<AxisParticleData>(){

            public AxisParticleData fromCommand(ParticleType<AxisParticleData> particleType, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int axis = reader.readInt();
                reader.expect(' ');
                float degree = reader.readFloat();
                return new AxisParticleData(particleType, axis, degree);
            }

            public AxisParticleData fromNetwork(ParticleType<AxisParticleData> particleType, FriendlyByteBuf buffer) {
                return new AxisParticleData(particleType, buffer.readInt(), buffer.readFloat());
            }
        };
        private final ParticleType<AxisParticleData> particleType;
        private final int axis;
        private final float degree;

        public AxisParticleData(ParticleType<AxisParticleData> particleType, int axis, float degree) {
            this.particleType = particleType;
            this.axis = axis;
            this.degree = degree;
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()));
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeInt(this.axis);
            buffer.writeFloat(this.degree);
        }

        public ParticleType<?> m_6012_() {
            return this.particleType;
        }

        public int getAxis() {
            return this.axis;
        }

        public float getDegree() {
            return this.degree;
        }
    }
}

