/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.item;

import dev.hexnowloading.dungeonnowloading.config.GeneralConfig;
import dev.hexnowloading.dungeonnowloading.config.PvpConfig;
import dev.hexnowloading.dungeonnowloading.entity.passive.WhimperEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SpawnerArmorItem
extends ArmorItem {
    private int summonTick = 200;
    private final int spawnRange = 4;

    public SpawnerArmorItem(ArmorMaterial armorMaterial, ArmorItem.Type slot) {
        super(armorMaterial, slot, new Item.Properties());
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int slot, boolean selected) {
        boolean opposingPlayerNearby;
        super.m_6883_(itemStack, level, entity, slot, selected);
        if (level.f_46443_) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!itemStack.m_150930_(DNLItems.SPAWNER_HELMET.get())) {
            return;
        }
        if (!this.hasFullSuitOfArmorOn(player)) {
            return;
        }
        if (this.summonTick > 0) {
            --this.summonTick;
            return;
        }
        BlockPos pos = player.m_20097_();
        double r = 5.0;
        boolean hostileMobNearby = !level.m_6443_(Monster.class, player.m_20191_().m_82400_(r), mob -> mob.m_6084_()).isEmpty();
        boolean bl = opposingPlayerNearby = (Boolean)PvpConfig.TOGGLE_PVP_MODE.get() != false && !level.m_6443_(Player.class, player.m_20191_().m_82400_(r), other -> other != player && !player.m_7307_((Entity)other) && !other.m_5833_() && !other.m_7500_() && other.m_6084_()).isEmpty();
        if (hostileMobNearby || opposingPlayerNearby) {
            if (this.hasCorrectArmorOn(player)) {
                this.summonMob(level, pos, player);
            }
            this.summonTick = 200;
        } else {
            this.summonTick = 40;
        }
    }

    private void summonMob(Level level, BlockPos entityPos, Player owner) {
        double z;
        double y;
        RandomSource randomSource = level.m_213780_();
        EntityType spawningEntity = EntityType.f_20501_;
        double x = (double)entityPos.m_123341_() + (randomSource.m_188500_() - randomSource.m_188500_()) * (double)this.spawnRange + 0.5;
        if (level.m_45772_(spawningEntity.m_20585_(x, y = (double)(entityPos.m_123342_() + randomSource.m_188503_(3) - 1), z = (double)entityPos.m_123343_() + (randomSource.m_188500_() - randomSource.m_188500_()) * (double)this.spawnRange + 0.5))) {
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123759_, x + 0.5, y + 0.5, z + 0.5, 20, 0.3, 0.3, 0.3, 0.0);
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123744_, x + 0.5, y + 0.5, z + 0.5, 10, 0.3, 0.3, 0.3, 0.0);
            WhimperEntity whimper = (WhimperEntity)DNLEntityTypes.WHIMPER.get().m_20615_(level);
            if (whimper != null) {
                whimper.m_7678_(x, y, z, 0.0f, 0.0f);
                whimper.setOwnerUUID(owner.m_20148_());
                level.m_7967_((Entity)whimper);
            }
        }
    }

    private boolean hasFullSuitOfArmorOn(Player player) {
        ItemStack boots = player.m_150109_().m_36052_(0);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack chestplate = player.m_150109_().m_36052_(2);
        ItemStack helmet = player.m_150109_().m_36052_(3);
        return !helmet.m_41619_() && !chestplate.m_41619_() && !leggings.m_41619_() && !boots.m_41619_();
    }

    private boolean hasCorrectArmorOn(Player player) {
        for (ItemStack armorStack : player.m_150109_().f_35975_) {
            if (armorStack.m_41720_() instanceof ArmorItem) continue;
            return false;
        }
        ArmorItem boots = (ArmorItem)player.m_150109_().m_36052_(0).m_41720_();
        ArmorItem leggings = (ArmorItem)player.m_150109_().m_36052_(1).m_41720_();
        ArmorItem chestplate = (ArmorItem)player.m_150109_().m_36052_(2).m_41720_();
        ArmorItem helmet = (ArmorItem)player.m_150109_().m_36052_(3).m_41720_();
        return helmet.m_40401_() == this.f_40379_ && chestplate.m_40401_() == this.f_40379_ && leggings.m_40401_() == this.f_40379_ && boots.m_40401_() == this.f_40379_;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, components, tooltipFlag);
        if (((Boolean)GeneralConfig.TOGGLE_HELPFUL_ITEM_TOOLTIP.get()).booleanValue()) {
            components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.spawner_armor.tooltip.ability_name").m_130940_(ChatFormatting.GRAY));
            components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.spawner_armor.tooltip.ability_description").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }
}

