/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.projectile;

import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.entity.util.ModelledProjectileEntity;
import dev.hexnowloading.dungeonnowloading.particle.type.AxisParticleType;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.registry.DNLTags;
import dev.hexnowloading.dungeonnowloading.util.DNLLevelUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class VertexDomainProjectileEntity
extends ModelledProjectileEntity {
    private static final EntityDataAccessor<Integer> HURT_TIME = SynchedEntityData.m_135353_(VertexDomainProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HURT_TIME_DIRECT = SynchedEntityData.m_135353_(VertexDomainProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(VertexDomainProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Vector3f> VELOCITY = SynchedEntityData.m_135353_(VertexDomainProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<VertexDomainAnimationState> ANIMATION_STATE = SynchedEntityData.m_135353_(VertexDomainProjectileEntity.class, EntityStates.VERTEX_DOMAIN_ANIMATION_STATE);
    private static final EntityDataAccessor<Integer> DYING_TICK = SynchedEntityData.m_135353_(VertexDomainProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> GROUND_COLLISION = SynchedEntityData.m_135353_(VertexDomainProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> RADIUS = SynchedEntityData.m_135353_(VertexDomainProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState spinAnimationState = new AnimationState();
    public final AnimationState impactAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    private static final int BASE_DAMAGE = 20;
    private static final int SLOWNESS_AMPLIFIER = 4;
    private static final int SLOWNESS_DURATION = 100;
    public static final int DURATION_ON_GROUND = 1200;
    private static final float BASE_HEALTH = 100.0f;
    private static final int RANGE = 7;
    private static final double BEAM_INITIAL_PARTICLE_SPACING = 0.5;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MIN = 0.2f;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MAX = 0.4f;
    private double xPower;
    private double yPower;
    private double zPower;
    private int life;
    private float health = 100.0f;
    private boolean hasAppliedMovement;
    private boolean delayTick;
    private boolean explosionImmune;
    private int impactAnimationTimeOut;
    private int expansionTick;
    public static final int IMPACT_ANIMATION_DURATION = 5;
    public static final int EXPANSION_DURATION = 20;

    public VertexDomainProjectileEntity(EntityType<? extends VertexDomainProjectileEntity> entityType, Level level) {
        super(entityType, level);
    }

    public VertexDomainProjectileEntity(Level level, LivingEntity owner, float health) {
        this((EntityType<? extends VertexDomainProjectileEntity>)DNLEntityTypes.VERTEX_DOMAIN_PROJECTILE.get(), level);
        this.setOwner((Entity)owner);
        this.health = health;
        this.setRadius(7);
        this.setDyingTick(0);
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        ListTag listTag;
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_("power", 9) && (listTag = compoundTag.m_128437_("power", 6)).size() == 3) {
            this.xPower = listTag.m_128772_(0);
            this.yPower = listTag.m_128772_(1);
            this.zPower = listTag.m_128772_(2);
        }
        if (compoundTag.m_128425_("life", 3)) {
            this.life = compoundTag.m_128451_("life");
        }
        if (compoundTag.m_128425_("health", 5)) {
            this.health = compoundTag.m_128457_("health");
        }
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128365_("power", (Tag)this.m_20063_(new double[]{this.xPower, this.yPower, this.zPower}));
        compoundTag.m_128405_("life", this.life);
        compoundTag.m_128350_("health", this.health);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(HURT_TIME, (Object)0);
        this.f_19804_.m_135372_(HURT_TIME_DIRECT, (Object)1);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(VELOCITY, (Object)Vec3.f_82478_.m_252839_());
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)VertexDomainAnimationState.IDLE);
        this.f_19804_.m_135372_(DYING_TICK, (Object)0);
        this.f_19804_.m_135372_(GROUND_COLLISION, (Object)false);
        this.f_19804_.m_135372_(RADIUS, (Object)0);
    }

    @Override
    protected void tickProjectile() {
        if (this.getDyingTick() > 0) {
            this.setDyingTick(this.getDyingTick() - 1);
            if (this.getDyingTick() <= 0) {
                this.m_146870_();
            }
            return;
        }
        if (!this.hasAppliedMovement) {
            if (!this.m_9236_().f_46443_) {
                this.m_20334_(this.xPower, this.yPower, this.zPower);
                this.setVelocity(new Vec3(this.xPower, this.yPower, this.zPower));
            } else {
                double d = this.getVelocity().x * this.getVelocity().x + this.getVelocity().y * this.getVelocity().y + this.getVelocity().z * this.getVelocity().z;
                if (!this.delayTick && d < 1.0E-7) {
                    this.delayTick = true;
                    return;
                }
                this.m_20256_(new Vec3((double)this.getVelocity().x, (double)this.getVelocity().y, (double)this.getVelocity().z));
            }
            this.transitionTo(VertexDomainAnimationState.SPIN);
            this.hasAppliedMovement = true;
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        this.m_20101_();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.life <= 0) {
            for (int i = 0; i < 5; ++i) {
                double offsetX = (Math.random() - 0.5) * 2.0;
                double offsetY = (Math.random() - 0.5) * 2.0;
                double offsetZ = (Math.random() - 0.5) * 2.0;
                this.m_9236_().m_7106_((ParticleOptions)DustParticleOptions.f_123656_, this.m_20185_() + offsetX, this.m_20186_() + offsetY + (double)(this.m_20206_() * 0.5f), this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
            }
        }
        if ((this.m_20096_() || this.f_19862_) && this.life <= 0) {
            this.life = 1200;
            this.transitionTo(VertexDomainAnimationState.IMPACT);
            this.expansionTick = 20;
            if (!this.m_9236_().f_46443_) {
                this.f_19804_.m_135381_(GROUND_COLLISION, (Object)this.m_20096_());
            }
            this.impactDamage();
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11858_, this.m_5720_(), 3.0f, 2.0f);
        }
        if (this.life > 0) {
            --this.life;
            if (this.expansionTick > 0) {
                --this.expansionTick;
            }
            this.applyEffect();
            if (this.life > 50) {
                this.spawnRedstoneParticle();
            }
            if (!(this.m_9236_().f_46443_ || this.life > 0 && ((Boolean)this.f_19804_.m_135370_(GROUND_COLLISION)).booleanValue() && !this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60795_())) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        this.animationControl();
        if (this.life <= 0) {
            int DESTRUCTION_RANGE = 2;
            this.blockDestructionTick(-DESTRUCTION_RANGE, DESTRUCTION_RANGE, -1, 3, -DESTRUCTION_RANGE, DESTRUCTION_RANGE);
        }
    }

    private void applyEffect() {
        Level level = this.m_9236_();
        if (level.f_46443_) {
            return;
        }
        int r = this.getRadius();
        AABB effectBox = new AABB(this.m_20185_() - (double)r, this.m_20186_() - (double)r, this.m_20189_() - (double)r, this.m_20185_() + (double)r, this.m_20186_() + (double)r, this.m_20189_() + (double)r);
        List entities = this.m_9236_().m_45976_(LivingEntity.class, effectBox);
        for (LivingEntity entity : entities) {
            if (entity instanceof FairkeeperSerpentEntity || !this.applyDamage((Entity)entity, 20, 0.6f)) continue;
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 4));
            this.spawnRedstoneBeamParticle((ServerLevel)level, entity);
        }
    }

    private void spawnInitialRedstoneParticles() {
        float particleScale = 0.2f + (float)Math.random() * 0.2f;
        ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), particleScale);
        for (int i = 0; i < 10; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)particleData, this.m_20185_() + (double)(2.0f * (this.m_9236_().m_213780_().m_188501_() - this.m_9236_().m_213780_().m_188501_())), this.m_20186_() + (double)(2.0f * (this.m_9236_().m_213780_().m_188501_() - this.m_9236_().m_213780_().m_188501_())), this.m_20189_() + (double)(2.0f * (this.m_9236_().m_213780_().m_188501_() - this.m_9236_().m_213780_().m_188501_())), 0.0, 0.0, 0.0);
        }
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
    }

    private void spawnRedstoneParticle() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.m_9236_().m_213780_().m_188501_() > 0.3f) {
            return;
        }
        int radius = this.getRadius();
        Vec3 center = this.m_20182_();
        double centerX = center.f_82479_;
        double centerY = center.f_82480_ - 0.5;
        double centerZ = center.f_82481_;
        int side = this.m_9236_().m_213780_().m_188503_(4);
        double x = centerX;
        double z = centerZ;
        float angleToSide = 0.0f;
        switch (side) {
            case 0: {
                x = centerX + (double)radius + 0.49;
                z = centerZ - (double)radius + this.m_9236_().m_213780_().m_188500_() * (double)(radius * 2);
                angleToSide = 270.0f;
                break;
            }
            case 1: {
                x = centerX - (double)radius - 0.49;
                z = centerZ - (double)radius + this.m_9236_().m_213780_().m_188500_() * (double)(radius * 2);
                angleToSide = 90.0f;
                break;
            }
            case 2: {
                z = centerZ + (double)radius + 0.49;
                x = centerX - (double)radius + this.m_9236_().m_213780_().m_188500_() * (double)(radius * 2);
                angleToSide = 180.0f;
                break;
            }
            case 3: {
                z = centerZ - (double)radius - 0.49;
                x = centerX - (double)radius + this.m_9236_().m_213780_().m_188500_() * (double)(radius * 2);
                angleToSide = 360.0f;
            }
        }
        angleToSide = (angleToSide + 360.0f) % 360.0f;
        serverLevel.m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.VERTEX_BOUNDARY_PARTICLE.get(), 1, angleToSide), x, centerY, z, 1, 0.0, 0.02, 0.0, 0.0);
    }

    public void m_20256_(Vec3 vec31) {
        Vec3 vec3 = vec31;
        if (((Boolean)this.f_19804_.m_135370_(GROUND_COLLISION)).booleanValue()) {
            vec3 = Vec3.f_82478_;
        }
        super.m_20256_(vec3);
    }

    private void impactDamage() {
        float particleScale = 0.2f + (float)Math.random() * 0.2f;
        ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), particleScale);
        for (int i = 0; i < 30; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)particleData, this.m_20185_() + (double)(6.0f * (this.m_9236_().m_213780_().m_188501_() - this.m_9236_().m_213780_().m_188501_())), this.m_20186_() + (double)(6.0f * (this.m_9236_().m_213780_().m_188501_() - this.m_9236_().m_213780_().m_188501_())), this.m_20189_() + (double)(6.0f * (this.m_9236_().m_213780_().m_188501_() - this.m_9236_().m_213780_().m_188501_())), 0.0, 0.0, 0.0);
        }
        this.explosionImmune = true;
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_254849_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 6.0f, Level.ExplosionInteraction.NONE);
        }
        this.explosionImmune = false;
    }

    private void blockDestructionTick(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        for (int ix = minX; ix <= maxX; ++ix) {
            for (int iz = minZ; iz <= maxZ; ++iz) {
                for (int iy = minY; iy <= maxY; ++iy) {
                    int dx = this.m_146903_() + ix;
                    int dy = this.m_146904_() + iy;
                    int dz = this.m_146907_() + iz;
                    BlockPos blockPos = new BlockPos(dx, dy, dz);
                    BlockState blockState = this.m_9236_().m_8055_(blockPos);
                    if (blockState.m_60795_() || blockState.m_204336_(BlockTags.f_13070_) || blockState.m_204336_(DNLTags.TORCH_BLOCKS)) continue;
                    DNLLevelUtil.destroyBlockMulti(this.m_9236_(), blockPos, false, this, 3);
                }
            }
        }
    }

    private void animationControl() {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        if (this.impactAnimationTimeOut-- > 0 && this.impactAnimationTimeOut <= 0) {
            this.transitionTo(VertexDomainAnimationState.IDLE);
        }
        if (this.impactAnimationState.m_216984_() && this.impactAnimationTimeOut <= 0) {
            this.impactAnimationTimeOut = 5;
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        this.applyDamage(entityHitResult.m_82443_(), 20, 1.0f);
    }

    private boolean applyDamage(Entity targetEntity, int baseDamage, float ownerAttackPercentage) {
        Entity entity;
        LivingEntity owner = null;
        int damage = baseDamage;
        if (this.m_19749_() != null && (entity = this.m_19749_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            damage = (int)(livingEntity.m_21133_(Attributes.f_22281_) * (double)ownerAttackPercentage);
            owner = livingEntity;
        }
        if (targetEntity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)targetEntity;
            return target.m_6469_(this.m_9236_().m_269111_().m_269299_((Entity)this, owner), (float)damage);
        }
        return false;
    }

    private void spawnRedstoneBeamParticle(ServerLevel level, LivingEntity target) {
        Vec3 start = this.m_20182_().m_82520_(0.0, this.m_20191_().m_82376_() / 2.0, 0.0);
        Vec3 end = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0);
        Vec3 direction = end.m_82546_(start);
        double distance = direction.m_82553_();
        double stepSize = 0.5;
        int particleCount = (int)(distance / stepSize);
        Vec3 step = direction.m_82541_().m_82490_(stepSize);
        float particleScale = 0.2f + (float)Math.random() * 0.2f;
        ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), particleScale);
        for (int i = 0; i <= particleCount; ++i) {
            Vec3 particlePos = start.m_82549_(step.m_82490_((double)i));
            level.m_8767_((ParticleOptions)particleData, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            level.m_8767_((ParticleOptions)DustParticleOptions.f_123656_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void outlineCauseBlock(ServerLevel level, BlockPos blockPos) {
        double x = (double)blockPos.m_123341_() + 0.5;
        double y = (double)blockPos.m_123342_() + 0.5;
        double z = (double)blockPos.m_123343_() + 0.5;
        level.m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 270.0f), (double)((float)blockPos.m_123341_() + 1.1f), y, z, 1, 0.0, 0.0, 0.0, 0.0);
        level.m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 90.0f), (double)((float)blockPos.m_123341_() - 0.1f), y, z, 1, 0.0, 0.0, 0.0, 0.0);
        level.m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 0, 90.0f), x, (double)((float)blockPos.m_123342_() + 1.1f), z, 1, 0.0, 0.0, 0.0, 0.0);
        level.m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 0, 270.0f), x, (double)((float)blockPos.m_123342_() - 0.1f), z, 1, 0.0, 0.0, 0.0, 0.0);
        level.m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 180.0f), x, y, (double)((float)blockPos.m_123343_() + 1.1f), 1, 0.0, 0.0, 0.0, 0.0);
        level.m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 0.0f), x, y, (double)((float)blockPos.m_123343_() - 0.1f), 1, 0.0, 0.0, 0.0, 0.0);
    }

    public void spawnBoundaryParticles(int radius) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double centerX = (float)Mth.m_14107_((double)this.m_20185_()) + 0.5f;
        double centerY = (float)Mth.m_14107_((double)this.m_20186_()) + 0.5f;
        double centerZ = (float)Mth.m_14107_((double)this.m_20189_()) + 0.5f;
        double halfSize = (float)radius - 0.5f;
        double minX = centerX - halfSize;
        double maxX = centerX + halfSize;
        double minY = centerY - halfSize;
        double maxY = centerY + halfSize;
        double minZ = centerZ - halfSize;
        double maxZ = centerZ + halfSize;
        float xy = (float)(1.0 - (double)((float)(maxX - minX)) * (maxY - minY) / 1024.0);
        float xz = (float)(1.0 - (double)((float)(maxX - minX)) * (maxZ - minZ) / 1024.0);
        float yz = (float)(1.0 - (double)((float)(maxY - minY)) * (maxZ - minZ) / 1024.0);
        double x = minX + (maxX - minX) * (double)this.m_9236_().f_46441_.m_188501_();
        double y = minY + (maxY - minY) * (double)this.m_9236_().f_46441_.m_188501_();
        double z = minZ + (maxZ - minZ) * (double)this.m_9236_().f_46441_.m_188501_();
        float r = this.m_9236_().f_46441_.m_188501_();
        if (r + 0.2f > yz) {
            serverLevel.m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 90.0f), minX + (double)((this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.1f), y, z, 1, 0.0, 0.0, 0.0, 0.0);
            serverLevel.m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 270.0f), maxX + (double)((this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.1f), y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (r + 0.2f > xz) {
            serverLevel.m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 0, 270.0f), x, minY + (double)((this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.1f), z, 1, 0.0, 0.0, 0.0, 0.0);
            serverLevel.m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 0, 90.0f), x, maxY + (double)((this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.1f), z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (r + 0.2f > xy) {
            serverLevel.m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 0.0f), x, y, minZ + (double)((this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.1f), 1, 0.0, 0.0, 0.0, 0.0);
            serverLevel.m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 180.0f), x, y, maxZ + (double)((this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.1f), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_7337_(Entity entity) {
        return entity.m_5829_() || entity.m_6094_();
    }

    public boolean m_5829_() {
        return this.getDyingTick() <= 0;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_7334_(Entity $$0) {
    }

    public void m_5997_(double $$0, double $$1, double $$2) {
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268565_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6063_() {
        return false;
    }

    public void shootTowardsTarget(double x, double y, double z, LivingEntity target, float speed, float inaccuracy) {
        this.m_7678_(x, y, z, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        Vec3 direction = new Vec3(target.m_20185_() - this.m_20185_(), target.m_20186_() - this.m_20186_(), target.m_20189_() - this.m_20189_()).m_82541_();
        double randX = Mth.m_216263_((RandomSource)this.f_19796_, (double)-1.0, (double)1.0) * (double)inaccuracy;
        double randY = Mth.m_216263_((RandomSource)this.f_19796_, (double)-1.0, (double)1.0) * (double)inaccuracy;
        double randZ = Mth.m_216263_((RandomSource)this.f_19796_, (double)-1.0, (double)1.0) * (double)inaccuracy;
        Vec3 inaccurateDirection = new Vec3(direction.f_82479_ + randX, direction.f_82480_ + randY, direction.f_82481_ + randZ).m_82541_();
        this.xPower = inaccurateDirection.f_82479_ * (double)speed;
        this.yPower = inaccurateDirection.f_82480_ * (double)speed;
        this.zPower = inaccurateDirection.f_82481_ * (double)speed;
    }

    public void shoot(double x, double y, double z, double targetX, double targetY, double targetZ, float speed, float inaccuracy) {
        this.m_7678_(x, y, z, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        Vec3 direction = new Vec3(targetX - this.m_20185_(), targetY - this.m_20186_(), targetZ - this.m_20189_()).m_82541_();
        double randX = Mth.m_216263_((RandomSource)this.f_19796_, (double)-1.0, (double)1.0) * (double)inaccuracy;
        double randY = Mth.m_216263_((RandomSource)this.f_19796_, (double)-1.0, (double)1.0) * (double)inaccuracy;
        double randZ = Mth.m_216263_((RandomSource)this.f_19796_, (double)-1.0, (double)1.0) * (double)inaccuracy;
        Vec3 inaccurateDirection = new Vec3(direction.f_82479_ + randX, direction.f_82480_ + randY, direction.f_82481_ + randZ).m_82541_();
        this.xPower = inaccurateDirection.f_82479_ * (double)speed;
        this.yPower = inaccurateDirection.f_82480_ * (double)speed;
        this.zPower = inaccurateDirection.f_82481_ * (double)speed;
        this.m_20334_(this.xPower, this.yPower, this.zPower);
        this.setVelocity(new Vec3(this.xPower, this.yPower, this.zPower));
        this.transitionTo(VertexDomainAnimationState.SPIN);
        this.hasAppliedMovement = true;
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        boolean bl;
        if (this.m_6673_(damageSource)) {
            return false;
        }
        if (this.getDyingTick() > 0) {
            return false;
        }
        if (this.m_9236_().f_46443_ || this.m_213877_()) {
            return true;
        }
        if (this.explosionImmune) {
            return false;
        }
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + f);
        this.m_5834_();
        this.m_146852_(GameEvent.f_223706_, damageSource.m_7639_());
        boolean bl2 = bl = damageSource.m_7639_() instanceof Player && ((Player)damageSource.m_7639_()).m_150110_().f_35937_;
        if (bl || this.getDamage() > this.health) {
            if (this.getLife() > 0) {
                this.setDyingTick(20);
                this.m_6210_();
            } else {
                this.m_146870_();
            }
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), 3.0f);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, this.m_5720_(), 1.0f, 2.0f);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), DNLSounds.OVERCHARGED_REDSTONE_BLOCK_TNT_EXPLOSION.get(), this.m_5720_(), 1.0f, 2.0f);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5, 2.0, 2.0, 2.0, 0.0);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)particleData, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        return true;
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.getDyingTick() > 0) {
            return EntityDimensions.m_20398_((float)0.0f, (float)0.0f);
        }
        return EntityDimensions.m_20395_((float)1.0f, (float)1.0f);
    }

    public void m_6053_(float f) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIMATION_STATE.equals(entityDataAccessor)) {
            VertexDomainAnimationState animationState = this.getAnimationState();
            this.resetAnimations();
            switch (animationState) {
                case IDLE: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case SPIN: {
                    this.spinAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case IMPACT: {
                    this.impactAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    private void resetAnimations() {
        this.idleAnimationState.m_216973_();
        this.spinAnimationState.m_216973_();
        this.impactAnimationState.m_216973_();
    }

    public VertexDomainProjectileEntity transitionTo(VertexDomainAnimationState state) {
        switch (state) {
            case IDLE: {
                this.setAnimationState(VertexDomainAnimationState.IDLE);
                break;
            }
            case SPIN: {
                this.setAnimationState(VertexDomainAnimationState.SPIN);
                break;
            }
            case IMPACT: {
                this.setAnimationState(VertexDomainAnimationState.IMPACT);
            }
        }
        return this;
    }

    public Vector3f getVelocity() {
        return (Vector3f)this.f_19804_.m_135370_(VELOCITY);
    }

    public void setVelocity(Vec3 vec3) {
        this.f_19804_.m_135381_(VELOCITY, (Object)vec3.m_252839_());
    }

    public void setDamage(float f) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(f));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setHurtTime(int i) {
        this.f_19804_.m_135381_(HURT_TIME, (Object)i);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(HURT_TIME);
    }

    public void setHurtDir(int i) {
        this.f_19804_.m_135381_(HURT_TIME_DIRECT, (Object)i);
    }

    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(HURT_TIME_DIRECT);
    }

    public float getHealth() {
        return this.health;
    }

    public void setHealth(float health) {
        this.health = health;
    }

    public void setDyingTick(int tick) {
        this.f_19804_.m_135381_(DYING_TICK, (Object)tick);
    }

    public int getDyingTick() {
        return (Integer)this.f_19804_.m_135370_(DYING_TICK);
    }

    public int getLife() {
        return this.life;
    }

    public int getImpactAnimationTimeOut() {
        return this.impactAnimationTimeOut;
    }

    public int getExpansionTick() {
        return this.expansionTick;
    }

    public void setRadius(int radius) {
        this.f_19804_.m_135381_(RADIUS, (Object)radius);
    }

    public int getRadius() {
        return (Integer)this.f_19804_.m_135370_(RADIUS);
    }

    public VertexDomainAnimationState getAnimationState() {
        return (VertexDomainAnimationState)((Object)this.f_19804_.m_135370_(ANIMATION_STATE));
    }

    public void setAnimationState(VertexDomainAnimationState state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state);
    }

    public static enum VertexDomainAnimationState {
        IDLE,
        SPIN,
        IMPACT;

    }
}

