/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.hexnowloading.dungeonnowloading.entity.client.animation.VertexDomainProjectileAnimation;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexDomainProjectileEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class VertexDomainProjectileModel<T extends VertexDomainProjectileEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("dungeonnowloading", "vertex_domain_projectile"), "main");
    private final ModelPart fairkeeper_domain_projectile;
    private final ModelPart orb;
    private final ModelPart wave;
    private final ModelPart whoosh;
    private final ModelPart big_whoosh;
    private final ModelPart small_whoosh_below;
    private final ModelPart small_whoosh_above;
    private final ModelPart root;
    private float waveAlpha;

    public VertexDomainProjectileModel(ModelPart root) {
        this.root = root;
        this.fairkeeper_domain_projectile = root.m_171324_("fairkeeper_domain_projectile");
        this.orb = this.fairkeeper_domain_projectile.m_171324_("orb");
        this.wave = this.fairkeeper_domain_projectile.m_171324_("wave");
        this.whoosh = this.fairkeeper_domain_projectile.m_171324_("whoosh");
        this.big_whoosh = this.whoosh.m_171324_("big_whoosh");
        this.small_whoosh_below = this.whoosh.m_171324_("small_whoosh_below");
        this.small_whoosh_above = this.whoosh.m_171324_("small_whoosh_above");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition fairkeeper_domain_projectile = partdefinition.m_171599_("fairkeeper_domain_projectile", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition orb = fairkeeper_domain_projectile.m_171599_("orb", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition wave = fairkeeper_domain_projectile.m_171599_("wave", CubeListBuilder.m_171558_().m_171514_(-112, 144).m_171488_(-56.0f, 0.0f, -56.0f, 112.0f, 0.0f, 112.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.1f, (float)0.0f));
        PartDefinition whoosh = fairkeeper_domain_projectile.m_171599_("whoosh", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition big_whoosh = whoosh.m_171599_("big_whoosh", CubeListBuilder.m_171558_().m_171514_(-42, 32).m_171488_(-21.0f, 0.0f, -21.0f, 42.0f, 0.0f, 42.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition small_whoosh_below = whoosh.m_171599_("small_whoosh_below", CubeListBuilder.m_171558_().m_171514_(-9, 85).m_171488_(-10.0f, 0.0f, -10.0f, 20.0f, 0.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition small_whoosh_above = whoosh.m_171599_("small_whoosh_above", CubeListBuilder.m_171558_().m_171514_(-9, 85).m_171488_(-10.0f, 0.0f, -10.0f, 20.0f, 0.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(VertexDomainProjectileEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entity.getImpactAnimationTimeOut() > 0) {
            this.waveAlpha = Math.max((float)entity.getImpactAnimationTimeOut() / 20.0f, 0.0f);
        }
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float currentAge = (float)(20 - entity.getExpansionTick()) + partialTicks;
        float progress = Math.min(currentAge / 20.0f, 1.0f);
        float scale = Mth.m_14036_((float)((float)(1.0 - Math.pow(1.0f - progress, 5.0))), (float)0.0f, (float)1.0f);
        if (entity.getLife() > 0) {
            this.orb.f_104207_ = entity.getDyingTick() <= 0;
            this.wave.f_104207_ = true;
            this.waveAlpha = 0.8f + 0.2f * (float)Math.sin(ageInTicks * 0.2f);
            if (progress < 1.0f) {
                this.wave.f_233553_ = scale;
                this.wave.f_233555_ = scale;
            } else {
                this.wave.f_233553_ = 1.0f;
                this.wave.f_233555_ = 1.0f;
            }
        } else {
            this.orb.f_104207_ = true;
            this.wave.f_104207_ = false;
        }
        this.m_233381_(entity.idleAnimationState, VertexDomainProjectileAnimation.IDLE, ageInTicks);
        this.m_233381_(entity.spinAnimationState, VertexDomainProjectileAnimation.SPIN, ageInTicks);
        this.m_233381_(entity.impactAnimationState, VertexDomainProjectileAnimation.IMPACT, ageInTicks);
    }

    public void renderToBufferWithEntity(VertexDomainProjectileEntity entity, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.orb.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.wave.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, entity.getDyingTick() > 0 || entity.getLife() > 0 && entity.getLife() < 20 ? alpha : this.waveAlpha);
        this.whoosh.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, entity.getDyingTick() > 0 || entity.getImpactAnimationTimeOut() > 0 && entity.getImpactAnimationTimeOut() < 5 ? this.waveAlpha : alpha);
    }
}

