/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.client.model;

import dev.hexnowloading.dungeonnowloading.entity.client.animation.BallistaGolemAnimation;
import dev.hexnowloading.dungeonnowloading.entity.monster.BallistaGolemEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class BallistaGolemModel<T extends BallistaGolemEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("dungeonnowloading", "ballista_golem"), "main");
    private final ModelPart BallistaGolem;
    private final ModelPart Upperbody;
    private final ModelPart basket;
    private final ModelPart arrows;
    private final ModelPart Bl;
    private final ModelPart Bm;
    private final ModelPart Br;
    private final ModelPart Fl;
    private final ModelPart Fm;
    private final ModelPart Fr;
    private final ModelPart cannon;
    private final ModelPart body;
    private final ModelPart Innerbody;
    private final ModelPart frame;
    private final ModelPart legs;
    private final ModelPart right_front_leg;
    private final ModelPart left_front_leg;
    private final ModelPart right_back_leg;
    private final ModelPart left_back_leg;
    private final ModelPart root;

    public BallistaGolemModel(ModelPart root) {
        this.root = root;
        this.BallistaGolem = root.m_171324_("BallistaGolem");
        this.Upperbody = this.BallistaGolem.m_171324_("Upperbody");
        this.basket = this.Upperbody.m_171324_("basket");
        this.arrows = this.basket.m_171324_("arrows");
        this.Bl = this.arrows.m_171324_("Bl");
        this.Bm = this.arrows.m_171324_("Bm");
        this.Br = this.arrows.m_171324_("Br");
        this.Fl = this.arrows.m_171324_("Fl");
        this.Fm = this.arrows.m_171324_("Fm");
        this.Fr = this.arrows.m_171324_("Fr");
        this.cannon = this.Upperbody.m_171324_("cannon");
        this.body = this.Upperbody.m_171324_("body");
        this.Innerbody = this.body.m_171324_("Innerbody");
        this.frame = this.body.m_171324_("frame");
        this.legs = this.BallistaGolem.m_171324_("legs");
        this.right_front_leg = this.legs.m_171324_("right_front_leg");
        this.left_front_leg = this.legs.m_171324_("left_front_leg");
        this.right_back_leg = this.legs.m_171324_("right_back_leg");
        this.left_back_leg = this.legs.m_171324_("left_back_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition BallistaGolem = partdefinition.m_171599_("BallistaGolem", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)26.0f, (float)0.0f));
        PartDefinition Upperbody = BallistaGolem.m_171599_("Upperbody", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)20.0f));
        PartDefinition basket = Upperbody.m_171599_("basket", CubeListBuilder.m_171558_().m_171514_(0, 192).m_171488_(-17.0f, -5.0f, -6.0f, 34.0f, 5.0f, 34.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-49.0f, (float)-31.0f));
        PartDefinition arrows = basket.m_171599_("arrows", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)14.5f, (float)10.0f));
        PartDefinition Bl = arrows.m_171599_("Bl", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5208f, (float)13.5154f, (float)1.0f));
        PartDefinition cube_r1 = Bl.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(200, 200).m_171488_(-16.0f, -58.0f, 12.0f, 11.0f, 31.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)4.0f, (float)-6.0f, (float)-0.1772f, (float)-0.1719f, (float)0.0306f));
        PartDefinition Bm = arrows.m_171599_("Bm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5208f, (float)14.5154f, (float)1.0f));
        PartDefinition cube_r2 = Bm.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(200, 200).m_171488_(-5.0f, -48.0f, 12.0f, 11.0f, 31.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-9.0f, (float)-11.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition Br = arrows.m_171599_("Br", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5208f, (float)13.5154f, (float)1.0f));
        PartDefinition cube_r3 = Br.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(200, 200).m_171488_(7.0f, -58.0f, 9.0f, 11.0f, 31.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-11.0f, (float)-0.2451f, (float)-0.4102f, (float)0.1726f));
        PartDefinition Fl = arrows.m_171599_("Fl", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5208f, (float)14.5154f, (float)1.0f));
        PartDefinition cube_r4 = Fl.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(200, 200).m_171488_(-8.0f, -53.0f, -1.0f, 11.0f, 31.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.3054f, (float)0.6981f, (float)0.0f));
        PartDefinition Fm = arrows.m_171599_("Fm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5208f, (float)15.5154f, (float)1.0f));
        PartDefinition cube_r5 = Fm.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(200, 200).m_171488_(-16.0f, -48.0f, -10.0f, 11.0f, 31.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)0.0f, (float)-0.3855f, (float)-0.8607f, (float)0.2119f));
        PartDefinition Fr = arrows.m_171599_("Fr", CubeListBuilder.m_171558_().m_171514_(200, 200).m_171488_(5.0f, -49.0f, -10.0f, 11.0f, 31.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5208f, (float)10.5154f, (float)1.0f));
        PartDefinition cannon = Upperbody.m_171599_("cannon", CubeListBuilder.m_171558_().m_171514_(144, 9).m_171488_(-8.0f, -13.0f, -3.0f, 16.0f, 16.0f, 23.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-16.0f, (float)-45.0f));
        PartDefinition body = Upperbody.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-43.0f));
        PartDefinition Innerbody = body.m_171599_("Innerbody", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-24.0f, -24.0f, -24.0f, 48.0f, 48.0f, 48.0f, new CubeDeformation(-1.0f)), PartPose.m_171419_((float)0.0f, (float)-24.0f, (float)23.0f));
        PartDefinition frame = body.m_171599_("frame", CubeListBuilder.m_171558_().m_171514_(0, 96).m_171488_(-24.0f, -64.0f, -24.0f, 48.0f, 48.0f, 48.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)23.0f));
        PartDefinition legs = BallistaGolem.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)6.0f, (float)-2.0f, (float)-6.0f));
        PartDefinition right_front_leg = legs.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(136, 199).m_171488_(-8.0f, -1.0f, -8.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-19.0f, (float)-15.0f, (float)-7.0f));
        PartDefinition left_front_leg = legs.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(136, 199).m_171488_(25.0f, -16.0f, -15.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-26.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_back_leg = legs.m_171599_("right_back_leg", CubeListBuilder.m_171558_().m_171514_(136, 199).m_171488_(-8.0f, -2.0f, -8.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-19.0f, (float)-14.0f, (float)19.0f));
        PartDefinition left_back_leg = legs.m_171599_("left_back_leg", CubeListBuilder.m_171558_().m_171514_(136, 199).m_171488_(-8.0f, -16.4227f, -10.0179f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)0.0f, (float)21.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(BallistaGolemEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.isStationary()) {
            this.m_267799_(BallistaGolemAnimation.WALKING, limbSwing, limbSwingAmount, 4.0f, 4.5f);
        }
        int arrowCount = entity.getBallistaArrowCount();
        this.Bl.f_104207_ = true;
        this.Bm.f_104207_ = true;
        this.Br.f_104207_ = true;
        this.Fl.f_104207_ = true;
        this.Fm.f_104207_ = true;
        this.Fr.f_104207_ = true;
        if (arrowCount < 6) {
            this.Bl.f_104207_ = false;
        }
        if (arrowCount < 5) {
            this.Fm.f_104207_ = false;
        }
        if (arrowCount < 4) {
            this.Br.f_104207_ = false;
        }
        if (arrowCount < 3) {
            this.Fl.f_104207_ = false;
        }
        if (arrowCount < 2) {
            this.Bm.f_104207_ = false;
        }
        if (arrowCount < 1) {
            this.Fr.f_104207_ = false;
        }
        this.m_233381_(entity.idleAnimationState, BallistaGolemAnimation.IDLE, ageInTicks);
        this.m_233381_(entity.wakeUpAnimationState, BallistaGolemAnimation.WAKE_UP, ageInTicks);
        this.m_233381_(entity.reloadAnimationState, BallistaGolemAnimation.RELOAD, ageInTicks);
        this.m_233381_(entity.shootAnimationState, BallistaGolemAnimation.SHOOT, ageInTicks);
        this.animateHeadLookTarget(netHeadYaw, headPitch);
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.BallistaGolem.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
    }
}

