/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.boss;

import com.google.common.collect.ImmutableList;
import dev.hexnowloading.dungeonnowloading.block.entity.PreserverBlockEntity;
import dev.hexnowloading.dungeonnowloading.block.entity.VertexPillarBlockEntity;
import dev.hexnowloading.dungeonnowloading.config.BossConfig;
import dev.hexnowloading.dungeonnowloading.entity.ai.BossTargetSelectorGoal;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperOurosEntity;
import dev.hexnowloading.dungeonnowloading.entity.misc.SpecialItemEntity;
import dev.hexnowloading.dungeonnowloading.entity.monster.ScuttleEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityScale;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.entity.util.ExhaustionTracker;
import dev.hexnowloading.dungeonnowloading.entity.util.SpawnMobUtil;
import dev.hexnowloading.dungeonnowloading.entity.util.WeightBaseMoveSet;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CFadeInTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CFadeOutBackgroundMusicSoundPacket;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStartTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStopTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.platform.Services;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLItems;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.sound.TickingSoundTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class FairkeeperSerpentCallerEntity
extends Entity {
    private static final EntityDataAccessor<FairkeeperSerpentCallerAnimationState> ANIMATION_STATE = SynchedEntityData.m_135353_(FairkeeperSerpentCallerEntity.class, EntityStates.FAIRKEEPER_SERPENT_CALLER_ANIMATION_STATE);
    private static final EntityDataAccessor<Boolean> ACTIVATED = SynchedEntityData.m_135353_(FairkeeperSerpentCallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> BOROS_UUID = SynchedEntityData.m_135353_(FairkeeperSerpentCallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> OUROS_UUID = SynchedEntityData.m_135353_(FairkeeperSerpentCallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> HORIZONTAL_OFFSET = SynchedEntityData.m_135353_(FairkeeperSerpentCallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> VERTICAL_OFFSET = SynchedEntityData.m_135353_(FairkeeperSerpentCallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(FairkeeperSerpentCallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState activeAnimationState = new AnimationState();
    private static final int SPAWN_OFFSET_X = 20;
    private static final int SPAWN_OFFSET_Y = 15;
    private final int BEHIND_BLOCK_SPAWN_OFFSET = 5;
    private final int ARENA_SIZE = 36;
    private final int MAX_SCUTTLE_COUNT = 6;
    private DamageSource lastDamageSource;
    private FairkeeperBorosEntity boros;
    private FairkeeperOurosEntity ouros;
    private boolean hasAddedDesperateMove;
    private boolean burrowing;
    private boolean borosWaitingForCommand;
    private boolean ourosWaitingForCommand;
    private int isBorosDefeated;
    private int isOurosDefeated;
    private UUID pendingBorosUUID;
    private UUID pendingOurosUUID;
    private int activationTick;
    private int musicTick;
    private Set<UUID> playerUUIDs;
    private Set<UUID> minionUUIDs;
    private WeightBaseMoveSet<Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>> introMoveSet = new WeightBaseMoveSet();
    private WeightBaseMoveSet<Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>> comboMoveSet = new WeightBaseMoveSet();
    private WeightBaseMoveSet<Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>> directMoveSet = new WeightBaseMoveSet();
    private WeightBaseMoveSet<FairkeeperOurosEntity.FairkeeperOurosState> ourosMoveSet = new WeightBaseMoveSet();
    private WeightBaseMoveSet<FairkeeperOurosEntity.FairkeeperOurosState> ourosPillarMoveSet = new WeightBaseMoveSet();
    private WeightBaseMoveSet<FairkeeperBorosEntity.FairkeeperBorosState> borosMoveSet = new WeightBaseMoveSet();
    private WeightBaseMoveSet<FairkeeperBorosEntity.FairkeeperBorosState> borosArrowMoveSet = new WeightBaseMoveSet();
    private WeightBaseMoveSet<FairkeeperBorosEntity.FairkeeperBorosState> borosPursueMoveSet = new WeightBaseMoveSet();
    private ExhaustionTracker ourosExhaustion = new ExhaustionTracker(10.0f);
    private ExhaustionTracker borosExhaustion = new ExhaustionTracker(10.0f);
    private static final Map<FairkeeperOurosEntity.FairkeeperOurosState, Float> OUROS_EXHAUSTION_MAP = Map.of(FairkeeperOurosEntity.FairkeeperOurosState.SUMMON_SCUTTLE, Float.valueOf(2.0f), FairkeeperOurosEntity.FairkeeperOurosState.SUMMON_MORE_SCUTTLES, Float.valueOf(2.0f), FairkeeperOurosEntity.FairkeeperOurosState.SHOOT_SINGLE_VERTEX_ORB, Float.valueOf(1.0f), FairkeeperOurosEntity.FairkeeperOurosState.SHOOT_TRIPLE_VERTEX_ORB, Float.valueOf(2.0f), FairkeeperOurosEntity.FairkeeperOurosState.SHOOT_VERTEX_DOMAIN, Float.valueOf(5.0f), FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_LINE_CENTER, Float.valueOf(2.0f), FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_LINE_INNER, Float.valueOf(2.0f), FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_LINE_OUTER, Float.valueOf(2.0f), FairkeeperOurosEntity.FairkeeperOurosState.DESPERATE, Float.valueOf(8.0f));
    private static final Map<FairkeeperBorosEntity.FairkeeperBorosState, Float> BOROS_EXHAUSTION_MAP = Map.of(FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_LINE_FAST, Float.valueOf(2.0f), FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_SMALL_CIRCLE, Float.valueOf(2.0f), FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_LARGE_CIRCLE, Float.valueOf(2.0f), FairkeeperBorosEntity.FairkeeperBorosState.TACKLE, Float.valueOf(2.0f), FairkeeperBorosEntity.FairkeeperBorosState.TACKLE_FAST, Float.valueOf(2.0f), FairkeeperBorosEntity.FairkeeperBorosState.FLAME_TACKLE, Float.valueOf(4.0f), FairkeeperBorosEntity.FairkeeperBorosState.PURSUE_AND_SHOOT_TRIPLE_ARROW, Float.valueOf(2.0f), FairkeeperBorosEntity.FairkeeperBorosState.DESPERATE, Float.valueOf(8.0f));
    private static final ImmutableList<FairkeeperBorosEntity.FairkeeperBorosState> BOROS_WAITING_STATES = ImmutableList.of((Object)((Object)FairkeeperBorosEntity.FairkeeperBorosState.IDLE));
    private static final ImmutableList<FairkeeperOurosEntity.FairkeeperOurosState> OUROS_WAITING_STATES = ImmutableList.of((Object)((Object)FairkeeperOurosEntity.FairkeeperOurosState.IDLE));

    public FairkeeperSerpentCallerEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.playerUUIDs = new HashSet<UUID>();
        this.minionUUIDs = new HashSet<UUID>();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)FairkeeperSerpentCallerAnimationState.NONE);
        this.f_19804_.m_135372_(ACTIVATED, (Object)false);
        this.f_19804_.m_135372_(BOROS_UUID, Optional.empty());
        this.f_19804_.m_135372_(OUROS_UUID, Optional.empty());
        this.f_19804_.m_135372_(HORIZONTAL_OFFSET, (Object)0);
        this.f_19804_.m_135372_(VERTICAL_OFFSET, (Object)0);
        this.f_19804_.m_135372_(PHASE, (Object)0);
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128379_("Activated", this.isActivated());
        if (this.getBorosId() != null) {
            compoundTag.m_128362_("BorosUUID", this.getBorosId());
        }
        if (this.getOurosId() != null) {
            compoundTag.m_128362_("OurosUUID", this.getOurosId());
        }
        compoundTag.m_128405_("IsBorosDefeated", this.isBorosDefeated);
        compoundTag.m_128405_("IsOurosDefeated", this.isOurosDefeated);
        compoundTag.m_128405_("HorizontalOffset", this.getHorizontalOffset());
        compoundTag.m_128405_("VerticalOffset", this.getVerticalOffset());
        compoundTag.m_128405_("Phase", this.getPhase());
        ListTag listTag = new ListTag();
        CompoundTag uuidCompoundTag = new CompoundTag();
        Iterator<UUID> var = this.playerUUIDs.iterator();
        int i = 0;
        while (var.hasNext()) {
            listTag.add((Object)uuidCompoundTag);
            uuidCompoundTag.m_128362_("PlayerUUID" + i, var.next());
            ++i;
        }
        compoundTag.m_128365_("PlayerUUIDs", (Tag)listTag);
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.f_19804_.m_135381_(ACTIVATED, (Object)compoundTag.m_128471_("Activated"));
        if (compoundTag.m_128403_("BorosUUID")) {
            this.setBorosId(compoundTag.m_128342_("BorosUUID"));
            this.pendingBorosUUID = this.getBorosId();
        }
        if (compoundTag.m_128403_("OurosUUID")) {
            this.setOurosId(compoundTag.m_128342_("OurosUUID"));
            this.pendingOurosUUID = this.getOurosId();
        }
        this.isOurosDefeated = compoundTag.m_128451_("IsOurosDefeated");
        this.isBorosDefeated = compoundTag.m_128451_("IsBorosDefeated");
        this.f_19804_.m_135381_(HORIZONTAL_OFFSET, (Object)compoundTag.m_128451_("HorizontalOffset"));
        this.f_19804_.m_135381_(VERTICAL_OFFSET, (Object)compoundTag.m_128451_("VerticalOffset"));
        this.f_19804_.m_135381_(PHASE, (Object)compoundTag.m_128451_("Phase"));
        if (compoundTag.m_128425_("PlayerUUIDs", 9)) {
            ListTag listTag = compoundTag.m_128437_("PlayerUUIDs", 10);
            for (int a = 0; a < listTag.size(); ++a) {
                CompoundTag compoundTag1 = listTag.m_128728_(a);
                this.playerUUIDs.add(compoundTag1.m_128342_("PlayerUUID" + a));
            }
        }
    }

    public void startBossFight() {
        this.activationTick = 60;
        this.isBorosDefeated = 0;
        this.isOurosDefeated = 0;
        this.ourosExhaustion.resetExhaustion();
        this.borosExhaustion.resetExhaustion();
        this.m_5496_(DNLSounds.FAIRKEEPER_SERPENT_CALLER_ACTIVATED.get(), 3.0f, 1.0f);
        this.playBossMusic();
        this.m_5496_(DNLSounds.FAIRKEEPERS_INTRO.get(), 3.0f, 1.0f);
        this.clearAllMoveSet();
        this.setActivated(true);
        this.setOffsets(20, 15);
        this.transitionTo(FairkeeperSerpentCallerAnimationState.ACTIVE);
        AABB bossArena = new AABB(this.m_20183_()).m_82400_(36.0);
        List players = this.m_9236_().m_45976_(ServerPlayer.class, bossArena);
        for (ServerPlayer p : players) {
            this.playerUUIDs.add(p.m_20148_());
        }
    }

    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        if (this.isBorosDefeated <= 0 && this.boros == null && this.pendingBorosUUID != null && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.pendingBorosUUID)) instanceof FairkeeperBorosEntity) {
            FairkeeperBorosEntity borosEntity;
            this.boros = borosEntity = (FairkeeperBorosEntity)entity;
            this.pendingBorosUUID = null;
        }
        if (this.isOurosDefeated <= 0 && this.ouros == null && this.pendingOurosUUID != null && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.pendingOurosUUID)) instanceof FairkeeperOurosEntity) {
            FairkeeperOurosEntity ourosEntity;
            this.ouros = ourosEntity = (FairkeeperOurosEntity)entity;
            this.pendingOurosUUID = null;
        }
        if (!this.m_9236_().f_46443_ && this.f_19804_.m_135370_(ANIMATION_STATE) == FairkeeperSerpentCallerAnimationState.NONE) {
            this.transitionTo(FairkeeperSerpentCallerAnimationState.IDLE);
        }
        if (this.isActivated() && !this.m_9236_().f_46443_) {
            ++this.musicTick;
            if (this.musicTick >= 3242) {
                this.musicTick = 0;
                this.playLoopMusic();
            }
            switch (this.getPhase()) {
                case 0: {
                    if (this.activationTick > 0) {
                        --this.activationTick;
                        break;
                    }
                    this.summonBosses();
                    this.setPhase(1);
                    this.burrowing = true;
                    this.spawnEmergingParticles();
                    break;
                }
                case 1: {
                    if (this.burrowing) {
                        this.spawnBurrowingParticles();
                    }
                    if (this.isBorosWaitingForCommand() && this.isOurosWaitingForCommand()) {
                        this.introMoveSet();
                        this.burrowing = false;
                    }
                    if (this.activationTick > 0) {
                        --this.activationTick;
                        break;
                    }
                    if (this.getHealthRatio() < 0.75f) {
                        this.setPhase(2);
                        this.clearAllMoveSet();
                        break;
                    }
                    if (this.isAllPlayersInBound()) {
                        this.activationTick = 10;
                        break;
                    }
                    this.resetBosses();
                    break;
                }
                case 2: {
                    if (this.isBorosWaitingForCommand()) {
                        this.commandBorosPhase2();
                    }
                    if (this.isOurosWaitingForCommand()) {
                        this.commandOurosPhase2();
                    }
                    if (this.activationTick > 0) {
                        --this.activationTick;
                        break;
                    }
                    if (this.isOurosDefeated > 2 || this.isBorosDefeated > 2) {
                        if (this.isBorosDefeated > 2) {
                            this.fadeInOurosMusic();
                        } else {
                            this.fadeInBorosMusic();
                        }
                        this.setPhase(3);
                        this.clearAllMoveSet();
                        break;
                    }
                    if (this.isAllPlayersInBound()) {
                        this.activationTick = 10;
                        break;
                    }
                    this.resetBosses();
                    break;
                }
                case 3: {
                    if (this.isBorosWaitingForCommand()) {
                        this.commandBorosPhase2();
                    }
                    if (this.isOurosWaitingForCommand()) {
                        this.commandOurosPhase2();
                    }
                    if (this.activationTick > 0) {
                        --this.activationTick;
                        break;
                    }
                    if (this.isBorosDefeated > 2 && this.isOurosDefeated > 2) {
                        this.defeatedBosses();
                        this.setPhase(4);
                        break;
                    }
                    if (this.isAllPlayersInBound()) {
                        this.activationTick = 10;
                        break;
                    }
                    this.resetBosses();
                    break;
                }
            }
        }
    }

    private float getHealthRatio() {
        if (this.boros == null || this.ouros == null) {
            return 0.0f;
        }
        return (float)((double)(this.ouros.m_21223_() + this.boros.m_21223_()) / (this.ouros.m_21133_(Attributes.f_22276_) + this.boros.m_21133_(Attributes.f_22276_)));
    }

    private void introMoveSet() {
        BossTargetSelectorGoal.changeTarget(this.boros);
        BossTargetSelectorGoal.changeTarget(this.ouros);
        if (this.boros.m_5448_() == null && this.ouros.m_5448_() == null) {
            return;
        }
        if (this.introMoveSet.isEmpty()) {
            this.introMoveSet.addMove((Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>)new Pair((Object)FairkeeperBorosEntity.FairkeeperBorosState.IDLE, (Object)FairkeeperOurosEntity.FairkeeperOurosState.SUMMON_SCUTTLE), 1, 2, 2);
            this.introMoveSet.addMove((Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>)new Pair((Object)FairkeeperBorosEntity.FairkeeperBorosState.IDLE, (Object)FairkeeperOurosEntity.FairkeeperOurosState.SHOOT_SINGLE_VERTEX_ORB), 1, 0, 0);
            this.introMoveSet.addMove((Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>)new Pair((Object)FairkeeperBorosEntity.FairkeeperBorosState.IDLE, (Object)FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_RANDOM), 1, 2, 0);
            this.introMoveSet.addMove((Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>)new Pair((Object)FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_LINE, (Object)FairkeeperOurosEntity.FairkeeperOurosState.IDLE), 1, 2, 1);
            this.introMoveSet.addMove((Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>)new Pair((Object)FairkeeperBorosEntity.FairkeeperBorosState.TACKLE, (Object)FairkeeperOurosEntity.FairkeeperOurosState.IDLE), 1, 2, 0);
            this.introMoveSet.addMove((Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>)new Pair((Object)FairkeeperBorosEntity.FairkeeperBorosState.PURSUE_AND_SHOOT_SINGLE_ARROW, (Object)FairkeeperOurosEntity.FairkeeperOurosState.IDLE), 1, 1, 0);
        }
        if (this.directMoveSet.isEmpty()) {
            this.directMoveSet.addMove((Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>)new Pair((Object)FairkeeperBorosEntity.FairkeeperBorosState.IDLE, (Object)FairkeeperOurosEntity.FairkeeperOurosState.SHOOT_SINGLE_VERTEX_ORB), 1, 0, 0);
            this.directMoveSet.addMove((Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>)new Pair((Object)FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_ABOVE, (Object)FairkeeperOurosEntity.FairkeeperOurosState.IDLE), 1, 0, 0);
        }
        if (this.ourosPillarMoveSet.isEmpty()) {
            this.ourosPillarMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_LINE_OUTER, 1, 0, 0);
            this.ourosPillarMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_LINE_CENTER, 1, 0, 1);
        }
        this.ourosBorosAssignState();
    }

    private void commandBorosPhase2() {
        BossTargetSelectorGoal.changeTarget(this.boros);
        if (this.boros.m_5448_() == null) {
            return;
        }
        if (this.borosMoveSet.isEmpty()) {
            this.borosMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_RANDOM, 1, 0, 1);
            this.borosMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.PURSUE_RANDOM, 2, 0, 0);
        }
        if (this.borosArrowMoveSet.isEmpty()) {
            this.borosArrowMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_LINE_FAST, 1, 1, 2);
            this.borosArrowMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_SMALL_CIRCLE, 1, 1, 0);
            this.borosArrowMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_LARGE_CIRCLE, 1, 1, 0);
        }
        if (this.borosPursueMoveSet.isEmpty()) {
            this.borosPursueMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.TACKLE, 3, 1, 1);
            this.borosPursueMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.FLAME_TACKLE, 2, 1, 0);
            this.borosPursueMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.PURSUE_AND_SHOOT_TRIPLE_ARROW, 3, 0, 1);
        }
        this.borosAssignState();
    }

    private void commandOurosPhase2() {
        BossTargetSelectorGoal.changeTarget(this.ouros);
        if (this.ouros.m_5448_() == null) {
            return;
        }
        if (this.ourosMoveSet.isEmpty()) {
            this.ourosMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.SUMMON_SCUTTLE, 3, 2, 3);
            this.ourosMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.SHOOT_SINGLE_VERTEX_ORB, 1, 0, 3);
            this.ourosMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.SHOOT_TRIPLE_VERTEX_ORB, 3, 2, 2);
            this.ourosMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.SHOOT_VERTEX_DOMAIN, 6, 4, 1);
            this.ourosMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_RANDOM, 3, 0);
        }
        if (this.ourosPillarMoveSet.isEmpty()) {
            this.ourosPillarMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_LINE_CENTER, 1, 1, 0);
            this.ourosPillarMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_LINE_INNER, 1, 1, 1);
            this.ourosPillarMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_LINE_OUTER, 1, 1, 0);
        }
        this.ourosAssignState();
    }

    private void ourosBorosAssignState() {
        this.cleanMinionList();
        Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState> statePair = this.isAboveBoros() ? this.directMoveSet.selectMove() : this.introMoveSet.selectMove();
        if (((FairkeeperOurosEntity.FairkeeperOurosState)((Object)statePair.getB())).equals((Object)FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_RANDOM)) {
            statePair = new Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>((Object)((FairkeeperBorosEntity.FairkeeperBorosState)((Object)statePair.getA())), (Object)this.ourosPillarMoveSet.selectMove());
        }
        if (((FairkeeperOurosEntity.FairkeeperOurosState)((Object)statePair.getB())).equals((Object)FairkeeperOurosEntity.FairkeeperOurosState.SUMMON_SCUTTLE)) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            long scuttleCount = this.minionUUIDs.stream().map(arg_0 -> ((ServerLevel)serverLevel).m_8791_(arg_0)).filter(entity -> entity instanceof ScuttleEntity).count();
            if (scuttleCount > 6L) {
                statePair = this.introMoveSet.selectMoveWithoutCooldownReduction();
            }
        }
        if (this.boros.m_5448_() == null) {
            statePair = new Pair((Object)FairkeeperBorosEntity.FairkeeperBorosState.IDLE, (Object)((FairkeeperOurosEntity.FairkeeperOurosState)((Object)statePair.getB())));
        } else if (this.ouros.m_5448_() == null) {
            statePair = new Pair((Object)((FairkeeperBorosEntity.FairkeeperBorosState)((Object)statePair.getA())), (Object)FairkeeperOurosEntity.FairkeeperOurosState.IDLE);
        }
        Entity boros = this.getBoros();
        Entity ouros = this.getOuros();
        boolean isBorosWaiting = false;
        boolean isOurosWaiting = false;
        if (boros != null && ouros != null) {
            ((FairkeeperBorosEntity)boros).setState((FairkeeperBorosEntity.FairkeeperBorosState)((Object)statePair.getA()));
            ((FairkeeperOurosEntity)ouros).setState((FairkeeperOurosEntity.FairkeeperOurosState)((Object)statePair.getB()));
            if (BOROS_WAITING_STATES.contains(statePair.getA())) {
                isBorosWaiting = true;
            }
            if (OUROS_WAITING_STATES.contains(statePair.getB())) {
                isOurosWaiting = true;
            }
        }
        this.setBorosWaitingForCommand(isBorosWaiting);
        this.setOurosWaitingForCommand(isOurosWaiting);
    }

    private void borosAssignState() {
        Entity boros;
        if (this.boros == null) {
            return;
        }
        this.cleanMinionList();
        float exhaustionPercent = this.borosExhaustion.getExhaustionPercent();
        float random = this.f_19796_.m_188501_();
        FairkeeperBorosEntity.FairkeeperBorosState state = this.isAboveBoros() ? FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_ABOVE : (exhaustionPercent > 0.5f && exhaustionPercent > random ? FairkeeperBorosEntity.FairkeeperBorosState.EXHAUSTED : this.borosMoveSet.selectMove());
        if (state == null) {
            state = FairkeeperBorosEntity.FairkeeperBorosState.IDLE;
        }
        if (state.equals((Object)FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_RANDOM)) {
            state = this.borosArrowMoveSet.selectMove();
        }
        if (state.equals((Object)FairkeeperBorosEntity.FairkeeperBorosState.PURSUE_RANDOM)) {
            state = this.borosPursueMoveSet.selectMove();
        }
        if (this.getPhase() > 2 && !this.hasAddedDesperateMove) {
            state = FairkeeperBorosEntity.FairkeeperBorosState.DESPERATE;
            this.hasAddedDesperateMove = true;
            this.borosPursueMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.DESPERATE, 2, 3, 3);
            this.borosPursueMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.TACKLE_FAST, 3, 1, 1);
            this.borosPursueMoveSet.removeMove(FairkeeperBorosEntity.FairkeeperBorosState.TACKLE);
        }
        if ((boros = this.getBoros()) instanceof FairkeeperBorosEntity) {
            FairkeeperBorosEntity borosEntity = (FairkeeperBorosEntity)boros;
            if (state == null) {
                borosEntity.setState(FairkeeperBorosEntity.FairkeeperBorosState.IDLE);
                borosEntity.setAttackTick(60);
                this.ourosMoveSet.reduceAllCooldown();
            } else if (state == FairkeeperBorosEntity.FairkeeperBorosState.EXHAUSTED) {
                borosEntity.setState(FairkeeperBorosEntity.FairkeeperBorosState.IDLE);
                borosEntity.setAttackTick((int)(this.borosExhaustion.getExhaustionPercent() * 200.0f));
                this.borosExhaustion.resetExhaustion();
            } else {
                ((FairkeeperBorosEntity)boros).setState(state);
                float exhaustionCost = BOROS_EXHAUSTION_MAP.getOrDefault((Object)state, Float.valueOf(0.0f)).floatValue();
                this.borosExhaustion.addExhaustion(exhaustionCost);
            }
        }
        this.setBorosWaitingForCommand(false);
    }

    private void ourosAssignState() {
        Entity ouros;
        if (this.ouros == null) {
            return;
        }
        this.cleanMinionList();
        float exhaustionPercent = this.ourosExhaustion.getExhaustionPercent();
        FairkeeperOurosEntity.FairkeeperOurosState state = this.isAboveBoros() ? FairkeeperOurosEntity.FairkeeperOurosState.SHOOT_SINGLE_VERTEX_ORB : (exhaustionPercent > 0.5f && exhaustionPercent > this.f_19796_.m_188501_() ? FairkeeperOurosEntity.FairkeeperOurosState.EXHAUSTED : this.ourosMoveSet.selectMove());
        if (state == null) {
            state = FairkeeperOurosEntity.FairkeeperOurosState.IDLE;
        }
        if (state.equals((Object)FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_RANDOM)) {
            state = this.ourosPillarMoveSet.selectMove();
        }
        if (state.equals((Object)FairkeeperOurosEntity.FairkeeperOurosState.SUMMON_SCUTTLE) || state.equals((Object)FairkeeperOurosEntity.FairkeeperOurosState.SUMMON_MORE_SCUTTLES)) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            long scuttleCount = this.minionUUIDs.stream().map(arg_0 -> ((ServerLevel)serverLevel).m_8791_(arg_0)).filter(entity -> entity instanceof ScuttleEntity).count();
            if (scuttleCount > 6L) {
                state = this.ourosMoveSet.selectMoveWithoutCooldownReduction();
            }
        }
        if (this.getPhase() > 2 && !this.hasAddedDesperateMove) {
            state = FairkeeperOurosEntity.FairkeeperOurosState.DESPERATE;
            this.hasAddedDesperateMove = true;
            this.ourosMoveSet.increaseAllCooldown();
            int previousTotalWeight = this.ourosMoveSet.getTotalWeight();
            this.ourosMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.DESPERATE, previousTotalWeight * 2, 3, 3);
            this.ourosMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.SUMMON_MORE_SCUTTLES, 3, 3, 0);
            this.ourosMoveSet.removeMove(FairkeeperOurosEntity.FairkeeperOurosState.SUMMON_SCUTTLE);
        }
        if ((ouros = this.getOuros()) instanceof FairkeeperOurosEntity) {
            FairkeeperOurosEntity ourosEntity = (FairkeeperOurosEntity)ouros;
            if (state == null) {
                ourosEntity.setState(FairkeeperOurosEntity.FairkeeperOurosState.IDLE);
                ourosEntity.setAttackTick(60);
                this.ourosMoveSet.reduceAllCooldown();
            } else if (state == FairkeeperOurosEntity.FairkeeperOurosState.EXHAUSTED) {
                ourosEntity.setState(FairkeeperOurosEntity.FairkeeperOurosState.IDLE);
                ourosEntity.setAttackTick((int)(this.ourosExhaustion.getExhaustionPercent() * 200.0f));
                this.ourosExhaustion.resetExhaustion();
            } else {
                ((FairkeeperOurosEntity)ouros).setState(state);
                float exhaustionCost = OUROS_EXHAUSTION_MAP.getOrDefault((Object)state, Float.valueOf(0.0f)).floatValue();
                this.ourosExhaustion.addExhaustion(exhaustionCost);
            }
        }
        this.setOurosWaitingForCommand(false);
    }

    private void clearAllMoveSet() {
        this.introMoveSet.clear();
        this.comboMoveSet.clear();
        this.directMoveSet.clear();
        this.ourosMoveSet.clear();
        this.ourosPillarMoveSet.clear();
        this.borosMoveSet.clear();
        this.borosArrowMoveSet.clear();
        this.borosPursueMoveSet.clear();
        this.hasAddedDesperateMove = false;
    }

    private boolean isAboveBoros() {
        return this.boros != null && this.boros.m_5448_() != null && this.boros.m_5448_().m_20186_() > this.boros.m_20186_() + 3.0;
    }

    private void defeatedBosses() {
        this.m_9236_().m_254849_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, Level.ExplosionInteraction.BLOCK);
        if (((Boolean)BossConfig.TOGGLE_MULTIPLAYER_LOOT.get()).booleanValue() && !this.playerUUIDs.isEmpty()) {
            for (UUID playerUUID : this.playerUUIDs) {
                this.spawnLootTableItems(this.lastDamageSource, true, true, playerUUID);
            }
        } else {
            this.spawnLootTableItems(this.lastDamageSource, true, false, null);
        }
        this.removeAllMinions();
        this.removePreservers();
        this.removePillars();
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    private void removePreservers() {
        Level level = this.m_9236_();
        BlockPos center = this.m_20183_();
        int includeWallPreserver = 1;
        int arenaSize = this.getArenaSize() + includeWallPreserver;
        HashMap map = new HashMap();
        int minX = center.m_123341_() - arenaSize;
        int minZ = center.m_123343_() - arenaSize;
        int maxX = center.m_123341_() + arenaSize;
        int maxZ = center.m_123343_() + arenaSize;
        int chunkMinX = SectionPos.m_123171_((int)minX);
        int chunkMinZ = SectionPos.m_123171_((int)minZ);
        int chunkMaxX = SectionPos.m_123171_((int)maxX);
        int chunkMaxZ = SectionPos.m_123171_((int)maxZ);
        for (int x = chunkMinX; x <= chunkMaxX; ++x) {
            for (int z = chunkMinZ; z <= chunkMaxZ; ++z) {
                map.putAll(level.m_6325_(x, z).m_62954_());
            }
        }
        Map<BlockPos, BlockEntity> preserver = map.entrySet().stream().filter(e -> e.getValue() instanceof PreserverBlockEntity).filter(e -> {
            BlockPos pos = (BlockPos)e.getKey();
            return pos.m_123341_() >= minX && pos.m_123341_() <= maxX && pos.m_123343_() >= minZ && pos.m_123343_() <= maxZ && Math.abs(pos.m_123342_() - center.m_123342_()) <= arenaSize;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        preserver.keySet().forEach(pos -> level.m_7731_(pos, Blocks.f_50225_.m_49966_(), 3));
    }

    private void spawnLootTableItems(DamageSource damageSource, boolean b, boolean multiplayer, @javax.annotation.Nullable UUID uuid) {
        Entity entity;
        if (damageSource == null) {
            return;
        }
        ResourceLocation baseResourceLocation = BuiltInRegistries.f_256780_.m_7981_(DNLEntityTypes.FAIRKEEPER_SERPENT_CALLER.get()).m_246208_("entities/");
        ResourceLocation lootTableResourceLocation = this.isBorosDefeated > this.isOurosDefeated ? baseResourceLocation.m_266382_("/boros") : baseResourceLocation.m_266382_("/ouros");
        LootTable lootTable = this.m_9236_().m_7654_().m_278653_().m_278676_(lootTableResourceLocation);
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287289_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)damageSource.m_7640_());
        if (b && (entity = damageSource.m_7639_()) instanceof Player) {
            Player player = (Player)entity;
            builder = builder.m_287286_(LootContextParams.f_81456_, (Object)player).m_287239_(player.m_36336_());
        }
        LootParams lootParams = builder.m_287235_(LootContextParamSets.f_81415_);
        if (multiplayer) {
            lootTable.m_287228_(lootParams, itemStack -> this.spawnSpecialItemEntity((ItemStack)itemStack, 0.0f, uuid));
        } else {
            lootTable.m_287228_(lootParams, arg_0 -> ((FairkeeperSerpentCallerEntity)this).m_19983_(arg_0));
        }
    }

    private void spawnSpecialItemEntity(ItemStack itemStack, float i, UUID uuid) {
        if (!itemStack.m_41619_() && !this.m_9236_().f_46443_ && uuid != null) {
            SpecialItemEntity specialItemEntity = new SpecialItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)i, this.m_20189_(), itemStack);
            specialItemEntity.setPickerUUID(uuid);
            specialItemEntity.m_32060_();
            this.m_9236_().m_7967_((Entity)specialItemEntity);
        }
    }

    private void resetBosses() {
        FairkeeperBorosEntity boros = (FairkeeperBorosEntity)this.getBoros();
        FairkeeperOurosEntity ouros = (FairkeeperOurosEntity)this.getOuros();
        if (boros != null) {
            boros.resetBoss();
        }
        if (ouros != null) {
            ouros.resetBoss();
        }
        this.setActivated(false);
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)FairkeeperSerpentCallerAnimationState.IDLE);
        this.setPhase(0);
        this.activationTick = 0;
        this.musicTick = 0;
        this.playerUUIDs.clear();
        this.removeAllMinions();
        this.removePillars();
        this.stopAllBossMusic();
    }

    public void removePillars() {
        Level level = this.m_9236_();
        BlockPos center = this.m_20183_();
        int arenaSize = this.getArenaSize();
        HashMap map = new HashMap();
        int minX = center.m_123341_() - arenaSize;
        int minZ = center.m_123343_() - arenaSize;
        int maxX = center.m_123341_() + arenaSize;
        int maxZ = center.m_123343_() + arenaSize;
        int chunkMinX = SectionPos.m_123171_((int)minX);
        int chunkMinZ = SectionPos.m_123171_((int)minZ);
        int chunkMaxX = SectionPos.m_123171_((int)maxX);
        int chunkMaxZ = SectionPos.m_123171_((int)maxZ);
        for (int x = chunkMinX; x <= chunkMaxX; ++x) {
            for (int z = chunkMinZ; z <= chunkMaxZ; ++z) {
                map.putAll(level.m_6325_(x, z).m_62954_());
            }
        }
        Map<BlockPos, BlockEntity> filtered = map.entrySet().stream().filter(e -> e.getValue() instanceof VertexPillarBlockEntity).filter(e -> {
            BlockPos pos = (BlockPos)e.getKey();
            return pos.m_123341_() >= minX && pos.m_123341_() <= maxX && pos.m_123343_() >= minZ && pos.m_123343_() <= maxZ && Math.abs(pos.m_123342_() - center.m_123342_()) <= arenaSize;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        filtered.keySet().forEach(pos -> level.m_7471_(pos, false));
    }

    private void removeAllMinions() {
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        for (UUID minionUUID : this.minionUUIDs) {
            Entity minion = serverLevel.m_8791_(minionUUID);
            if (minion == null) continue;
            SpawnMobUtil.createPoofParticle(serverLevel, minion);
            minion.m_146870_();
        }
        this.minionUUIDs.clear();
    }

    private boolean isAllPlayersInBound() {
        if (!((Boolean)BossConfig.TOGGLE_BOSS_RESET.get()).booleanValue()) {
            return false;
        }
        AABB aabb = new AABB(this.m_20183_()).m_82400_(36.0);
        List list = this.m_9236_().m_45976_(Player.class, aabb);
        list.removeIf(player -> !player.m_6084_());
        return !list.isEmpty();
    }

    private void spawnEmergingParticles() {
        BlockPos currentPosition = new BlockPos(this.m_146903_(), this.m_146904_(), this.m_146907_());
        Direction direction = Direction.m_122364_((double)this.m_146908_());
        Direction clockWiseDirection = direction.m_122427_();
        Direction counterClockWiseDirection = direction.m_122428_();
        BlockPos clockWiseTargetPosition = currentPosition.m_5484_(clockWiseDirection, this.getHorizontalOffset()).m_6625_(this.getVerticalOffset());
        BlockPos counterClockWiseTargetPosition = currentPosition.m_5484_(counterClockWiseDirection, this.getHorizontalOffset()).m_6630_(this.getVerticalOffset());
        Vec3 centeredClockWiseTargetPosition = clockWiseTargetPosition.m_252807_();
        Vec3 centeredCounterClockWiseTargetPosition = counterClockWiseTargetPosition.m_252807_();
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, centeredCounterClockWiseTargetPosition.f_82479_, centeredCounterClockWiseTargetPosition.f_82480_, centeredCounterClockWiseTargetPosition.f_82481_, 5, 3.0, 0.0, 3.0, 0.0);
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, centeredClockWiseTargetPosition.f_82479_, centeredClockWiseTargetPosition.f_82480_, centeredClockWiseTargetPosition.f_82481_, 5, 3.0, 0.0, 3.0, 0.0);
    }

    private void spawnBurrowingParticles() {
        BlockPos currentPosition = new BlockPos(this.m_146903_(), this.m_146904_(), this.m_146907_());
        Direction direction = Direction.m_122364_((double)this.m_146908_());
        Direction clockWiseDirection = direction.m_122427_();
        Direction counterClockWiseDirection = direction.m_122428_();
        BlockPos clockWiseTargetPosition = currentPosition.m_5484_(clockWiseDirection, this.getHorizontalOffset()).m_6625_(this.getVerticalOffset());
        BlockPos counterClockWiseTargetPosition = currentPosition.m_5484_(counterClockWiseDirection, this.getHorizontalOffset()).m_6630_(this.getVerticalOffset());
        Vec3 centeredClockWiseTargetPosition = clockWiseTargetPosition.m_252807_();
        Vec3 centeredCounterClockWiseTargetPosition = counterClockWiseTargetPosition.m_252807_();
        BlockState stoneBricks = Blocks.f_50222_.m_49966_();
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, stoneBricks), centeredCounterClockWiseTargetPosition.f_82479_, centeredCounterClockWiseTargetPosition.f_82480_, centeredCounterClockWiseTargetPosition.f_82481_, 10, 3.0, 3.0, 3.0, 0.05);
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, stoneBricks), centeredClockWiseTargetPosition.f_82479_, centeredClockWiseTargetPosition.f_82480_, centeredClockWiseTargetPosition.f_82481_, 10, 3.0, 3.0, 3.0, 0.05);
    }

    private void summonBosses() {
        FairkeeperOurosEntity ouros;
        BlockPos currentPosition = new BlockPos(this.m_146903_(), this.m_146904_(), this.m_146907_());
        Direction direction = Direction.m_122364_((double)this.m_146908_());
        Direction clockWiseDirection = direction.m_122427_();
        Direction counterClockWiseDirection = direction.m_122428_();
        BlockPos clockWiseTargetPosition = currentPosition.m_5484_(clockWiseDirection, this.getHorizontalOffset()).m_6625_(this.getVerticalOffset());
        BlockPos counterClockWiseTargetPosition = currentPosition.m_5484_(counterClockWiseDirection, this.getHorizontalOffset()).m_6630_(this.getVerticalOffset());
        Vec3 centeredClockWiseTargetPosition = clockWiseTargetPosition.m_252807_();
        Vec3 centeredCounterClockWiseTargetPosition = counterClockWiseTargetPosition.m_252807_();
        int playerCount = this.playerUUIDs.size();
        FairkeeperBorosEntity boros = new FairkeeperBorosEntity(this.m_9236_(), this);
        if (boros != null) {
            boros.m_6027_(centeredCounterClockWiseTargetPosition.f_82479_, centeredCounterClockWiseTargetPosition.f_82480_ - boros.m_20191_().m_82376_() / 2.0 + 5.0, centeredCounterClockWiseTargetPosition.f_82481_);
            boros.setState(FairkeeperBorosEntity.FairkeeperBorosState.AWAKENING);
            boros.m_146922_(clockWiseDirection.m_122435_());
            boros.f_20883_ = boros.m_146908_();
            boros.f_20885_ = boros.m_146908_();
            boros.setCanDestroyBlocks(false);
            this.m_9236_().m_7967_((Entity)boros);
            boros.transitionTo(FairkeeperBorosEntity.FairkeeperBorosAnimationState.IDLE);
            this.setBorosId(boros.m_20148_());
            this.setBorosWaitingForCommand(false);
            EntityScale.scaleBossHealth((LivingEntity)boros, playerCount);
            EntityScale.scaleBossAttack((LivingEntity)boros, playerCount);
            EntityScale.scaleBossExhaustion((LivingEntity)boros, playerCount, this.borosExhaustion);
            this.boros = boros;
        }
        if ((ouros = new FairkeeperOurosEntity(this.m_9236_(), this)) != null) {
            ouros.m_6027_(centeredClockWiseTargetPosition.f_82479_, centeredClockWiseTargetPosition.f_82480_ - ouros.m_20191_().m_82376_() / 2.0 - 5.0, centeredClockWiseTargetPosition.f_82481_);
            ouros.setState(FairkeeperOurosEntity.FairkeeperOurosState.AWAKENING);
            ouros.m_146922_(counterClockWiseDirection.m_122435_());
            ouros.f_20883_ = ouros.m_146908_();
            ouros.f_20885_ = ouros.m_146908_();
            ouros.setCanDestroyBlocks(false);
            this.m_9236_().m_7967_((Entity)ouros);
            ouros.transitionTo(FairkeeperOurosEntity.FairkeeperOurosAnimationState.IDLE);
            this.setOurosId(ouros.m_20148_());
            this.setOurosWaitingForCommand(false);
            EntityScale.scaleBossHealth((LivingEntity)ouros, playerCount);
            EntityScale.scaleBossAttack((LivingEntity)ouros, playerCount);
            EntityScale.scaleBossExhaustion((LivingEntity)ouros, playerCount, this.ourosExhaustion);
            this.ouros = ouros;
        }
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIMATION_STATE.equals(entityDataAccessor)) {
            FairkeeperSerpentCallerAnimationState animationState = (FairkeeperSerpentCallerAnimationState)((Object)this.f_19804_.m_135370_(ANIMATION_STATE));
            switch (animationState) {
                case IDLE: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case ACTIVE: {
                    this.activeAnimationState.m_216973_();
                    this.activeAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void transitionTo(FairkeeperSerpentCallerAnimationState state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state);
    }

    public boolean m_6087_() {
        return !this.isActivated() && !this.m_213877_();
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)DNLItems.FAIRKEEPER_SERPENT_CALLER.get());
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.getPhase() < 1) {
            player.m_5661_((Component)Component.m_237115_((String)"entity.dungeonnowloading.fairkeeper_serpent_caller.right_click"), true);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6096_(player, hand);
    }

    public boolean m_6469_(DamageSource damageSource, float v) {
        if (!this.m_9236_().f_46443_ && !this.m_213877_() && damageSource.m_19390_()) {
            this.m_6074_();
            return true;
        }
        return super.m_6469_(damageSource, v);
    }

    private void playBossMusic() {
        float radius = 36.0f;
        AABB detectionBox = this.m_20191_().m_82400_((double)radius);
        List nearbyPlayers = this.m_9236_().m_45976_(ServerPlayer.class, detectionBox);
        ArrayList<ResourceLocation> soundsToStart = new ArrayList<ResourceLocation>(List.of());
        soundsToStart.add(DNLSounds.MUSIC_CLASH_OF_DUALITY_BASE.get().m_11660_());
        soundsToStart.add(DNLSounds.MUSIC_CLASH_OF_DUALITY_BOROS.get().m_11660_());
        soundsToStart.add(DNLSounds.MUSIC_CLASH_OF_DUALITY_OUROS.get().m_11660_());
        for (ServerPlayer player : nearbyPlayers) {
            for (ResourceLocation sound : soundsToStart) {
                Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.m_19879_(), sound, SoundSource.MUSIC, 0.0f, 1.0f, false, 36.0f, 36.0f), player);
            }
            Services.NETWORK.sendToPlayer(new S2CFadeInTickingSoundPacket(this.m_19879_(), DNLSounds.MUSIC_CLASH_OF_DUALITY_BASE.get().m_11660_(), TickingSoundTarget.NEWEST, 1.0f, 60), player);
            Services.NETWORK.sendToPlayer(new S2CFadeOutBackgroundMusicSoundPacket(60), player);
        }
    }

    private void playLoopMusic() {
        float radius = 36.0f;
        AABB detectionBox = this.m_20191_().m_82400_((double)radius);
        List nearbyPlayers = this.m_9236_().m_45976_(ServerPlayer.class, detectionBox);
        for (ServerPlayer player : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.m_19879_(), DNLSounds.MUSIC_CLASH_OF_DUALITY_BASE.get().m_11660_(), SoundSource.MUSIC, 1.0f, 1.0f, false, 36.0f, 36.0f), player);
            if (this.isBorosDefeated > 2) {
                Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.m_19879_(), DNLSounds.MUSIC_CLASH_OF_DUALITY_OUROS.get().m_11660_(), SoundSource.MUSIC, 1.0f, 1.0f, false, 36.0f, 36.0f), player);
                continue;
            }
            if (this.isOurosDefeated > 2) {
                Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.m_19879_(), DNLSounds.MUSIC_CLASH_OF_DUALITY_BOROS.get().m_11660_(), SoundSource.MUSIC, 1.0f, 1.0f, false, 36.0f, 36.0f), player);
                continue;
            }
            Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.m_19879_(), DNLSounds.MUSIC_CLASH_OF_DUALITY_OUROS.get().m_11660_(), SoundSource.MUSIC, 0.0f, 1.0f, false, 36.0f, 36.0f), player);
            Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.m_19879_(), DNLSounds.MUSIC_CLASH_OF_DUALITY_BOROS.get().m_11660_(), SoundSource.MUSIC, 0.0f, 1.0f, false, 36.0f, 36.0f), player);
        }
    }

    public void stopAllBossMusic() {
        float radius = 72.0f;
        AABB detectionBox = this.m_20191_().m_82400_((double)radius);
        List nearbyPlayers = this.m_9236_().m_45976_(ServerPlayer.class, detectionBox);
        ArrayList<ResourceLocation> soundsToStop = new ArrayList<ResourceLocation>(List.of());
        soundsToStop.add(DNLSounds.MUSIC_CLASH_OF_DUALITY_BASE.get().m_11660_());
        soundsToStop.add(DNLSounds.MUSIC_CLASH_OF_DUALITY_BOROS.get().m_11660_());
        soundsToStop.add(DNLSounds.MUSIC_CLASH_OF_DUALITY_OUROS.get().m_11660_());
        for (ServerPlayer otherPlayer : nearbyPlayers) {
            for (ResourceLocation sound : soundsToStop) {
                Services.NETWORK.sendToPlayer(new S2CStopTickingSoundPacket(this.m_19879_(), sound, TickingSoundTarget.ALL, 60, true), otherPlayer);
            }
        }
    }

    public void stopBossMusic() {
        float radius = 72.0f;
        AABB detectionBox = this.m_20191_().m_82400_((double)radius);
        List nearbyPlayers = this.m_9236_().m_45976_(ServerPlayer.class, detectionBox);
        ArrayList<ResourceLocation> soundsToStop = new ArrayList<ResourceLocation>(List.of());
        soundsToStop.add(DNLSounds.MUSIC_CLASH_OF_DUALITY_BASE.get().m_11660_());
        soundsToStop.add(DNLSounds.MUSIC_CLASH_OF_DUALITY_BOROS.get().m_11660_());
        soundsToStop.add(DNLSounds.MUSIC_CLASH_OF_DUALITY_OUROS.get().m_11660_());
        for (ServerPlayer otherPlayer : nearbyPlayers) {
            for (ResourceLocation sound : soundsToStop) {
                Services.NETWORK.sendToPlayer(new S2CStopTickingSoundPacket(this.m_19879_(), sound, 60, true), otherPlayer);
            }
        }
    }

    private void fadeInBorosMusic() {
        float radius = 36.0f;
        AABB detectionBox = this.m_20191_().m_82400_((double)radius);
        List nearbyPlayers = this.m_9236_().m_45976_(ServerPlayer.class, detectionBox);
        for (ServerPlayer otherPlayer : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CFadeInTickingSoundPacket(this.m_19879_(), DNLSounds.MUSIC_CLASH_OF_DUALITY_BOROS.get().m_11660_(), TickingSoundTarget.NEWEST, 1.0f, 20), otherPlayer);
        }
    }

    private void fadeInOurosMusic() {
        float radius = 36.0f;
        AABB detectionBox = this.m_20191_().m_82400_((double)radius);
        List nearbyPlayers = this.m_9236_().m_45976_(ServerPlayer.class, detectionBox);
        for (ServerPlayer otherPlayer : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CFadeInTickingSoundPacket(this.m_19879_(), DNLSounds.MUSIC_CLASH_OF_DUALITY_OUROS.get().m_11660_(), TickingSoundTarget.NEWEST, 1.0f, 20), otherPlayer);
        }
    }

    public Entity getBoros() {
        UUID id = this.getBorosId();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    @javax.annotation.Nullable
    public UUID getBorosId() {
        return ((Optional)this.f_19804_.m_135370_(BOROS_UUID)).orElse(null);
    }

    public void setBorosId(@javax.annotation.Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(BOROS_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getOuros() {
        UUID id = this.getOurosId();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    @javax.annotation.Nullable
    public UUID getOurosId() {
        return ((Optional)this.f_19804_.m_135370_(OUROS_UUID)).orElse(null);
    }

    public void setOurosId(@javax.annotation.Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(OUROS_UUID, Optional.ofNullable(uniqueId));
    }

    public void setActivated(boolean activated) {
        this.f_19804_.m_135381_(ACTIVATED, (Object)activated);
    }

    public boolean isActivated() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVATED);
    }

    public void setOffsets(int x, int y) {
        this.f_19804_.m_135381_(HORIZONTAL_OFFSET, (Object)x);
        this.f_19804_.m_135381_(VERTICAL_OFFSET, (Object)y);
    }

    public int getHorizontalOffset() {
        return (Integer)this.f_19804_.m_135370_(HORIZONTAL_OFFSET);
    }

    public int getVerticalOffset() {
        return (Integer)this.f_19804_.m_135370_(VERTICAL_OFFSET);
    }

    public int getPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    public void setPhase(int phase) {
        this.f_19804_.m_135381_(PHASE, (Object)phase);
    }

    public void setLastDamageSource(DamageSource damageSource) {
        this.lastDamageSource = damageSource;
    }

    public int getArenaSize() {
        return 36;
    }

    public boolean isBorosWaitingForCommand() {
        return this.borosWaitingForCommand && this.boros != null;
    }

    public void setBorosWaitingForCommand(boolean waitingForCommand) {
        this.borosWaitingForCommand = waitingForCommand;
    }

    public boolean isOurosWaitingForCommand() {
        return this.ourosWaitingForCommand && this.ouros != null;
    }

    public void setOurosWaitingForCommand(boolean waitingForCommand) {
        this.ourosWaitingForCommand = waitingForCommand;
    }

    public int getParticipatingPlayerCount() {
        return this.playerUUIDs.size();
    }

    public Set<UUID> getParticipatingPlayerUUIDs() {
        return this.playerUUIDs;
    }

    public void removeMinion(UUID uuid) {
        this.minionUUIDs.remove(uuid);
    }

    public void addMinion(UUID uuid) {
        this.minionUUIDs.add(uuid);
    }

    public Set<UUID> getMinionUUIDs() {
        return this.minionUUIDs;
    }

    public boolean isBorosDefeated() {
        return this.isBorosDefeated > 0;
    }

    public boolean isOurosDefeated() {
        return this.isOurosDefeated > 0;
    }

    public void dyingBoros() {
        this.isBorosDefeated = this.isOurosDefeated > 0 ? 2 : 1;
    }

    public void dyingOuros() {
        this.isOurosDefeated = this.isBorosDefeated > 0 ? 2 : 1;
    }

    public void defeatedBoros() {
        this.isBorosDefeated = this.isBorosDefeated == 2 ? 4 : 3;
    }

    public void defeatedOuros() {
        this.isOurosDefeated = this.isOurosDefeated == 2 ? 4 : 3;
    }

    public void cleanMinionList() {
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        this.minionUUIDs = this.getMinionUUIDs().stream().map(arg_0 -> ((ServerLevel)serverLevel).m_8791_(arg_0)).filter(Objects::nonNull).map(Entity::m_20148_).collect(Collectors.toSet());
    }

    public static enum FairkeeperSerpentCallerAnimationState {
        NONE,
        IDLE,
        ACTIVE;

    }
}

