/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.boss;

import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexDomainProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexOrbProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.Boss;
import dev.hexnowloading.dungeonnowloading.entity.util.SlumberingEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLMobEffects;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.registry.DNLTags;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class FairkeeperBorosPartEntity
extends Monster
implements Boss,
Enemy,
SlumberingEntity,
FairkeeperSerpentEntity {
    private static final EntityDataAccessor<Optional<UUID>> PARENT_UUID = SynchedEntityData.m_135353_(FairkeeperBorosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.m_135353_(FairkeeperBorosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> HEAD_UUID = SynchedEntityData.m_135353_(FairkeeperBorosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> BODY_INDEX = SynchedEntityData.m_135353_(FairkeeperBorosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ARMOR = SynchedEntityData.m_135353_(FairkeeperBorosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TAIL = SynchedEntityData.m_135353_(FairkeeperBorosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HEAD_MOVING = SynchedEntityData.m_135353_(FairkeeperBorosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MODEL_VISIBLE = SynchedEntityData.m_135353_(FairkeeperBorosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ROTATABLE = SynchedEntityData.m_135353_(FairkeeperBorosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float previousTilt = 0.0f;
    private boolean enableRotation = true;

    public FairkeeperBorosPartEntity(EntityType<? extends Monster> entityType, LivingEntity parent, LivingEntity head, int bodyIndex) {
        super(entityType, parent.m_9236_());
        this.setParent((Entity)parent);
        this.setHead((Entity)head);
        this.setBodyIndex(bodyIndex);
        this.setArmor(this.isArmoredSegment());
        this.setModelVisible(false);
        this.m_21530_();
    }

    public FairkeeperBorosPartEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 8.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PARENT_UUID, Optional.empty());
        this.f_19804_.m_135372_(HEAD_UUID, Optional.empty());
        this.f_19804_.m_135372_(CHILD_UUID, Optional.empty());
        this.f_19804_.m_135372_(BODY_INDEX, (Object)0);
        this.f_19804_.m_135372_(TAIL, (Object)false);
        this.f_19804_.m_135372_(ARMOR, (Object)false);
        this.f_19804_.m_135372_(HEAD_MOVING, (Object)false);
        this.f_19804_.m_135372_(MODEL_VISIBLE, (Object)true);
        this.f_19804_.m_135372_(ROTATABLE, (Object)true);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.getParentId() != null) {
            compoundTag.m_128362_("ParentUUID", this.getParentId());
        }
        if (this.getChildId() != null) {
            compoundTag.m_128362_("ChildUUID", this.getChildId());
        }
        if (this.getHeadId() != null) {
            compoundTag.m_128362_("HeadUUID", this.getHeadId());
        }
        compoundTag.m_128379_("TailPart", this.isTail());
        compoundTag.m_128405_("BodyIndex", this.getBodyIndex());
        compoundTag.m_128379_("Armor", this.hasArmor());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128403_("ParentUUID")) {
            this.setParentId(compoundTag.m_128342_("ParentUUID"));
        }
        if (compoundTag.m_128403_("ChildUUID")) {
            this.setChildId(compoundTag.m_128342_("ChildUUID"));
        }
        if (compoundTag.m_128403_("HeadUUID")) {
            this.setHeadId(compoundTag.m_128342_("HeadUUID"));
        }
        this.setTail(compoundTag.m_128471_("TailPart"));
        this.setBodyIndex(compoundTag.m_128451_("BodyIndex"));
        this.setArmor(compoundTag.m_128471_("Armor"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_8119_() {
        Entity parent = this.getParent();
        if (parent != null && !this.m_9236_().f_46443_) {
            this.m_20242_(true);
            Entity entity = this.getHead();
            if (entity instanceof FairkeeperBorosEntity) {
                FairkeeperBorosEntity headEntity = (FairkeeperBorosEntity)entity;
                int historyIndex = (this.getBodyIndex() + 1) * FairkeeperBorosEntity.SEGMENT_DELAY_STEP;
                Queue<Vec3> queue = headEntity.getPositionHistory();
                synchronized (queue) {
                    if (headEntity.getPositionHistory().size() > historyIndex) {
                        this.setModelVisible(true);
                        Vec3 targetPos = headEntity.getSegmentTargetPosition(this.getBodyIndex() + 1);
                        this.m_6034_(this.lerp(this.m_20185_(), targetPos.f_82479_, 0.5), this.lerp(this.m_20186_(), targetPos.f_82480_, 0.5), this.lerp(this.m_20189_(), targetPos.f_82481_, 0.5));
                        if (!this.isRotatable()) {
                            Vec3 awakenEndPos = headEntity.getAwakenEndPos();
                            if (awakenEndPos == null) {
                                this.setRotatable(true);
                            } else {
                                double dy = awakenEndPos.f_82480_ - this.m_20186_();
                                if (dy * dy < 25.0) {
                                    this.setRotatable(true);
                                }
                            }
                        }
                        if (this.isRotatable() && this.isHeadEntityMoving()) {
                            this.alignRotation(this.m_20182_(), targetPos);
                        }
                    }
                }
                this.setHeadEntityMoving(headEntity.m_20184_().m_82556_() > 0.01);
            }
        } else if (!this.m_9236_().f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        super.m_8119_();
    }

    private double lerp(double start, double end, double factor) {
        return start + (end - start) * factor;
    }

    private void alignRotation(Vec3 currentPos, Vec3 targetPos) {
        double deltaX = targetPos.f_82479_ - currentPos.f_82479_;
        double deltaZ = targetPos.f_82481_ - currentPos.f_82481_;
        float yaw = (float)(Math.atan2(deltaZ, deltaX) * 57.29577951308232) - 90.0f;
        this.m_146922_(yaw);
    }

    protected void m_8024_() {
        if (this.isTail()) {
            // empty if block
        }
        if (this.isHeadEntityMoving()) {
            this.performContactDamage();
        }
        super.m_8024_();
    }

    private void vertexTransmissionEffectImmunity() {
        this.m_21195_(DNLMobEffects.VERTEX_TRANSMISSION.get());
    }

    private void setPathOnFire() {
        BlockPos blockPos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)(this.m_20186_() - 1.0)), Mth.m_14107_((double)this.m_20189_()));
        if (this.m_9236_().m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_50016_)) {
            this.m_9236_().m_7731_(blockPos.m_7494_(), Blocks.f_50083_.m_49966_(), 3);
        }
    }

    private void performContactDamage() {
        this.m_9236_().m_6249_((Entity)this, this.m_20191_(), this::canPerformContactDamageTo).forEach(entity -> {
            entity.m_7334_((Entity)this);
            LivingEntity head = (LivingEntity)this.getHead();
            if (head != null) {
                entity.m_6469_(entity.m_9236_().m_269111_().m_269333_(head), (float)(head.m_21133_(Attributes.f_22281_) * 0.5));
            }
        });
    }

    private boolean canPerformContactDamageTo(Entity entity) {
        if (entity instanceof FairkeeperBorosEntity) {
            FairkeeperBorosEntity head = (FairkeeperBorosEntity)entity;
            return !this.getHeadId().equals(head.m_20148_());
        }
        if (entity instanceof FairkeeperBorosPartEntity) {
            FairkeeperBorosPartEntity part = (FairkeeperBorosPartEntity)entity;
            return !this.getHeadId().equals(part.getHeadId());
        }
        return !(entity instanceof VertexOrbProjectileEntity) && !(entity instanceof VertexDomainProjectileEntity);
    }

    public boolean m_6469_(DamageSource damageSource, float damageAmount) {
        LivingEntity livingEntity;
        Entity head2;
        if (damageSource.m_7639_() instanceof FairkeeperSerpentEntity) {
            Entity entity = damageSource.m_7640_();
            if (entity instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)entity;
                arrow.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return false;
        }
        if (!this.hasArmor() || damageSource.m_19390_() || damageSource.m_269533_(DNLTags.FAIRKEEPER_BOROS_BYPASS_ARMOR)) {
            FairkeeperBorosEntity head2;
            float damage = damageAmount;
            if (this.isTail()) {
                damage = damageAmount * 2.0f;
            }
            if ((head2 = (FairkeeperBorosEntity)this.getHead()) != null) {
                head2.setDamageFromOtherSegment(true);
                head2.m_6469_(damageSource, damage);
            }
            return super.m_6469_(damageSource, 0.0f);
        }
        if (damageSource.m_269533_(DNLTags.FAIRKEEPER_BOROS_ARMOR_HURTABLE) || (head2 = damageSource.m_7640_()) instanceof LivingEntity && (livingEntity = (LivingEntity)head2).m_21205_().m_41720_() instanceof PickaxeItem) {
            float nonKillableDamage;
            boolean doesKill = this.m_21223_() - damageAmount <= 0.0f;
            float f = nonKillableDamage = doesKill ? 0.0f : damageAmount;
            if (doesKill) {
                this.setArmor(false);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 1.0f);
                return super.m_6469_(damageSource, 0.0f);
            }
            this.m_9236_().m_5594_(null, this.m_20183_(), DNLSounds.FAIRKEEPER_BOROS_ARMOR_BREAK.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            return super.m_6469_(damageSource, nonKillableDamage);
        }
        if (damageSource.m_276093_(DamageTypes.f_268631_) || damageSource.m_276093_(DamageTypes.f_268468_)) {
            return false;
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), DNLSounds.FAIRKEEPER_BOROS_ARMOR_HIT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        return false;
    }

    protected void m_6153_() {
        ++this.f_20919_;
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        MobEffect effect = mobEffectInstance.m_19544_();
        if (effect == MobEffects.f_19614_ || effect == DNLMobEffects.VERTEX_TRANSMISSION.get()) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public boolean m_5830_() {
        return false;
    }

    public void m_7334_(Entity entity) {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    protected boolean m_20073_() {
        return false;
    }

    protected void m_7840_(double $$0, boolean $$1, BlockState $$2, BlockPos $$3) {
    }

    protected int m_5639_(float $$0, float $$1) {
        return 0;
    }

    public boolean m_142535_(float v, float v1, DamageSource damageSource) {
        return false;
    }

    @Override
    public void resetBoss() {
    }

    @Override
    public boolean resetCondition() {
        return false;
    }

    @Override
    public BlockPos resetRegionCenter() {
        return null;
    }

    @Override
    public boolean isSlumbering() {
        return false;
    }

    @Override
    public boolean isStationary() {
        return false;
    }

    public Entity getHead() {
        UUID id = this.getHeadId();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    public void setHead(Entity entity) {
        this.setHeadId(entity.m_20148_());
    }

    public UUID getHeadId() {
        return ((Optional)this.f_19804_.m_135370_(HEAD_UUID)).orElse(null);
    }

    public void setHeadId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(HEAD_UUID, Optional.ofNullable(uniqueId));
    }

    public int getBodyIndex() {
        return (Integer)this.f_19804_.m_135370_(BODY_INDEX);
    }

    public void setBodyIndex(int index) {
        this.f_19804_.m_135381_(BODY_INDEX, (Object)index);
    }

    @Nullable
    public UUID getParentId() {
        return ((Optional)this.f_19804_.m_135370_(PARENT_UUID)).orElse(null);
    }

    public void setParentId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(PARENT_UUID, Optional.ofNullable(uniqueId));
    }

    public void setParent(Entity entity) {
        this.setParentId(entity.m_20148_());
    }

    public Entity getParent() {
        UUID id = this.getParentId();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.f_19804_.m_135370_(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public void setChild(Entity entity) {
        this.setChildId(entity.m_20148_());
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    public float getPreviousTilt() {
        return this.previousTilt;
    }

    public void setPreviousTilt(float tilt) {
        this.previousTilt = tilt;
    }

    public boolean isHeadEntityMoving() {
        return (Boolean)this.f_19804_.m_135370_(HEAD_MOVING);
    }

    public void setHeadEntityMoving(boolean moving) {
        this.f_19804_.m_135381_(HEAD_MOVING, (Object)moving);
    }

    public boolean isModelVisible() {
        return (Boolean)this.f_19804_.m_135370_(MODEL_VISIBLE);
    }

    public void setModelVisible(boolean moving) {
        this.f_19804_.m_135381_(MODEL_VISIBLE, (Object)moving);
    }

    public boolean isArmoredSegment() {
        return true;
    }

    public boolean hasArmor() {
        return (Boolean)this.f_19804_.m_135370_(ARMOR);
    }

    public void setArmor(boolean armor) {
        this.f_19804_.m_135381_(ARMOR, (Object)armor);
    }

    public boolean isTail() {
        return (Boolean)this.f_19804_.m_135370_(TAIL);
    }

    public void setTail(boolean tail) {
        this.f_19804_.m_135381_(TAIL, (Object)tail);
    }

    public void setRotatable(boolean enableRotation) {
        this.f_19804_.m_135381_(ROTATABLE, (Object)enableRotation);
    }

    public boolean isRotatable() {
        return (Boolean)this.f_19804_.m_135370_(ROTATABLE);
    }
}

