/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import dev.hexnowloading.dungeonnowloading.entity.ai.StoppableGoal;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperOurosEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperOurosPartEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexOrbProjectileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;

public class FairkeeperOurosBodyShootVertexOrbGoal
extends StoppableGoal {
    private final FairkeeperOurosPartEntity part;
    private final FairkeeperOurosPartEntity.FairkeeperOurosPartState state;
    private FairkeeperOurosEntity ouros;
    private int progress;
    private int attackTicks;
    private int cannonChargeUpTicks;
    private boolean beginShooting;
    private static final int ATTACK_INTERVAL = 60;
    private static final int CANNON_CHARGE_UP_DURATION = 20;
    private static final int PHASE_START = 0;
    private static final int PHASE_SETUP = 1;
    private static final int PHASE_AIM = 2;
    private static final int PHASE_PACK = 3;
    private static final int PHASE_FINISH = 4;

    public FairkeeperOurosBodyShootVertexOrbGoal(FairkeeperOurosPartEntity part, FairkeeperOurosPartEntity.FairkeeperOurosPartState state) {
        this.part = part;
        this.state = state;
    }

    public boolean m_8036_() {
        return this.part.isState(this.state) && this.part.getShootingTarget() != null && this.part.getShootingTarget().m_6084_();
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.ouros = (FairkeeperOurosEntity)this.part.getHead();
        this.progress = 0;
        this.attackTicks = FairkeeperOurosBodyShootVertexOrbGoal.m_186073_((int)60);
        this.cannonChargeUpTicks = FairkeeperOurosBodyShootVertexOrbGoal.m_186073_((int)20);
        this.beginShooting = false;
    }

    @Override
    public boolean m_8045_() {
        boolean withinZ;
        LivingEntity livingEntity = (LivingEntity)this.part.getShootingTarget();
        if (livingEntity == null) {
            return false;
        }
        if (!this.ouros.m_6779_(livingEntity)) {
            return false;
        }
        Team teamMob = this.ouros.m_5647_();
        Team teamOther = livingEntity.m_5647_();
        if (teamMob != null && teamOther == teamMob) {
            return false;
        }
        int arenaSize = this.ouros.getArenaSize();
        BlockPos arenaCenter = this.ouros.getArenaCenter();
        boolean withinX = Math.abs(livingEntity.m_20185_() - (double)arenaCenter.m_123341_() + 0.5) < (double)((float)arenaSize + 0.5f);
        boolean withinY = Math.abs(livingEntity.m_20186_() - (double)arenaCenter.m_123342_() + 0.5) < (double)((float)arenaSize + 0.5f);
        boolean bl = withinZ = Math.abs(livingEntity.m_20189_() - (double)arenaCenter.m_123343_() + 0.5) < (double)((float)arenaSize + 0.5f);
        if (!(withinX && withinY && withinZ)) {
            return false;
        }
        return super.m_8045_();
    }

    public void m_8041_() {
        this.part.setState(FairkeeperOurosPartEntity.FairkeeperOurosPartState.IDLE);
        this.part.setInaccuracy(0.0f);
        this.part.setCancelShooting(false);
        this.part.setShootingTarget(null);
    }

    public void m_8037_() {
        if (this.progress == 0) {
            this.progress = 1;
            this.part.playCannonSetupAnimation(() -> {
                this.progress = 2;
            });
        } else if (this.progress == 2) {
            this.part.aimCannonAtPlayer(this.part.getShootingTarget());
            if (this.part.isCancelShooting()) {
                this.ouros.m_9236_().m_5594_(null, this.part.m_20183_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.ouros.m_9236_().f_46441_.m_188501_() - this.ouros.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f);
                ((ServerLevel)this.ouros.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.part.m_20185_(), this.part.m_20186_(), this.part.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
                this.part.playCannonCancelAnimation(this::stopGoal);
                this.progress = 4;
            } else if (this.attackTicks-- <= 0) {
                this.shootRandomPlayer();
            }
        } else if (this.progress == 3) {
            this.part.playCannonPackAnimation(this::stopGoal);
            ++this.progress;
        }
    }

    private void shootRandomPlayer() {
        Entity entity = this.part.getShootingTarget();
        if (entity == null) {
            ++this.progress;
            return;
        }
        Vec3 start = new Vec3(this.part.m_20185_(), this.part.m_20186_() + (double)(entity.m_20206_() * 0.5f), this.part.m_20189_());
        Vec3 end = entity.m_20182_().m_82520_(0.0, (double)entity.m_20206_() * 0.5, 0.0);
        BlockHitResult hitResult = this.ouros.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.part));
        if (!this.beginShooting && hitResult.m_6662_() == HitResult.Type.MISS) {
            this.beginShooting = true;
        }
        if (this.beginShooting && this.cannonChargeUpTicks-- <= 0) {
            VertexOrbProjectileEntity projectile = new VertexOrbProjectileEntity(this.ouros.m_9236_(), (LivingEntity)this.ouros, 2);
            projectile.shootTowardsTarget(start.f_82479_, start.f_82480_, start.f_82481_, (LivingEntity)entity, 1.0f, this.part.getInaccuracy());
            this.ouros.m_9236_().m_7967_((Entity)projectile);
            this.ouros.getCaller().addMinion(projectile.m_20148_());
            this.part.playVertexOrbShootSound(this.part.m_20185_(), this.part.m_20186_(), this.part.m_20189_());
            ++this.progress;
        }
    }
}

