/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import dev.hexnowloading.dungeonnowloading.entity.boss.ChaosSpawnerEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.ChaosSpawnerProjectileEntity;
import dev.hexnowloading.dungeonnowloading.util.WeightedRandomBag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class ChaosSpawnerShootGhostBulletGoal
extends Goal {
    private final ChaosSpawnerEntity chaosSpawnerEntity;
    private final int DURATION = 126;
    private String type;

    public ChaosSpawnerShootGhostBulletGoal(ChaosSpawnerEntity chaosSpawnerEntity) {
        this.chaosSpawnerEntity = chaosSpawnerEntity;
    }

    public boolean m_8036_() {
        return (this.chaosSpawnerEntity.isAttacking(ChaosSpawnerEntity.State.SHOOT_GHOST_BULLET_SINGLE) || this.chaosSpawnerEntity.isAttacking(ChaosSpawnerEntity.State.SHOOT_GHOST_BULLET_BURST)) && this.chaosSpawnerEntity.m_5448_() != null;
    }

    public void m_8056_() {
        super.m_8056_();
        this.chaosSpawnerEntity.setAttackTick(126);
        WeightedRandomBag<String> bulletPatterns = new WeightedRandomBag<String>();
        if (this.chaosSpawnerEntity.getState() == ChaosSpawnerEntity.State.SHOOT_GHOST_BULLET_SINGLE) {
            this.chaosSpawnerEntity.triggerRangeAttackAnimation();
            if (this.chaosSpawnerEntity.getPhase() == 1) {
                bulletPatterns.addEntry("Single", 1.0);
                bulletPatterns.addEntry("Arc", 1.0);
            } else if (this.chaosSpawnerEntity.getPhase() == 2) {
                bulletPatterns.addEntry("Rapid", 1.0);
                bulletPatterns.addEntry("Strong Arc", 1.0);
            }
        } else {
            this.chaosSpawnerEntity.triggerRangeBurstAttackAnimation();
            if (this.chaosSpawnerEntity.getPhase() == 1) {
                bulletPatterns.addEntry("Burst", 1.0);
            } else if (this.chaosSpawnerEntity.getPhase() == 2) {
                bulletPatterns.addEntry("Strong Burst", 1.0);
            }
        }
        this.type = (String)bulletPatterns.getRandom();
    }

    public void m_8037_() {
        switch (this.type) {
            case "Single": {
                for (int i = 0; i < 5; ++i) {
                    if (this.chaosSpawnerEntity.getAttackTick() != 100 - i * 20) continue;
                    this.performSingleShot();
                }
                break;
            }
            case "Rapid": {
                for (int j = 0; j < 3; ++j) {
                    for (int i = 0; i < 5; ++i) {
                        if (this.chaosSpawnerEntity.getAttackTick() != 100 - 30 * j - i * 4) continue;
                        this.performSingleShot();
                    }
                }
                break;
            }
            case "Arc": {
                for (int i = 0; i < 3; ++i) {
                    if (this.chaosSpawnerEntity.getAttackTick() != 100 - i * 30) continue;
                    this.performArcShot();
                }
                break;
            }
            case "Strong Arc": {
                for (int i = 0; i < 3; ++i) {
                    if (this.chaosSpawnerEntity.getAttackTick() != 100 - i * 30) continue;
                    this.performStrongArcShot();
                }
                break;
            }
            case "Burst": {
                for (int i = 0; i < 3; ++i) {
                    if (this.chaosSpawnerEntity.getAttackTick() != 100 - i * 30) continue;
                    this.performBurstShot((float)(i % 2) * 22.5f);
                }
                break;
            }
            case "Strong Burst": {
                for (int i = 0; i < 3; ++i) {
                    if (this.chaosSpawnerEntity.getAttackTick() != 100 - i * 30) continue;
                    this.performStrongBurstShot((float)(i % 2) * 11.5f);
                }
                break;
            }
        }
        if (this.chaosSpawnerEntity.getAttackTick() == 0) {
            this.chaosSpawnerEntity.stopAttacking(60);
        }
    }

    private void performSingleShot() {
        LivingEntity targetEntity = this.chaosSpawnerEntity.m_5448_();
        if (targetEntity != null && (double)targetEntity.m_20270_((Entity)this.chaosSpawnerEntity) < this.chaosSpawnerEntity.getFollowDistance()) {
            this.chaosSpawnerEntity.m_9236_().m_6263_(null, this.chaosSpawnerEntity.m_20185_(), this.chaosSpawnerEntity.m_20186_(), this.chaosSpawnerEntity.m_20189_(), SoundEvents.f_12558_, this.chaosSpawnerEntity.m_5720_(), 3.0f, 1.0f + (this.chaosSpawnerEntity.m_217043_().m_188501_() - this.chaosSpawnerEntity.m_217043_().m_188501_()) * 0.2f);
            this.vecFromCenterToFrontOfFace(0.0f);
        }
    }

    private void performArcShot() {
        LivingEntity targetEntity = this.chaosSpawnerEntity.m_5448_();
        if (targetEntity != null && (double)targetEntity.m_20270_((Entity)this.chaosSpawnerEntity) < this.chaosSpawnerEntity.getFollowDistance()) {
            this.chaosSpawnerEntity.m_9236_().m_6263_(null, this.chaosSpawnerEntity.m_20185_(), this.chaosSpawnerEntity.m_20186_(), this.chaosSpawnerEntity.m_20189_(), SoundEvents.f_12558_, this.chaosSpawnerEntity.m_5720_(), 3.0f, 1.0f + (this.chaosSpawnerEntity.m_217043_().m_188501_() - this.chaosSpawnerEntity.m_217043_().m_188501_()) * 0.2f);
            this.vecFromCenterToFrontOfFace(0.0f);
            this.vecFromCenterToFrontOfFace(-10.0f);
            this.vecFromCenterToFrontOfFace(10.0f);
        }
    }

    private void performStrongArcShot() {
        LivingEntity targetEntity = this.chaosSpawnerEntity.m_5448_();
        if (targetEntity != null && (double)targetEntity.m_20270_((Entity)this.chaosSpawnerEntity) < this.chaosSpawnerEntity.getFollowDistance()) {
            this.chaosSpawnerEntity.m_9236_().m_6263_(null, this.chaosSpawnerEntity.m_20185_(), this.chaosSpawnerEntity.m_20186_(), this.chaosSpawnerEntity.m_20189_(), SoundEvents.f_12558_, this.chaosSpawnerEntity.m_5720_(), 3.0f, 1.0f + (this.chaosSpawnerEntity.m_217043_().m_188501_() - this.chaosSpawnerEntity.m_217043_().m_188501_()) * 0.2f);
            this.vecFromCenterToFrontOfFace(0.0f);
            this.vecFromCenterToFrontOfFace(-10.0f);
            this.vecFromCenterToFrontOfFace(10.0f);
            this.vecFromCenterToFrontOfFace(-20.0f);
            this.vecFromCenterToFrontOfFace(20.0f);
        }
    }

    private void performBurstShot(float angle) {
        float offset = (float)Math.toRadians(angle);
        Vec3 vec3 = this.chaosSpawnerEntity.m_20252_(0.5f);
        vec3 = vec3.m_82524_(offset);
        this.chaosSpawnerEntity.m_9236_().m_6263_(null, this.chaosSpawnerEntity.m_20185_(), this.chaosSpawnerEntity.m_20186_(), this.chaosSpawnerEntity.m_20189_(), SoundEvents.f_12558_, this.chaosSpawnerEntity.m_5720_(), 3.0f, 1.0f + (this.chaosSpawnerEntity.m_217043_().m_188501_() - this.chaosSpawnerEntity.m_217043_().m_188501_()) * 0.2f);
        for (int i = 0; i < 8; ++i) {
            vec3 = vec3.m_82524_((float)Math.toRadians(45.0) * (float)i);
            ChaosSpawnerProjectileEntity chaosSpawnerProjectileEntity = new ChaosSpawnerProjectileEntity((LivingEntity)this.chaosSpawnerEntity, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            chaosSpawnerProjectileEntity.m_6034_(chaosSpawnerProjectileEntity.m_20185_() + vec3.f_82479_, chaosSpawnerProjectileEntity.m_20227_(0.5) + vec3.f_82480_, chaosSpawnerProjectileEntity.m_20189_() + vec3.f_82481_);
            this.chaosSpawnerEntity.m_9236_().m_7967_((Entity)chaosSpawnerProjectileEntity);
        }
    }

    private void performStrongBurstShot(float angle) {
        float offset = (float)Math.toRadians(angle);
        Vec3 vec3 = this.chaosSpawnerEntity.m_20252_(0.5f);
        vec3 = vec3.m_82524_(offset);
        this.chaosSpawnerEntity.m_9236_().m_6263_(null, this.chaosSpawnerEntity.m_20185_(), this.chaosSpawnerEntity.m_20186_(), this.chaosSpawnerEntity.m_20189_(), SoundEvents.f_12558_, this.chaosSpawnerEntity.m_5720_(), 3.0f, 1.0f + (this.chaosSpawnerEntity.m_217043_().m_188501_() - this.chaosSpawnerEntity.m_217043_().m_188501_()) * 0.2f);
        for (int i = 0; i < 16; ++i) {
            vec3 = vec3.m_82524_((float)Math.toRadians(22.5) * (float)i);
            ChaosSpawnerProjectileEntity chaosSpawnerProjectileEntity = new ChaosSpawnerProjectileEntity((LivingEntity)this.chaosSpawnerEntity, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            chaosSpawnerProjectileEntity.m_6034_(chaosSpawnerProjectileEntity.m_20185_() + vec3.f_82479_, chaosSpawnerProjectileEntity.m_20227_(0.5) + vec3.f_82480_, chaosSpawnerProjectileEntity.m_20189_() + vec3.f_82481_);
            this.chaosSpawnerEntity.m_9236_().m_7967_((Entity)chaosSpawnerProjectileEntity);
        }
    }

    private void vecFromCenterToFrontOfFace(float angle) {
        double viewDistance = 2.0;
        Vec3 viewVector = this.chaosSpawnerEntity.m_20252_(0.5f);
        if (angle != 0.0f) {
            float offset = (float)Math.toRadians(angle);
            viewVector = viewVector.m_82524_(offset);
        }
        double d0 = viewVector.f_82479_ * viewDistance;
        double d1 = viewVector.f_82480_ * viewDistance;
        double d2 = viewVector.f_82481_ * viewDistance;
        ChaosSpawnerProjectileEntity chaosSpawnerProjectileEntity = new ChaosSpawnerProjectileEntity((LivingEntity)this.chaosSpawnerEntity, d0, d1, d2);
        chaosSpawnerProjectileEntity.m_6034_(chaosSpawnerProjectileEntity.m_20185_() + d0, chaosSpawnerProjectileEntity.m_20227_(0.5) + d1, chaosSpawnerProjectileEntity.m_20189_() + d2);
        this.chaosSpawnerEntity.m_9236_().m_7967_((Entity)chaosSpawnerProjectileEntity);
    }
}

