/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block.entity;

import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentEntity;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlockEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.util.DNLMath;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VertexPillarBlockEntity
extends BlockEntity {
    private final List<BlockPos> linkedPositions = new ArrayList<BlockPos>();
    private int age;
    private static final float DAMAGE = 6.0f;
    private static final double BEAM_HITBOX_RADIUS = 0.5;
    private static final int SLOWNESS_DURATION = 20;
    private static final int SLOWNESS_AMPLIFIER = 4;
    private static final double BEAM_PARTICLE_SPACING = 0.4;
    private static final float BEAM_PARTICLE_SCALE = 0.05f;
    private static final float MAX_RANDOM_PARTICLE_SCALE_MULTIPLIER = 3.0f;
    private static final double BEAM_INITIAL_PARTICLE_SPACING = 0.8;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MIN = 0.2f;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MAX = 0.4f;

    public VertexPillarBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(DNLBlockEntityTypes.VERTEX_PILLAR.get(), blockPos, blockState);
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        ListTag posList = new ListTag();
        for (BlockPos pos : this.linkedPositions) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("X", pos.m_123341_());
            posTag.m_128405_("Y", pos.m_123342_());
            posTag.m_128405_("Z", pos.m_123343_());
            posList.add((Object)posTag);
        }
        compoundTag.m_128365_("LinkedPositions", (Tag)posList);
        compoundTag.m_128405_("Age", this.age);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.linkedPositions.clear();
        ListTag posList = compoundTag.m_128437_("LinkedPositions", 10);
        for (Tag tag : posList) {
            CompoundTag posTag = (CompoundTag)tag;
            BlockPos loadedPos = new BlockPos(posTag.m_128451_("X"), posTag.m_128451_("Y"), posTag.m_128451_("Z"));
            this.linkedPositions.add(loadedPos);
        }
        this.age = compoundTag.m_128451_("Age");
    }

    public List<BlockPos> getLinkedPositions() {
        return this.linkedPositions;
    }

    public boolean addLink(BlockPos pos) {
        if (!this.linkedPositions.contains(pos)) {
            this.linkedPositions.add(pos);
            this.m_6596_();
            return true;
        }
        return false;
    }

    public void removeLink(BlockPos pos) {
        this.linkedPositions.remove(pos);
        this.m_6596_();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, VertexPillarBlockEntity blockEntity) {
        if (!level.f_46443_) {
            for (BlockPos linkedPos : blockEntity.getLinkedPositions()) {
                BlockEntity targetBE = level.m_7702_(linkedPos);
                if (!(targetBE instanceof VertexPillarBlockEntity)) continue;
                VertexPillarBlockEntity pillarBlockEntity = (VertexPillarBlockEntity)targetBE;
                if (pillarBlockEntity.age <= blockEntity.age) continue;
                if (blockEntity.age > 0) {
                    VertexPillarBlockEntity.spawnRedstoneLaser((ServerLevel)level, pos, linkedPos);
                    continue;
                }
                VertexPillarBlockEntity.spawnInitialParticleBeamVFX(level, pos.m_252807_().m_82520_(0.0, 1.0, 0.0), linkedPos.m_252807_().m_82520_(0.0, 1.0, 0.0));
                level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), DNLSounds.VERTEX_NODE_CONNECT.get(), SoundSource.NEUTRAL, 0.5f, 1.2f / (DNLMath.randomRange(0.0f, 1.0f) * 0.2f + 0.9f));
            }
            ++blockEntity.age;
        }
    }

    private static void spawnRedstoneLaser(ServerLevel level, BlockPos start, BlockPos end) {
        Vec3 startVec = Vec3.m_82512_((Vec3i)start).m_82520_(0.0, 1.0, 0.0);
        Vec3 endVec = Vec3.m_82512_((Vec3i)end).m_82520_(0.0, 1.0, 0.0);
        List<LivingEntity> entities = VertexPillarBlockEntity.getLivingEntitiesTouchingBeam((Level)level, startVec, endVec, 0.5);
        for (LivingEntity entity : entities) {
            if (entity instanceof FairkeeperSerpentEntity) continue;
            entity.m_6469_(entity.m_9236_().m_269111_().m_269425_(), 6.0f);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 4));
        }
        VertexPillarBlockEntity.spawnParticleBeamVFX((Level)level, startVec, endVec);
    }

    private static List<LivingEntity> getLivingEntitiesTouchingBeam(Level level, Vec3 beamStart, Vec3 beamEnd, double radius) {
        ArrayList<LivingEntity> entitiesInCapsule = new ArrayList<LivingEntity>();
        List allEntities = level.m_45976_(LivingEntity.class, new AABB(Math.min(beamStart.f_82479_, beamEnd.f_82479_) - radius, Math.min(beamStart.f_82480_, beamEnd.f_82480_) - radius, Math.min(beamStart.f_82481_, beamEnd.f_82481_) - radius, Math.max(beamStart.f_82479_, beamEnd.f_82479_) + radius, Math.max(beamStart.f_82480_, beamEnd.f_82480_) + radius, Math.max(beamStart.f_82481_, beamEnd.f_82481_) + radius));
        for (LivingEntity entity : allEntities) {
            if (!VertexPillarBlockEntity.isBoundingBoxIntersectingWithCapsule(entity.m_20191_(), beamStart, beamEnd, radius)) continue;
            entitiesInCapsule.add(entity);
        }
        return entitiesInCapsule;
    }

    private static Vec3 getClosestPointOnBeam(AABB boundingBox, Vec3 start, Vec3 end) {
        Vec3 beamDirection = end.m_82546_(start).m_82541_();
        Vec3 boxCenter = boundingBox.m_82399_();
        double t = beamDirection.m_82526_(boxCenter.m_82546_(start));
        t = Math.max(0.0, Math.min(t, start.m_82554_(end)));
        return start.m_82549_(beamDirection.m_82490_(t));
    }

    private static boolean isBoundingBoxIntersectingWithCapsule(AABB boundingBox, Vec3 beamStart, Vec3 beamEnd, double radius) {
        Vec3 closestPointOnBeam = VertexPillarBlockEntity.getClosestPointOnBeam(boundingBox, beamStart, beamEnd);
        return closestPointOnBeam.m_82557_(boundingBox.m_82399_()) <= radius * radius || boundingBox.m_82390_(closestPointOnBeam);
    }

    private static void spawnParticleBeamVFX(Level level, Vec3 startPos, Vec3 endPos) {
        Vec3 line = endPos.m_82546_(startPos);
        double distance = line.m_82553_();
        int numberOfParticles = (int)Math.ceil(distance / 0.4);
        for (int i = 0; i <= numberOfParticles; ++i) {
            int randomNumber = ThreadLocalRandom.current().nextInt(3);
            if (randomNumber != 0) continue;
            double t = (double)i / (double)numberOfParticles;
            Vec3 particlePos = startPos.m_82549_(line.m_82490_(t));
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel _level = (ServerLevel)level;
            float scaleMultiplier = (float)Math.random() * 3.0f;
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.VERTEX_SPARK_PARTICLE.get(), 0.05f * scaleMultiplier);
            _level.m_8767_((ParticleOptions)particleData, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void spawnInitialParticleBeamVFX(Level level, Vec3 startPos, Vec3 endPos) {
        Vec3 line = endPos.m_82546_(startPos);
        double distance = line.m_82553_();
        int numberOfParticles = (int)Math.ceil(distance / 0.8);
        for (int i = 0; i <= numberOfParticles; ++i) {
            double t = (double)i / (double)numberOfParticles;
            Vec3 particlePos = startPos.m_82549_(line.m_82490_(t));
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel _level = (ServerLevel)level;
            float particleScale = 0.2f + (float)Math.random() * 0.2f;
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), particleScale);
            _level.m_8767_((ParticleOptions)particleData, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

