/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLTags;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class StoneNotchBlock
extends Block {
    private final StoneNotchMaterialSignalStrength notchMaterial;

    public StoneNotchBlock(BlockBehaviour.Properties properties, StoneNotchMaterialSignalStrength notchMaterial) {
        super(properties);
        this.notchMaterial = notchMaterial;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (itemInHand.m_204117_(DNLTags.STONE_NOTCH_MATERIAL)) {
            if (blockState.m_60713_(DNLBlocks.STONE_NOTCH.get())) {
                StoneNotchBlock.playSound(level, blockPos, SoundEvents.f_12013_);
                this.setNotchBlock(itemInHand.m_41720_(), level, blockPos);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)itemInHand.m_41720_()));
                if (!player.m_150110_().f_35937_) {
                    itemInHand.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return this.popOutMaterial(level, blockState, blockPos) ? InteractionResult.m_19078_((boolean)level.f_46443_) : InteractionResult.PASS;
        }
        if (itemInHand.m_41619_()) {
            if (blockState.m_60713_(DNLBlocks.STONE_NOTCH.get())) {
                return InteractionResult.PASS;
            }
            return this.popOutMaterial(level, blockState, blockPos) ? InteractionResult.m_19078_((boolean)level.f_46443_) : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private void setNotchBlock(Item item, Level level, BlockPos blockPos) {
        if (item.equals(Items.f_42413_)) {
            level.m_7731_(blockPos, DNLBlocks.COAL_STONE_NOTCH.get().m_49966_(), 3);
        } else if (item.equals(Items.f_151052_)) {
            level.m_7731_(blockPos, DNLBlocks.COPPER_STONE_NOTCH.get().m_49966_(), 3);
        } else if (item.equals(Items.f_42416_)) {
            level.m_7731_(blockPos, DNLBlocks.IRON_STONE_NOTCH.get().m_49966_(), 3);
        } else if (item.equals(Items.f_42417_)) {
            level.m_7731_(blockPos, DNLBlocks.GOLD_STONE_NOTCH.get().m_49966_(), 3);
        } else if (item.equals(Items.f_42451_)) {
            level.m_7731_(blockPos, DNLBlocks.REDSTONE_STONE_NOTCH.get().m_49966_(), 3);
        } else if (item.equals(Items.f_151049_)) {
            level.m_7731_(blockPos, DNLBlocks.AMETHYST_STONE_NOTCH.get().m_49966_(), 3);
        } else if (item.equals(Items.f_42534_)) {
            level.m_7731_(blockPos, DNLBlocks.LAPIS_STONE_NOTCH.get().m_49966_(), 3);
        } else if (item.equals(Items.f_42616_)) {
            level.m_7731_(blockPos, DNLBlocks.EMERALD_STONE_NOTCH.get().m_49966_(), 3);
        } else if (item.equals(Items.f_42692_)) {
            level.m_7731_(blockPos, DNLBlocks.QUARTZ_STONE_NOTCH.get().m_49966_(), 3);
        } else if (item.equals(Items.f_42525_)) {
            level.m_7731_(blockPos, DNLBlocks.GLOWSTONE_STONE_NOTCH.get().m_49966_(), 3);
        } else if (item.equals(Items.f_42695_)) {
            level.m_7731_(blockPos, DNLBlocks.PRISMARINE_STONE_NOTCH.get().m_49966_(), 3);
        } else if (item.equals(Items.f_42731_)) {
            level.m_7731_(blockPos, DNLBlocks.CHORUS_STONE_NOTCH.get().m_49966_(), 3);
        } else if (item.equals(Items.f_220224_)) {
            level.m_7731_(blockPos, DNLBlocks.ECHO_STONE_NOTCH.get().m_49966_(), 3);
        } else if (item.equals(Items.f_42415_)) {
            level.m_7731_(blockPos, DNLBlocks.DIAMOND_STONE_NOTCH.get().m_49966_(), 3);
        } else if (item.equals(Items.f_42418_)) {
            level.m_7731_(blockPos, DNLBlocks.NETHERITE_STONE_NOTCH.get().m_49966_(), 3);
        }
    }

    private boolean popOutMaterial(Level level, BlockState blockState, BlockPos blockPos) {
        ArrayList<OffsetPos> offsetPos = new ArrayList<OffsetPos>();
        if (!level.m_8055_(blockPos.m_7494_()).m_60783_((BlockGetter)level, blockPos.m_7494_(), Direction.UP)) {
            offsetPos.add(OffsetPos.UP);
        }
        if (!level.m_8055_(blockPos.m_7495_()).m_60783_((BlockGetter)level, blockPos.m_7495_(), Direction.DOWN)) {
            offsetPos.add(OffsetPos.DOWN);
        }
        if (!level.m_8055_(blockPos.m_122012_()).m_60783_((BlockGetter)level, blockPos.m_122012_(), Direction.NORTH)) {
            offsetPos.add(OffsetPos.NORTH);
        }
        if (!level.m_8055_(blockPos.m_122029_()).m_60783_((BlockGetter)level, blockPos.m_122029_(), Direction.EAST)) {
            offsetPos.add(OffsetPos.EAST);
        }
        if (!level.m_8055_(blockPos.m_122019_()).m_60783_((BlockGetter)level, blockPos.m_122019_(), Direction.SOUTH)) {
            offsetPos.add(OffsetPos.SOUTH);
        }
        if (!level.m_8055_(blockPos.m_122024_()).m_60783_((BlockGetter)level, blockPos.m_122024_(), Direction.WEST)) {
            offsetPos.add(OffsetPos.WEST);
        }
        if (offsetPos.isEmpty()) {
            return false;
        }
        int randomPos = level.f_46441_.m_188503_(offsetPos.size());
        OffsetPos chosenPos = (OffsetPos)((Object)offsetPos.get(randomPos));
        Vec3 popPos = Vec3.m_272021_((Vec3i)blockPos, (double)chosenPos.x, (double)chosenPos.y, (double)chosenPos.z);
        if (this.notchMaterial.item != null) {
            StoneNotchBlock.playSound(level, blockPos, SoundEvents.f_12016_);
            ItemStack itemStack = new ItemStack((ItemLike)this.notchMaterial.item, 1);
            ItemEntity itemEntity = new ItemEntity(level, popPos.m_7096_(), popPos.m_7098_(), popPos.m_7094_(), itemStack, chosenPos.dx, chosenPos.dy, chosenPos.dz);
            itemEntity.m_32060_();
            level.m_7967_((Entity)itemEntity);
        }
        level.m_7731_(blockPos, DNLBlocks.STONE_NOTCH.get().m_49966_(), 3);
        return true;
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos1, boolean b) {
        if (!level.f_46443_ && !blockState.m_60713_(DNLBlocks.STONE_NOTCH.get()) && level.m_276867_(blockPos)) {
            this.popOutMaterial(level, blockState, blockPos);
        }
    }

    public boolean m_7899_(BlockState $$0) {
        return true;
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos blockPos) {
        return this.notchMaterial.signalStrength;
    }

    private static void playSound(Level level, BlockPos pos, SoundEvent soundEvent) {
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123342_() + 0.5;
        double d2 = (double)pos.m_123343_() + 0.5;
        level.m_6263_((Player)null, d0, d1, d2, soundEvent, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public static enum StoneNotchMaterialSignalStrength {
        NONE(null, 0),
        COAL(Items.f_42413_, 1),
        COPPER(Items.f_151052_, 2),
        IRON(Items.f_42416_, 3),
        GOLD(Items.f_42417_, 4),
        REDSTONE(Items.f_42451_, 5),
        AMETHYST(Items.f_151049_, 6),
        LAPIS(Items.f_42534_, 7),
        EMERALD(Items.f_42616_, 8),
        QUARTZ(Items.f_42692_, 9),
        GLOWSTONE(Items.f_42525_, 10),
        PRISMARINE(Items.f_42695_, 11),
        CHORUS(Items.f_42731_, 12),
        ECHO(Items.f_220224_, 13),
        DIAMOND(Items.f_42415_, 14),
        NETHERITE(Items.f_42418_, 15);

        final Item item;
        final int signalStrength;

        private StoneNotchMaterialSignalStrength(Item item, int signalStrength) {
            this.item = item;
            this.signalStrength = signalStrength;
        }
    }

    private static enum OffsetPos {
        UP(0.5, 1.01, 0.5, 0.0, 0.5, 0.0),
        DOWN(0.5, -0.4, 0.5, 0.0, -0.5, 0.0),
        NORTH(0.5, 0.5, -0.1, 0.0, 0.0, -0.5),
        EAST(1.1, 0.5, 0.5, 0.5, 0.0, 0.0),
        SOUTH(0.5, 0.5, 1.1, 0.0, 0.0, 0.5),
        WEST(-0.1, 0.5, 0.5, -0.5, 0.0, 0.0);

        final double x;
        final double y;
        final double z;
        final double dx;
        final double dy;
        final double dz;

        private OffsetPos(double x, double y, double z, double dx, double dy, double dz) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
        }
    }
}

