/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RotatorPressurePlate
extends PressurePlateBlock {
    private static final VoxelShape PRESSED_AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)0.5, (double)13.0);
    private static final VoxelShape UNPRESSED_AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final AABB ROTATOR_TOUCH_AABB = new AABB(0.1875, 0.0, 0.1875, 0.8125, 0.25, 0.8125);
    private boolean hasArrow;
    private final BlockSetType type;

    public RotatorPressurePlate(BlockBehaviour.Properties properties, BlockSetType blockSetType) {
        super(PressurePlateBlock.Sensitivity.EVERYTHING, properties, blockSetType);
        this.type = blockSetType;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.m_6016_(blockState) > 0 ? PRESSED_AABB : UNPRESSED_AABB;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (((Boolean)blockState.m_61143_((Property)f_55249_)).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        if (!level.f_46443_) {
            this.rotateBlock((ServerLevel)level, blockPos);
        }
        BlockState poweredState = this.m_7422_(blockState, 15);
        level.m_7731_(blockPos, poweredState, 2);
        this.m_49291_(level, blockPos);
        level.m_6550_(blockPos, blockState, poweredState);
        level.m_186460_(new BlockPos((Vec3i)blockPos), (Block)this, this.m_7342_());
        level.m_247517_(null, blockPos, this.type.f_271481_(), SoundSource.BLOCKS);
        level.m_142346_((Entity)player, GameEvent.f_223702_, blockPos);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        List arrows = serverLevel.m_45976_(Arrow.class, ROTATOR_TOUCH_AABB.m_82338_(blockPos)).stream().toList();
        if (!arrows.isEmpty()) {
            arrows.forEach(arrow -> this.bounceArrows(serverLevel, (Arrow)arrow));
        }
        super.m_213897_(blockState, serverLevel, blockPos, randomSource);
    }

    private void bounceArrows(ServerLevel level, Arrow arrow) {
        Vec3 moveVec = new Vec3(0.0, 0.3, 0.0);
        arrow.m_6478_(MoverType.SELF, moveVec);
        Vec3 viewVector = arrow.m_20184_();
        viewVector = viewVector.m_82541_().m_82490_(5.0);
        double d0 = viewVector.f_82479_;
        double d1 = 3.5;
        double d2 = viewVector.f_82481_;
        Vec3 arrowVec = new Vec3(d0, d1, d2);
        arrow.m_20256_(arrowVec);
        double v = arrowVec.m_165924_();
        arrow.m_146922_((float)(Mth.m_14136_((double)arrowVec.f_82479_, (double)arrowVec.f_82481_) * 57.2957763671875));
        arrow.m_146926_((float)(Mth.m_14136_((double)arrowVec.f_82480_, (double)v) * 57.2957763671875));
        arrow.f_19859_ = arrow.m_146908_();
        arrow.f_19860_ = arrow.m_146909_();
        arrow.f_19812_ = true;
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (!level.f_46443_) {
            boolean signalStrength;
            boolean signalStrengthState = this.m_6016_(blockState) > 0;
            boolean bl = signalStrength = this.m_6693_(level, blockPos) > 0;
            if (signalStrength && !signalStrengthState) {
                this.rotateBlock((ServerLevel)level, blockPos);
            }
        }
        super.m_7892_(blockState, level, blockPos, entity);
    }

    private void rotateBlock(ServerLevel serverLevel, BlockPos blockPos) {
        BlockPos rotateTargetPos = blockPos.m_7495_();
        BlockState targetBlockState = serverLevel.m_8055_(blockPos.m_7495_());
        if (serverLevel.m_8055_(rotateTargetPos).m_61138_((Property)DirectionalBlock.f_52588_)) {
            Direction direction = (Direction)serverLevel.m_8055_(rotateTargetPos).m_61143_((Property)DirectionalBlock.f_52588_);
            if (direction == Direction.UP || direction == Direction.DOWN) {
                return;
            }
            serverLevel.m_7731_(rotateTargetPos, (BlockState)targetBlockState.m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)direction.m_122427_()), 2);
        } else if (serverLevel.m_8055_(rotateTargetPos).m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
            Direction direction = (Direction)serverLevel.m_8055_(rotateTargetPos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            serverLevel.m_7731_(rotateTargetPos, (BlockState)targetBlockState.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction.m_122427_()), 2);
        }
    }

    protected int m_6693_(Level level, BlockPos blockPos) {
        return RotatorPressurePlate.m_289607_((Level)level, (AABB)ROTATOR_TOUCH_AABB.m_82338_(blockPos), Entity.class) > 0 ? 15 : 0;
    }

    protected int m_7342_() {
        return 10;
    }
}

