/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import com.mojang.authlib.GameProfile;
import dev.hexnowloading.dungeonnowloading.block.entity.PlayerStatueBlockEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlockEntityTypes;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PlayerStatueBlock
extends BaseEntityBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final IntegerProperty ROTATION = BlockStateProperties.f_61390_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final int MAX_POSES = 4;
    public static final boolean ENABLE_SIGN_EDIT = false;

    public PlayerStatueBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluid = ctx.m_43725_().m_6425_(ctx.m_8083_());
        int rot = Mth.m_14143_((float)(ctx.m_7074_() * 16.0f / 360.0f + 0.5f)) & 0xF;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rot))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rot.m_55949_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), 16)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(mirror.m_54843_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), 16)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> b) {
        b.m_61104_(new Property[]{ROTATION, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, dir, neighbor, level, pos, neighborPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return DNLBlockEntityTypes.PLAYER_STATUE.get().m_155264_(pos, state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (level.f_46443_) {
            return;
        }
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof PlayerStatueBlockEntity)) {
            return;
        }
        PlayerStatueBlockEntity statue = (PlayerStatueBlockEntity)be;
        GameProfile gp = null;
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            if (tag.m_128425_("Owner", 10)) {
                gp = NbtUtils.m_129228_((CompoundTag)tag.m_128469_("Owner"));
            } else if (tag.m_128425_("SkullOwner", 10)) {
                gp = NbtUtils.m_129228_((CompoundTag)tag.m_128469_("SkullOwner"));
            } else if (tag.m_128425_("SkullOwner", 8)) {
                gp = new GameProfile(null, tag.m_128461_("SkullOwner"));
            }
        }
        if (gp == null) {
            gp = new GameProfile(null, "MHF_Alex");
        }
        statue.setOwner(gp);
        if (tag != null) {
            ItemStack off;
            PlayerStatueBlockEntity.NotchTier tier;
            if (tag.m_128425_("DNL_Notch", 8)) {
                PlayerStatueBlockEntity.NotchTier tier2 = PlayerStatueBlockEntity.NotchTier.fromString(tag.m_128461_("DNL_Notch"));
                if (tier2 != PlayerStatueBlockEntity.NotchTier.NONE) {
                    statue.setNotchTier(tier2);
                }
            } else if (tag.m_128425_("Offering", 10) && (tier = PlayerStatueBlockEntity.tierFromItem(off = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Offering")))) != PlayerStatueBlockEntity.NotchTier.NONE) {
                statue.setNotchTier(tier);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack held = player.m_21120_(hand);
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof PlayerStatueBlockEntity)) {
            return InteractionResult.PASS;
        }
        PlayerStatueBlockEntity statue = (PlayerStatueBlockEntity)be;
        if (!level.f_46443_) {
            if (statue.isWaxed()) {
                level.m_5594_(null, pos, SoundEvents.f_276627_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.PASS;
            }
            if (statue.isOccupied()) {
                ItemStack out = statue.takeMaterial();
                if (!out.m_41619_()) {
                    boolean added = player.m_36356_(out);
                    if (!added) {
                        player.m_36176_(out, false);
                    }
                    level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.5f, 1.0f);
                    String ownerName = "Someone";
                    GameProfile gp = statue.getOwner();
                    if (gp != null && gp.getName() != null && !gp.getName().isEmpty()) {
                        ownerName = gp.getName();
                    } else {
                        String resolved = statue.ensureServerSideOwnerName();
                        if (resolved != null && !resolved.isEmpty()) {
                            ownerName = resolved;
                        } else if (gp != null) {
                            ownerName = PlayerStatueBlockEntity.shortUuid(gp.getId());
                        }
                    }
                    MutableComponent msg = Component.m_237110_((String)"block.dungeonnowloading.player_statue.message", (Object[])new Object[]{Component.m_237113_((String)ownerName).m_130940_(ChatFormatting.GOLD)});
                    player.m_5661_((Component)msg, true);
                }
                return InteractionResult.CONSUME;
            }
            PlayerStatueBlockEntity.NotchTier tier = PlayerStatueBlockEntity.tierFromItem(held);
            if (tier != PlayerStatueBlockEntity.NotchTier.NONE) {
                ItemStack one = held.m_41777_();
                one.m_41764_(1);
                if (statue.placeMaterial(one)) {
                    if (!player.m_150110_().f_35937_) {
                        held.m_41774_(1);
                    }
                    level.m_5594_(null, pos, SoundEvents.f_144243_, SoundSource.BLOCKS, 0.6f, 1.2f);
                    return InteractionResult.CONSUME;
                }
            }
        } else if (statue.isOccupied() || PlayerStatueBlockEntity.tierFromItem(held) != PlayerStatueBlockEntity.NotchTier.NONE) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static boolean otherPlayerIsEditing(Player player, PlayerStatueBlockEntity be) {
        UUID lock = be.getAllowedEditor();
        return lock != null && !lock.equals(player.m_20148_());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.f_46443_ ? PlayerStatueBlock.m_152132_(type, DNLBlockEntityTypes.PLAYER_STATUE.get(), PlayerStatueBlockEntity::serverTick) : null;
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(world, pos, state);
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof PlayerStatueBlockEntity) {
            PlayerStatueBlockEntity statue = (PlayerStatueBlockEntity)be;
            GameProfile gp = statue.getOwner();
            if (gp != null && gp.getName() != null && !gp.getName().isEmpty()) {
                stack.m_41784_().m_128359_("SkullOwner", gp.getName());
            } else if (gp != null) {
                stack.m_41784_().m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)gp));
            }
            stack.m_41784_().m_128405_("DNL_Pose", statue.getPoseVariant());
            stack.m_41784_().m_128359_("DNL_Notch", statue.getNotchTier().name());
        }
        return stack;
    }
}

