/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ChaosSpawnerBarrierCenterBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)15.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape UP_AABB = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape DOWN_AABB = Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final ImmutableList<BlockPos> BLOCK_LOCATIONS_X = ImmutableList.of((Object)new BlockPos(0, 2, 0), (Object)new BlockPos(0, 2, 2), (Object)new BlockPos(0, 0, 2), (Object)new BlockPos(0, -2, 2), (Object)new BlockPos(0, -2, 0), (Object)new BlockPos(0, -2, -2), (Object)new BlockPos(0, 0, -2), (Object)new BlockPos(0, 2, -2));
    private static final ImmutableList<BlockPos> BLOCK_LOCATIONS_Y = ImmutableList.of((Object)new BlockPos(2, 0, 0), (Object)new BlockPos(2, 0, 2), (Object)new BlockPos(0, 0, 2), (Object)new BlockPos(-2, 0, 2), (Object)new BlockPos(-2, 0, 0), (Object)new BlockPos(-2, 0, -2), (Object)new BlockPos(0, 0, -2), (Object)new BlockPos(2, 0, -2));
    private static final ImmutableList<BlockPos> BLOCK_LOCATIONS_Z = ImmutableList.of((Object)new BlockPos(0, 2, 0), (Object)new BlockPos(2, 2, 0), (Object)new BlockPos(2, 0, 0), (Object)new BlockPos(2, -2, 0), (Object)new BlockPos(0, -2, 0), (Object)new BlockPos(-2, -2, 0), (Object)new BlockPos(-2, 0, 0), (Object)new BlockPos(-2, 2, 0));
    private static final ImmutableList<BlockPos> BARRIER_LOCATIONS_X = ImmutableList.of((Object)new BlockPos(0, 1, 0), (Object)new BlockPos(0, 1, -1), (Object)new BlockPos(0, 0, -1), (Object)new BlockPos(0, -1, -1), (Object)new BlockPos(0, -1, 0), (Object)new BlockPos(0, -1, 1), (Object)new BlockPos(0, 0, 1), (Object)new BlockPos(0, 1, 1));
    private static final ImmutableList<BlockPos> BARRIER_LOCATIONS_Y = ImmutableList.of((Object)new BlockPos(1, 0, 0), (Object)new BlockPos(1, 0, -1), (Object)new BlockPos(0, 0, -1), (Object)new BlockPos(-1, 0, -1), (Object)new BlockPos(-1, 0, 0), (Object)new BlockPos(-1, 0, 1), (Object)new BlockPos(0, 0, 1), (Object)new BlockPos(1, 0, 1));
    private static final ImmutableList<BlockPos> BARRIER_LOCATIONS_Z = ImmutableList.of((Object)new BlockPos(0, 1, 0), (Object)new BlockPos(-1, 1, 0), (Object)new BlockPos(-1, 0, 0), (Object)new BlockPos(-1, -1, 0), (Object)new BlockPos(0, -1, 0), (Object)new BlockPos(1, -1, 0), (Object)new BlockPos(1, 0, 0), (Object)new BlockPos(1, 1, 0));

    public ChaosSpawnerBarrierCenterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        switch ((Direction)blockState.m_61143_((Property)FACING)) {
            default: {
                return NORTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case UP: {
                return UP_AABB;
            }
            case DOWN: 
        }
        return DOWN_AABB;
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_7820_().m_122424_());
    }

    public static void checkBarrierCondition(Level level, BlockPos blockPos, Direction.Axis direction) {
        if (level.m_8055_(blockPos).m_60713_(DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get())) {
            BlockPos offsetAmount;
            UnmodifiableIterator iterator = null;
            if (direction == Direction.Axis.X) {
                iterator = BLOCK_LOCATIONS_X.iterator();
            } else if (direction == Direction.Axis.Y) {
                iterator = BLOCK_LOCATIONS_Y.iterator();
            } else if (direction == Direction.Axis.Z) {
                iterator = BLOCK_LOCATIONS_Z.iterator();
            }
            int brokenFrame = 0;
            while (iterator.hasNext() && !level.m_8055_(blockPos.m_121955_((Vec3i)(offsetAmount = (BlockPos)iterator.next()))).m_60713_(DNLBlocks.CHAOS_SPAWNER_DIAMOND_EDGE.get()) && !level.m_8055_(blockPos.m_121955_((Vec3i)offsetAmount)).m_60713_(DNLBlocks.CHAOS_SPAWNER_DIAMOND_VERTEX.get())) {
                ++brokenFrame;
            }
            if (brokenFrame == 8) {
                level.m_46961_(blockPos, false);
                UnmodifiableIterator barrierIterator = null;
                if (direction == Direction.Axis.X) {
                    barrierIterator = BARRIER_LOCATIONS_X.iterator();
                } else if (direction == Direction.Axis.Y) {
                    barrierIterator = BARRIER_LOCATIONS_Y.iterator();
                } else if (direction == Direction.Axis.Z) {
                    barrierIterator = BARRIER_LOCATIONS_Z.iterator();
                }
                while (barrierIterator.hasNext()) {
                    BlockPos breakPos = blockPos.m_121955_((Vec3i)((BlockPos)barrierIterator.next()));
                    level.m_46961_(breakPos, false);
                }
            }
        }
    }

    public static void placeBarrier(Level level, BlockPos blockPos, int direction) {
        if (direction == 0) {
            level.m_7731_(blockPos, (BlockState)((BlockState)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get().m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 2);
        } else if (direction == 1) {
            level.m_7731_(blockPos, (BlockState)((BlockState)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get().m_49966_().m_61124_((Property)FACING, (Comparable)Direction.EAST)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 2);
        } else if (direction == 2) {
            level.m_7731_(blockPos, (BlockState)((BlockState)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get().m_49966_().m_61124_((Property)FACING, (Comparable)Direction.SOUTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 2);
        } else if (direction == 3) {
            level.m_7731_(blockPos, (BlockState)((BlockState)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get().m_49966_().m_61124_((Property)FACING, (Comparable)Direction.WEST)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 2);
        } else if (direction == 4) {
            level.m_7731_(blockPos, (BlockState)((BlockState)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get().m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 2);
        } else if (direction == 5) {
            level.m_7731_(blockPos, (BlockState)((BlockState)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get().m_49966_().m_61124_((Property)FACING, (Comparable)Direction.DOWN)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }
}

