/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import dev.hexnowloading.dungeonnowloading.block.BallistaGolemStatueBlock;
import dev.hexnowloading.dungeonnowloading.block.entity.BallistaGolemStatueBlockEntity;
import dev.hexnowloading.dungeonnowloading.block.property.BallistaGolemStatueStates;
import dev.hexnowloading.dungeonnowloading.registry.DNLItems;
import dev.hexnowloading.dungeonnowloading.registry.DNLProperties;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BallistaGolemStatuePartBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<BallistaGolemStatueStates> STATES = DNLProperties.BALLISTA_GOLEM_STATUE_PARTS;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private boolean playerDestroyedPart = false;

    public BallistaGolemStatuePartBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(STATES, (Comparable)((Object)BallistaGolemStatueStates.TOP_C))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_().m_122424_())).m_61124_(STATES, (Comparable)((Object)BallistaGolemStatueStates.TOP_C))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!world.f_46443_ && state.m_60734_() != newState.m_60734_()) {
            Direction partFacing;
            BallistaGolemStatueStates partState = (BallistaGolemStatueStates)((Object)state.m_61143_(STATES));
            BlockPos corePos = BallistaGolemStatuePartBlock.findCorePosition(pos, partState, partFacing = (Direction)state.m_61143_((Property)FACING));
            BlockState coreState = world.m_8055_(corePos);
            Block block = coreState.m_60734_();
            if (!(block instanceof BallistaGolemStatueBlock)) {
                return;
            }
            BallistaGolemStatueBlock ballistaGolemStatueBlock = (BallistaGolemStatueBlock)block;
            ballistaGolemStatueBlock.setPlayerDestroyed(this.playerDestroyedPart);
            Direction coreFacing = (Direction)coreState.m_61143_((Property)FACING);
            for (Map.Entry<BallistaGolemStatueStates, BlockPos> entry : BallistaGolemStatueBlock.statePositions.entrySet()) {
                BlockPos relativePos = entry.getValue();
                BlockPos adjustedPos = BallistaGolemStatuePartBlock.applyReverseRotation(relativePos, coreFacing);
                BlockPos partPos = corePos.m_121955_((Vec3i)adjustedPos);
                world.m_46961_(partPos, false);
            }
            world.m_46961_(corePos, false);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.f_46443_) {
            boolean bl = this.playerDestroyedPart = !player.m_150110_().f_35937_;
            if (this.playerDestroyedPart) {
                ItemStack heldItem = player.m_21205_();
                this.playerDestroyedPart = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)heldItem) < 1;
            }
        }
        super.m_5707_(world, pos, state, player);
    }

    public static BlockPos findCorePosition(BlockPos partPos, BallistaGolemStatueStates partState, Direction partFacing) {
        BlockPos relativePos = BallistaGolemStatueBlock.statePositions.get((Object)partState);
        BlockPos adjustedPos = BallistaGolemStatuePartBlock.applyReverseRotation(relativePos, partFacing);
        return partPos.m_121996_((Vec3i)adjustedPos);
    }

    private static BlockPos applyReverseRotation(BlockPos pos, Direction facing) {
        switch (facing) {
            case NORTH: {
                return pos;
            }
            case SOUTH: {
                return new BlockPos(-pos.m_123341_(), pos.m_123342_(), -pos.m_123343_());
            }
            case WEST: {
                return new BlockPos(pos.m_123343_(), pos.m_123342_(), -pos.m_123341_());
            }
            case EAST: {
                return new BlockPos(-pos.m_123343_(), pos.m_123342_(), pos.m_123341_());
            }
        }
        return pos;
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos1, boolean b) {
        if (level.f_46443_) {
            return;
        }
        if (!level.m_276867_(blockPos)) {
            return;
        }
        BlockPos corePos = BallistaGolemStatuePartBlock.findCorePosition(blockPos, (BallistaGolemStatueStates)((Object)blockState.m_61143_(STATES)), (Direction)blockState.m_61143_((Property)FACING));
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        BallistaGolemStatueBlockEntity blockEntity = (BallistaGolemStatueBlockEntity)level.m_7702_(corePos);
        if (blockEntity != null) {
            blockEntity.summonBallistaGolemEntity(level, corePos, facing);
            this.playerDestroyedPart = false;
        }
        BallistaGolemStatueBlock.destroyAllBlocks(level, corePos);
        BallistaGolemStatueBlock.destroyBlocksAbove(level, corePos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{FACING});
        stateBuilder.m_61104_(new Property[]{STATES});
        stateBuilder.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public ItemStack m_7397_(BlockGetter $$0, BlockPos $$1, BlockState $$2) {
        return new ItemStack((ItemLike)DNLItems.BALLISTA_GOLEM_STATUE.get());
    }
}

