/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.hexnowloading.dungeonnowloading.DungeonNowLoading;
import dev.hexnowloading.dungeonnowloading.client.DNLForgeClient;
import dev.hexnowloading.dungeonnowloading.client.DNLForgeClientEvents;
import dev.hexnowloading.dungeonnowloading.menu.MendingTableMenu;
import dev.hexnowloading.dungeonnowloading.platform.ForgeCommonRegistryHelper;
import dev.hexnowloading.dungeonnowloading.platform.Services;
import dev.hexnowloading.dungeonnowloading.registry.DNLFlammables;
import dev.hexnowloading.dungeonnowloading.registry.DNLMenuTypes;
import dev.hexnowloading.dungeonnowloading.server.DNLForgeEntityEvents;
import dev.hexnowloading.dungeonnowloading.supporter.PatronRegistry;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="dungeonnowloading")
public class DNLForge {
    public DNLForge() {
        DungeonNowLoading.init();
        Supplier<MenuType<MendingTableMenu>> mendingTable = Services.REGISTRY.register(BuiltInRegistries.f_256818_, "mending_table", () -> IForgeMenuType.create((id, inv, buf) -> new MendingTableMenu(id, inv)));
        DNLMenuTypes.bootstrap(mendingTable);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        this.addModListeners(bus);
        if (FMLEnvironment.dist.isClient()) {
            this.addModClientListeners(bus);
            bus.addListener(event -> DNLForgeClient.init());
        }
        this.addForgeListeners();
        DungeonNowLoading.LOGGER.info("Hello Forge world!");
    }

    private void addModListeners(IEventBus bus) {
        ForgeCommonRegistryHelper.TAB_REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        bus.addListener(DNLForgeEntityEvents::onEntityAttributeCreation);
        bus.addListener(DNLForgeEntityEvents::registerSpawnPlacements);
        bus.addListener(this::onCommonSetup);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(DNLFlammables::register);
    }

    private void addModClientListeners(IEventBus bus) {
        bus.addListener(DNLForgeClientEvents::onRegisterRenderer);
        bus.addListener(DNLForgeClientEvents::onRegisterLayers);
        bus.addListener(DNLForgeClientEvents::onRegisterParticleProviders);
    }

    private void addForgeListeners() {
        MinecraftForge.EVENT_BUS.addListener(DNLForgeEntityEvents::onLivingDamageEvent);
        MinecraftForge.EVENT_BUS.addListener(DNLForgeEntityEvents::onLivingHurtEvent);
        MinecraftForge.EVENT_BUS.addListener(e -> CompletableFuture.runAsync(() -> PatronRegistry.initOrReload(e.getServer()), Util.m_183991_()));
        MinecraftForge.EVENT_BUS.addListener(e -> e.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dnlpatrons").requires(src -> src.m_6761_(2))).then(Commands.m_82127_((String)"reload").executes(ctx -> {
            PatronRegistry.initOrReload(((CommandSourceStack)ctx.getSource()).m_81377_());
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"[DNL] Patrons reloaded."), true);
            return 1;
        }))));
    }
}

