/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.unit.function;

import dev.latvian.mods.unit.Unit;
import dev.latvian.mods.unit.token.UnitInterpretException;
import java.util.function.Supplier;

public record FunctionFactory(String name, int minArgs, int maxArgs, FuncSupplier supplier) {
    public static FunctionFactory of(String name, int minArgs, int maxArgs, FuncSupplier supplier) {
        return new FunctionFactory(name, minArgs, maxArgs, supplier);
    }

    public static FunctionFactory of(String name, int args, FuncSupplier supplier) {
        return FunctionFactory.of(name, args, args, supplier);
    }

    public static FunctionFactory of0(String name, Supplier<Unit> supplier) {
        return FunctionFactory.of(name, 0, new Arg0(supplier));
    }

    public static FunctionFactory of1(String name, Arg1 supplier) {
        return FunctionFactory.of(name, 1, supplier);
    }

    public static FunctionFactory of2(String name, Arg2 supplier) {
        return FunctionFactory.of(name, 2, supplier);
    }

    public static FunctionFactory of3(String name, Arg3 supplier) {
        return FunctionFactory.of(name, 3, supplier);
    }

    public Unit create(Unit[] args) {
        if (args.length < this.minArgs || args.length > this.maxArgs) {
            throw new UnitInterpretException("Invalid number of arguments for function '" + this.name + "'. Expected " + (String)(this.minArgs == this.maxArgs ? String.valueOf(this.minArgs) : this.minArgs + "-" + this.maxArgs) + " but got " + args.length);
        }
        return this.supplier.create(args);
    }

    @FunctionalInterface
    public static interface FuncSupplier {
        public Unit create(Unit[] var1);
    }

    public static final class Arg0
    implements FuncSupplier {
        private final Supplier<Unit> unit;
        private Unit cachedUnit;

        public Arg0(Supplier<Unit> unit) {
            this.unit = unit;
        }

        @Override
        public Unit create(Unit[] args) {
            if (this.cachedUnit == null) {
                this.cachedUnit = this.unit.get();
            }
            return this.cachedUnit;
        }
    }

    @FunctionalInterface
    public static interface Arg3
    extends FuncSupplier {
        public Unit createArg(Unit var1, Unit var2, Unit var3);

        @Override
        default public Unit create(Unit[] args) {
            return this.createArg(args[0], args[1], args[2]);
        }
    }

    @FunctionalInterface
    public static interface Arg2
    extends FuncSupplier {
        public Unit createArg(Unit var1, Unit var2);

        @Override
        default public Unit create(Unit[] args) {
            return this.createArg(args[0], args[1]);
        }
    }

    @FunctionalInterface
    public static interface Arg1
    extends FuncSupplier {
        public Unit createArg(Unit var1);

        @Override
        default public Unit create(Unit[] args) {
            return this.createArg(args[0]);
        }
    }
}

