/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.unusual.blockfactorysbosses.procedures.FallingDustParticleVisualScaleProcedure;

@OnlyIn(value=Dist.CLIENT)
public class GroundDustParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private float fall;
    private float angularVelocity;
    private float angularAcceleration;

    public static GroundDustParticleProvider provider(SpriteSet spriteSet) {
        return new GroundDustParticleProvider(spriteSet);
    }

    protected GroundDustParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.m_107250_(0.2f, 0.2f);
        this.f_107225_ = Math.max(1, 60 + (this.f_107223_.m_188503_(4) - 2));
        this.f_107226_ = 1.2f;
        this.fall = 0.8f;
        this.f_107219_ = true;
        this.f_107215_ = vx * 0.3;
        this.f_107216_ = Math.abs(vy) * 0.4;
        this.f_107217_ = vz * 0.3;
        this.angularVelocity = 0.3f;
        this.angularAcceleration = 0.0f;
        this.m_108335_(spriteSet);
        float rdm = (float)Math.random();
        this.f_107227_ = 0.874f * (1.0f - rdm) + 0.906f * rdm;
        this.f_107228_ = 0.392f * (1.0f - rdm) + 0.573f * rdm;
        this.f_107229_ = 0.263f * (1.0f - rdm) + 0.443f * rdm;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public float m_5902_(float scale) {
        ClientLevel world = this.f_107208_;
        return super.m_5902_(scale) * (float)FallingDustParticleVisualScaleProcedure.execute(this.f_107224_);
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += this.angularVelocity;
        this.angularVelocity += this.angularAcceleration;
        ClientLevel world = this.f_107208_;
        if (this.f_107218_) {
            this.fall = 0.75f * this.fall;
            this.f_107216_ = this.fall;
        }
    }

    public static class GroundDustParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public GroundDustParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new GroundDustParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

