/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.block;

import java.util.LinkedHashMap;
import java.util.Map;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public abstract class LazyStateBlock
extends Block {
    private final Map<Property<?>, Comparable<?>> propMap = new LinkedHashMap();
    private boolean computedState = false;

    public LazyStateBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected final <T extends Comparable<T>, V extends T> void addProperty(Property<T> prop, V default_) {
        if (this.computedState) {
            throw new IllegalStateException("State has already been computed.");
        }
        this.propMap.put(prop, (Comparable<?>)default_);
    }

    protected BlockState processDefault(BlockState state) {
        return state;
    }

    public StateDefinition<Block, BlockState> m_49965_() {
        this.computeState();
        return super.m_49965_();
    }

    public BlockState m_49966_() {
        this.computeState();
        return super.m_49966_();
    }

    private void computeState() {
        BlockState defaultState;
        if (this.computedState) {
            return;
        }
        if (!this.propMap.isEmpty()) {
            StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
            this.propMap.keySet().forEach(xva$0 -> builder.m_61104_(new Property[]{xva$0}));
            this.f_49792_ = builder.m_61101_(Block::m_49966_, BlockState::new);
            defaultState = (BlockState)this.f_49792_.m_61090_();
            for (Map.Entry<Property<?>, Comparable<?>> entry : this.propMap.entrySet()) {
                defaultState = (BlockState)defaultState.m_61124_(entry.getKey(), (Comparable)SneakyUtils.unsafeCast(entry.getValue()));
            }
        } else {
            defaultState = (BlockState)this.f_49792_.m_61090_();
        }
        this.m_49959_(this.processDefault(defaultState));
        this.computedState = true;
        this.propMap.clear();
    }

    protected final void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
    }
}

