/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.merged;

import java.util.Arrays;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.common.capabilities.fluid.FluidTankWrapper;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;

@NothingNullByDefault
public class MergedTank
extends MergedChemicalTank {
    private final IExtendedFluidTank fluidTank;

    public static MergedTank create(IExtendedFluidTank fluidTank, IGasTank gasTank, IInfusionTank infusionTank, IPigmentTank pigmentTank, ISlurryTank slurryTank) {
        Objects.requireNonNull(fluidTank, "Fluid tank cannot be null");
        Objects.requireNonNull(gasTank, "Gas tank cannot be null");
        Objects.requireNonNull(infusionTank, "Infusion tank cannot be null");
        Objects.requireNonNull(pigmentTank, "Pigment tank cannot be null");
        Objects.requireNonNull(slurryTank, "Slurry tank cannot be null");
        return new MergedTank(fluidTank, gasTank, infusionTank, pigmentTank, slurryTank);
    }

    private MergedTank(IExtendedFluidTank fluidTank, IChemicalTank<?, ?> ... chemicalTanks) {
        super(fluidTank::isEmpty, chemicalTanks);
        this.fluidTank = new FluidTankWrapper(this, fluidTank, () -> Arrays.stream(chemicalTanks).allMatch(IChemicalTank::isEmpty));
    }

    public CurrentType getCurrentType() {
        if (!this.getFluidTank().isEmpty()) {
            return CurrentType.FLUID;
        }
        return switch (this.getCurrent()) {
            default -> throw new IncompatibleClassChangeError();
            case MergedChemicalTank.Current.EMPTY -> CurrentType.EMPTY;
            case MergedChemicalTank.Current.GAS -> CurrentType.GAS;
            case MergedChemicalTank.Current.INFUSION -> CurrentType.INFUSION;
            case MergedChemicalTank.Current.PIGMENT -> CurrentType.PIGMENT;
            case MergedChemicalTank.Current.SLURRY -> CurrentType.SLURRY;
        };
    }

    public final IExtendedFluidTank getFluidTank() {
        return this.fluidTank;
    }

    public void addToUpdateTag(CompoundTag updateTag) {
        updateTag.m_128365_("fluid", (Tag)this.getFluidTank().getFluid().writeToNBT(new CompoundTag()));
        updateTag.m_128365_("gas", (Tag)((GasStack)this.getGasTank().getStack()).write(new CompoundTag()));
        updateTag.m_128365_("infuseTypeName", (Tag)((InfusionStack)this.getInfusionTank().getStack()).write(new CompoundTag()));
        updateTag.m_128365_("pigment", (Tag)((PigmentStack)this.getPigmentTank().getStack()).write(new CompoundTag()));
        updateTag.m_128365_("slurry", (Tag)((SlurryStack)this.getSlurryTank().getStack()).write(new CompoundTag()));
    }

    public void readFromUpdateTag(CompoundTag tag) {
        NBTUtils.setFluidStackIfPresent(tag, "fluid", value -> this.getFluidTank().setStack((FluidStack)value));
        NBTUtils.setGasStackIfPresent(tag, "gas", value -> this.getGasTank().setStack(value));
        NBTUtils.setInfusionStackIfPresent(tag, "infuseTypeName", value -> this.getInfusionTank().setStack(value));
        NBTUtils.setPigmentStackIfPresent(tag, "pigment", value -> this.getPigmentTank().setStack(value));
        NBTUtils.setSlurryStackIfPresent(tag, "slurry", value -> this.getSlurryTank().setStack(value));
    }

    public static enum CurrentType {
        EMPTY,
        FLUID,
        GAS,
        INFUSION,
        PIGMENT,
        SLURRY;

    }
}

