/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import dan200.computercraft.shared.computer.core.ServerComputer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.jspecify.annotations.Nullable;

public class ServerComputerRegistry {
    private static final Random RANDOM = new Random();
    private final int sessionId = RANDOM.nextInt();
    private final Int2ObjectMap<ServerComputer> computersByInstanceId = new Int2ObjectOpenHashMap();
    private final Map<UUID, ServerComputer> computersByInstanceUuid = new HashMap<UUID, ServerComputer>();
    private int nextInstanceId;

    public int getSessionID() {
        return this.sessionId;
    }

    int getUnusedInstanceID() {
        return this.nextInstanceId++;
    }

    public @Nullable ServerComputer get(int instanceID) {
        return instanceID >= 0 ? (ServerComputer)this.computersByInstanceId.get(instanceID) : null;
    }

    public @Nullable ServerComputer get(@Nullable UUID instanceID) {
        return instanceID != null ? this.computersByInstanceUuid.get(instanceID) : null;
    }

    public @Nullable ServerComputer get(int sessionId, @Nullable UUID instanceId) {
        return sessionId == this.sessionId ? this.get(instanceId) : null;
    }

    void update() {
        ObjectIterator it = this.computersByInstanceId.values().iterator();
        while (it.hasNext()) {
            ServerComputer computer = (ServerComputer)it.next();
            if (computer.hasTimedOut()) {
                computer.unload();
                computer.onRemoved();
                it.remove();
                this.computersByInstanceUuid.remove(computer.getInstanceUUID());
                continue;
            }
            computer.tickServer();
        }
    }

    void add(ServerComputer computer) {
        int instanceID = computer.getInstanceID();
        UUID instanceUUID = computer.getInstanceUUID();
        if (this.computersByInstanceId.containsKey(instanceID)) {
            throw new IllegalStateException("Duplicate computer " + instanceID);
        }
        if (this.computersByInstanceUuid.containsKey(instanceUUID)) {
            throw new IllegalStateException("Duplicate computer " + String.valueOf(instanceUUID));
        }
        this.computersByInstanceId.put(instanceID, (Object)computer);
        this.computersByInstanceUuid.put(instanceUUID, computer);
    }

    void remove(ServerComputer computer) {
        computer.unload();
        computer.onRemoved();
        this.computersByInstanceId.remove(computer.getInstanceID());
        this.computersByInstanceUuid.remove(computer.getInstanceUUID());
    }

    void close() {
        for (ServerComputer computer : this.getComputers()) {
            computer.unload();
        }
        this.computersByInstanceId.clear();
        this.computersByInstanceUuid.clear();
    }

    public Collection<ServerComputer> getComputers() {
        return this.computersByInstanceId.values();
    }
}

