/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.raccompat.items;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import it.hurts.sskirillss.raccompat.misc.RACLootCollections;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class VineRingItem
extends RelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"vine").active(CastData.builder().type(CastType.INSTANTANEOUS).castPredicate("ceil", (player, stack) -> {
            int maxDistance = (int)this.getAbilityValue((ItemStack)stack, "vine", "length");
            return VineRingItem.getCeilDistance(player.m_9236_(), player.m_20182_(), maxDistance) <= (double)maxDistance;
        }).build()).stat(StatData.builder((String)"length").initialValue(10.0, 15.0).upgradeModifier(UpgradeOperation.MULTIPLY_TOTAL, 0.175).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"cooldown").initialValue(20.0, 30.0).upgradeModifier(UpgradeOperation.MULTIPLY_TOTAL, -0.1).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-14203131).borderBottom(-14083825).textured(true).build()).build()).loot(LootData.builder().entry(RACLootCollections.PRIMORDIAL).build()).build();
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (!ability.equals("vine")) {
            return;
        }
        Level level = player.m_9236_();
        RandomSource random = level.m_213780_();
        double height = VineRingItem.getCeilHeight(level, player.m_20182_(), (int)this.getAbilityValue(stack, "vine", "length"));
        this.spreadExperience((LivingEntity)player, stack, (int)height);
        int offset = -1;
        while (player.m_20186_() + (double)offset < height) {
            BlockPos pos = player.m_20183_().m_6630_(offset++);
            if (!level.m_8055_(pos).m_247087_()) continue;
            level.m_46597_(pos, ((Block)ACBlockRegistry.ARCHAIC_VINE.get()).m_49966_());
            for (int i = 0; i < 5; ++i) {
                level.m_142052_(pos, ((Block)ACBlockRegistry.ARCHAIC_VINE.get()).m_49966_());
                level.m_7106_(ParticleUtils.constructSimpleSpark((Color)new Color(140 + random.m_188503_(50), 255 - random.m_188503_(50), 0), (float)(0.1f + random.m_188501_() * 0.1f), (int)(60 + random.m_188503_(60)), (float)0.98f), (double)((float)pos.m_123341_() + random.m_188501_()), (double)((float)pos.m_123342_() + random.m_188501_()), (double)((float)pos.m_123343_() + random.m_188501_()), (double)(MathUtils.randomFloat((RandomSource)random) * 0.01f), 0.0, (double)(MathUtils.randomFloat((RandomSource)random) * 0.01f));
            }
            level.m_5594_(null, pos, SoundEvents.f_144241_, SoundSource.MASTER, 1.0f, 1.0f + random.m_188501_());
        }
        player.m_20334_(0.0, Math.log(player.m_20182_().m_82554_(player.m_20182_().m_193103_(Direction.Axis.Y, height))) * (double)0.4f, 0.0);
        this.addAbilityCooldown(stack, "vine", (int)(this.getAbilityValue(stack, "vine", "cooldown") * 20.0));
    }

    public static double getCeilHeight(Level level, Vec3 position, int iterations) {
        BlockHitResult result = level.m_45547_(new ClipContext(position, position.m_82520_(0.0, (double)iterations, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, null));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return result.m_82450_().m_7098_();
        }
        return level.m_151558_();
    }

    public static double getCeilDistance(Level level, Vec3 position, int iterations) {
        return Math.max(0.0, VineRingItem.getCeilHeight(level, position, iterations) - position.m_7098_());
    }
}

