/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.raccompat.items;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.DesolateDaggerEntity;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.raccompat.init.ItemRegistry;
import it.hurts.sskirillss.raccompat.misc.RACLootCollections;
import it.hurts.sskirillss.raccompat.network.NetworkHandler;
import it.hurts.sskirillss.raccompat.network.packets.DesolateDaggerRenderStackPacket;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class DesolatePendantItem
extends RelicItem
implements IRenderableCurio {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"desolate").stat(StatData.builder((String)"chance").initialValue(0.05, 0.15).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).stat(StatData.builder((String)"damage").initialValue(0.1, 0.25).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).ability(AbilityData.builder((String)"devastate").requiredLevel(5).active(CastData.builder().type(CastType.INSTANTANEOUS).castPredicate("target", (player, stack) -> EntityUtils.rayTraceEntity((Entity)player, entity -> !entity.m_5833_() && entity instanceof Attackable, (double)16.0) != null).castPredicate("weapon", (player, stack) -> player.m_21205_().m_41638_(EquipmentSlot.MAINHAND).containsKey((Object)Attributes.f_22281_)).build()).stat(StatData.builder((String)"count").initialValue(1.0, 3.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"cooldown").initialValue(30.0, 40.0).upgradeModifier(UpgradeOperation.MULTIPLY_TOTAL, -0.025).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).loot(LootData.builder().entry(RACLootCollections.FORLORN).build()).build();
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (!ability.equals("devastate")) {
            return;
        }
        Level level = player.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        double damage = 1.0;
        for (AttributeModifier modifier : player.m_21205_().m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_)) {
            damage += modifier.m_22218_();
        }
        EntityHitResult result = EntityUtils.rayTraceEntity((Entity)player, entity -> !entity.m_5833_() && entity instanceof Attackable, (double)16.0);
        if (result == null) {
            return;
        }
        RandomSource random = player.m_217043_();
        int i = 0;
        while ((double)i < this.getAbilityValue(stack, "devastate", "count")) {
            DesolateDaggerEntity dagger = new DesolateDaggerEntity((EntityType)ACEntityRegistry.DESOLATE_DAGGER.get(), level);
            dagger.getPersistentData().m_128347_("raccompat_damage", damage * this.getAbilityValue(stack, "desolate", "damage"));
            dagger.daggerRenderStack = player.m_21205_();
            dagger.setTargetId(result.m_82443_().m_19879_());
            dagger.setStab(-random.m_188501_());
            dagger.setPlayerId(player.m_19879_());
            dagger.orbitFor = 20 + i * 5;
            dagger.m_20359_((Entity)player);
            dagger.setItemStack(stack);
            level.m_7967_((Entity)dagger);
            this.spreadExperience((LivingEntity)player, stack, 1);
            if (!level.m_5776_()) {
                NetworkHandler.sendToClients(PacketDistributor.TRACKING_ENTITY.with(() -> dagger), new DesolateDaggerRenderStackPacket(dagger.daggerRenderStack, dagger.m_19879_()));
            }
            ++i;
        }
        this.addAbilityCooldown(stack, ability, (int)(this.getAbilityValue(stack, "devastate", "cooldown") * 20.0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.m_85836_();
        LivingEntity entity = slotContext.entity();
        model.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.translateIfSneaking((PoseStack)matrixStack, (LivingEntity)entity);
        ICurioRenderer.rotateIfSneaking((PoseStack)matrixStack, (LivingEntity)entity);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)this.getTexture(stack)), (boolean)false, (boolean)stack.m_41790_());
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        model.m_7695_(matrixStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85841_(2.0f, 2.0f, 2.0f);
        matrixStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        mesh.m_171576_().m_171599_("body", CubeListBuilder.m_171558_().m_171514_(45, 36).m_171488_(-4.0f, 6.25f, -4.7f, 8.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(27, 36).m_171488_(-3.0f, 5.25f, -5.2f, 6.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(16, 35).m_171488_(-2.0f, 4.25f, -4.7f, 4.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-8.0f, 0.0f, -3.65f, 16.0f, 7.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)1.5f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public List<String> headParts() {
        return Lists.newArrayList((Object[])new String[]{"body"});
    }

    @Mod.EventBusSubscriber
    public static class DesolatePendantEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            IRelicItem relic;
            ItemStack stack;
            RandomSource random;
            Player player;
            block10: {
                block9: {
                    Item item;
                    block8: {
                        block7: {
                            Entity entity = event.getSource().m_7639_();
                            if (!(entity instanceof Player)) break block7;
                            player = (Player)entity;
                            if (!(event.getAmount() < 1.0f) && player.m_21205_().m_41638_(EquipmentSlot.MAINHAND).containsKey((Object)Attributes.f_22281_)) break block8;
                        }
                        return;
                    }
                    random = player.m_217043_();
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.DESOLATE_PENDANT.get()));
                    if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof IRelicItem)) break block9;
                    relic = (IRelicItem)item;
                    if (!((double)random.m_188501_() > relic.getAbilityValue(stack, "desolate", "chance"))) break block10;
                }
                return;
            }
            Level level = player.m_9236_();
            DesolateDaggerEntity dagger = new DesolateDaggerEntity((EntityType)ACEntityRegistry.DESOLATE_DAGGER.get(), level);
            dagger.getPersistentData().m_128347_("raccompat_damage", (double)event.getAmount() * relic.getAbilityValue(stack, "desolate", "damage"));
            dagger.daggerRenderStack = player.m_21205_();
            dagger.orbitFor = 20 + random.m_188503_(40);
            dagger.setTargetId(event.getEntity().m_19879_());
            dagger.setPlayerId(player.m_19879_());
            dagger.m_20359_((Entity)player);
            dagger.setItemStack(stack);
            level.m_7967_((Entity)dagger);
            relic.spreadExperience((LivingEntity)player, stack, 1);
            if (!level.m_5776_()) {
                NetworkHandler.sendToClients(PacketDistributor.TRACKING_ENTITY.with(() -> dagger), new DesolateDaggerRenderStackPacket(dagger.daggerRenderStack, dagger.m_19879_()));
            }
        }
    }
}

