/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.waila;

import mcp.mobius.waila.api.ITooltipComponent;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BloodComponent
implements ITooltipComponent {
    static final ResourceLocation ICONS = new ResourceLocation("vampirism", "textures/gui/icons.png");
    private final int blood;
    private final int iconCount;
    private final int lineWidth;

    public BloodComponent(int blood, int maxBlood, int maxPerLine) {
        this.blood = blood;
        this.iconCount = Mth.m_184652_((int)Mth.m_14167_((float)Math.max(blood, maxBlood)), (int)2);
        this.lineWidth = Math.min(this.iconCount, maxPerLine);
    }

    public int getWidth() {
        return this.lineWidth * 9 + 1;
    }

    public int getHeight() {
        return Mth.m_184652_((int)this.iconCount, (int)this.lineWidth) * 3 + 6;
    }

    public void render(GuiGraphics ctx, int x, int y, float delta) {
        int filled = this.blood / 2 - 1;
        int half = filled + this.blood % 2;
        for (int i = this.iconCount - 1; i >= 0; --i) {
            int ix = x + i % this.lineWidth * 8;
            int iy = y + i / this.lineWidth * 3;
            ctx.m_280218_(ICONS, ix, iy, 0, 0, 9, 9);
            if (i <= filled) {
                ctx.m_280218_(ICONS, ix, iy, 9, 0, 9, 9);
                continue;
            }
            if (i != half) continue;
            ctx.m_280218_(ICONS, ix, iy, 18, 0, 9, 9);
        }
    }
}

