/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import slimeknights.mantle.command.MantleCommand;
import slimeknights.mantle.command.RegistryArgument;
import slimeknights.mantle.recipe.helper.TagPreference;

public class TagPreferenceCommand {
    private static final String EMPTY_TAG = "command.mantle.tag_preference.empty_tag";
    private static final String PREFERENCE = "command.mantle.tag_preference.preference";

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(1))).then(Commands.m_82129_((String)"type", RegistryArgument.registry()).suggests(MantleCommand.REGISTRY).then(Commands.m_82129_((String)"name", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(MantleCommand.VALID_TAGS).executes(TagPreferenceCommand::run)));
    }

    private static int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return TagPreferenceCommand.runGeneric(context, RegistryArgument.getResult(context, "type"));
    }

    private static <T> int runGeneric(CommandContext<CommandSourceStack> context, Registry<T> registry) {
        ResourceLocation name = (ResourceLocation)context.getArgument("name", ResourceLocation.class);
        TagKey tag = TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)name);
        Object preference = TagPreference.getPreference(tag).orElse(null);
        if (preference == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)EMPTY_TAG, (Object[])new Object[]{registry.m_123023_().m_135782_(), name}), true);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)PREFERENCE, (Object[])new Object[]{registry.m_123023_().m_135782_(), name, registry.m_7981_(preference)}), true);
        return 1;
    }
}

